package io.fabric8.tekton.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ConfigSourceBuilder extends ConfigSourceFluent<ConfigSourceBuilder> implements VisitableBuilder<ConfigSource,ConfigSourceBuilder>{
  public ConfigSourceBuilder() {
    this(new ConfigSource());
  }
  
  public ConfigSourceBuilder(ConfigSourceFluent<?> fluent) {
    this(fluent, new ConfigSource());
  }
  
  public ConfigSourceBuilder(ConfigSourceFluent<?> fluent,ConfigSource instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ConfigSourceBuilder(ConfigSource instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ConfigSourceFluent<?> fluent;
  
  public ConfigSource build() {
    ConfigSource buildable = new ConfigSource(fluent.getDigest(),fluent.getEntryPoint(),fluent.getUri());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}