package io.fabric8.tekton.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class StepActionBuilder extends StepActionFluent<StepActionBuilder> implements VisitableBuilder<StepAction,StepActionBuilder>{
  public StepActionBuilder() {
    this(new StepAction());
  }
  
  public StepActionBuilder(StepActionFluent<?> fluent) {
    this(fluent, new StepAction());
  }
  
  public StepActionBuilder(StepActionFluent<?> fluent,StepAction instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public StepActionBuilder(StepAction instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  StepActionFluent<?> fluent;
  
  public StepAction build() {
    StepAction buildable = new StepAction(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}