package io.fabric8.tekton.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class PipelineResourceBuilder extends PipelineResourceFluent<PipelineResourceBuilder> implements VisitableBuilder<PipelineResource,PipelineResourceBuilder>{
  public PipelineResourceBuilder() {
    this(new PipelineResource());
  }
  
  public PipelineResourceBuilder(PipelineResourceFluent<?> fluent) {
    this(fluent, new PipelineResource());
  }
  
  public PipelineResourceBuilder(PipelineResourceFluent<?> fluent,PipelineResource instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public PipelineResourceBuilder(PipelineResource instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  PipelineResourceFluent<?> fluent;
  
  public PipelineResource build() {
    PipelineResource buildable = new PipelineResource(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}