package io.fabric8.tekton.v1alpha1;

import io.fabric8.kubernetes.api.model.SecretReference;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class KeyRefFluent<A extends KeyRefFluent<A>> extends BaseFluent<A>{
  public KeyRefFluent() {
  }
  
  public KeyRefFluent(KeyRef instance) {
    this.copyInstance(instance);
  }
  private String data;
  private String hashAlgorithm;
  private String kms;
  private SecretReference secretRef;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(KeyRef instance) {
    instance = (instance != null ? instance : new KeyRef());
    if (instance != null) {
          this.withData(instance.getData());
          this.withHashAlgorithm(instance.getHashAlgorithm());
          this.withKms(instance.getKms());
          this.withSecretRef(instance.getSecretRef());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getData() {
    return this.data;
  }
  
  public A withData(String data) {
    this.data = data;
    return (A) this;
  }
  
  public boolean hasData() {
    return this.data != null;
  }
  
  public String getHashAlgorithm() {
    return this.hashAlgorithm;
  }
  
  public A withHashAlgorithm(String hashAlgorithm) {
    this.hashAlgorithm = hashAlgorithm;
    return (A) this;
  }
  
  public boolean hasHashAlgorithm() {
    return this.hashAlgorithm != null;
  }
  
  public String getKms() {
    return this.kms;
  }
  
  public A withKms(String kms) {
    this.kms = kms;
    return (A) this;
  }
  
  public boolean hasKms() {
    return this.kms != null;
  }
  
  public SecretReference getSecretRef() {
    return this.secretRef;
  }
  
  public A withSecretRef(SecretReference secretRef) {
    this.secretRef = secretRef;
    return (A) this;
  }
  
  public boolean hasSecretRef() {
    return this.secretRef != null;
  }
  
  public A withNewSecretRef(String name,String namespace) {
    return (A)withSecretRef(new SecretReference(name, namespace));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KeyRefFluent that = (KeyRefFluent) o;
    if (!java.util.Objects.equals(data, that.data)) return false;
    if (!java.util.Objects.equals(hashAlgorithm, that.hashAlgorithm)) return false;
    if (!java.util.Objects.equals(kms, that.kms)) return false;
    if (!java.util.Objects.equals(secretRef, that.secretRef)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(data,  hashAlgorithm,  kms,  secretRef,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (data != null) { sb.append("data:"); sb.append(data + ","); }
    if (hashAlgorithm != null) { sb.append("hashAlgorithm:"); sb.append(hashAlgorithm + ","); }
    if (kms != null) { sb.append("kms:"); sb.append(kms + ","); }
    if (secretRef != null) { sb.append("secretRef:"); sb.append(secretRef + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}