package io.fabric8.tekton.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class AuthorityBuilder extends AuthorityFluent<AuthorityBuilder> implements VisitableBuilder<Authority,AuthorityBuilder>{
  public AuthorityBuilder() {
    this(new Authority());
  }
  
  public AuthorityBuilder(AuthorityFluent<?> fluent) {
    this(fluent, new Authority());
  }
  
  public AuthorityBuilder(AuthorityFluent<?> fluent,Authority instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public AuthorityBuilder(Authority instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  AuthorityFluent<?> fluent;
  
  public Authority build() {
    Authority buildable = new Authority(fluent.buildKey(),fluent.getName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}