package io.fabric8.tekton.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.tekton.pod.TemplateBuilder;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.tekton.pod.Template;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import io.fabric8.kubernetes.api.model.Duration;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Iterator;
import io.fabric8.tekton.pod.TemplateFluent;
import java.lang.Integer;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class TaskRunSpecFluent<A extends TaskRunSpecFluent<A>> extends BaseFluent<A>{
  public TaskRunSpecFluent() {
  }
  
  public TaskRunSpecFluent(TaskRunSpec instance) {
    this.copyInstance(instance);
  }
  private ResourceRequirementsBuilder computeResources;
  private TaskRunDebugBuilder debug;
  private ArrayList<ParamBuilder> params = new ArrayList<ParamBuilder>();
  private TemplateBuilder podTemplate;
  private Integer retries;
  private String serviceAccountName;
  private ArrayList<TaskRunSidecarSpecBuilder> sidecarSpecs = new ArrayList<TaskRunSidecarSpecBuilder>();
  private String status;
  private String statusMessage;
  private ArrayList<TaskRunStepSpecBuilder> stepSpecs = new ArrayList<TaskRunStepSpecBuilder>();
  private TaskRefBuilder taskRef;
  private TaskSpecBuilder taskSpec;
  private Duration timeout;
  private ArrayList<WorkspaceBindingBuilder> workspaces = new ArrayList<WorkspaceBindingBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(TaskRunSpec instance) {
    instance = (instance != null ? instance : new TaskRunSpec());
    if (instance != null) {
          this.withComputeResources(instance.getComputeResources());
          this.withDebug(instance.getDebug());
          this.withParams(instance.getParams());
          this.withPodTemplate(instance.getPodTemplate());
          this.withRetries(instance.getRetries());
          this.withServiceAccountName(instance.getServiceAccountName());
          this.withSidecarSpecs(instance.getSidecarSpecs());
          this.withStatus(instance.getStatus());
          this.withStatusMessage(instance.getStatusMessage());
          this.withStepSpecs(instance.getStepSpecs());
          this.withTaskRef(instance.getTaskRef());
          this.withTaskSpec(instance.getTaskSpec());
          this.withTimeout(instance.getTimeout());
          this.withWorkspaces(instance.getWorkspaces());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public ResourceRequirements buildComputeResources() {
    return this.computeResources != null ? this.computeResources.build() : null;
  }
  
  public A withComputeResources(ResourceRequirements computeResources) {
    this._visitables.remove("computeResources");
    if (computeResources != null) {
        this.computeResources = new ResourceRequirementsBuilder(computeResources);
        this._visitables.get("computeResources").add(this.computeResources);
    } else {
        this.computeResources = null;
        this._visitables.get("computeResources").remove(this.computeResources);
    }
    return (A) this;
  }
  
  public boolean hasComputeResources() {
    return this.computeResources != null;
  }
  
  public ComputeResourcesNested<A> withNewComputeResources() {
    return new ComputeResourcesNested(null);
  }
  
  public ComputeResourcesNested<A> withNewComputeResourcesLike(ResourceRequirements item) {
    return new ComputeResourcesNested(item);
  }
  
  public ComputeResourcesNested<A> editComputeResources() {
    return withNewComputeResourcesLike(java.util.Optional.ofNullable(buildComputeResources()).orElse(null));
  }
  
  public ComputeResourcesNested<A> editOrNewComputeResources() {
    return withNewComputeResourcesLike(java.util.Optional.ofNullable(buildComputeResources()).orElse(new ResourceRequirementsBuilder().build()));
  }
  
  public ComputeResourcesNested<A> editOrNewComputeResourcesLike(ResourceRequirements item) {
    return withNewComputeResourcesLike(java.util.Optional.ofNullable(buildComputeResources()).orElse(item));
  }
  
  public TaskRunDebug buildDebug() {
    return this.debug != null ? this.debug.build() : null;
  }
  
  public A withDebug(TaskRunDebug debug) {
    this._visitables.remove("debug");
    if (debug != null) {
        this.debug = new TaskRunDebugBuilder(debug);
        this._visitables.get("debug").add(this.debug);
    } else {
        this.debug = null;
        this._visitables.get("debug").remove(this.debug);
    }
    return (A) this;
  }
  
  public boolean hasDebug() {
    return this.debug != null;
  }
  
  public DebugNested<A> withNewDebug() {
    return new DebugNested(null);
  }
  
  public DebugNested<A> withNewDebugLike(TaskRunDebug item) {
    return new DebugNested(item);
  }
  
  public DebugNested<A> editDebug() {
    return withNewDebugLike(java.util.Optional.ofNullable(buildDebug()).orElse(null));
  }
  
  public DebugNested<A> editOrNewDebug() {
    return withNewDebugLike(java.util.Optional.ofNullable(buildDebug()).orElse(new TaskRunDebugBuilder().build()));
  }
  
  public DebugNested<A> editOrNewDebugLike(TaskRunDebug item) {
    return withNewDebugLike(java.util.Optional.ofNullable(buildDebug()).orElse(item));
  }
  
  public A addToParams(int index,Param item) {
    if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
    ParamBuilder builder = new ParamBuilder(item);
    if (index < 0 || index >= params.size()) {
        _visitables.get("params").add(builder);
        params.add(builder);
    } else {
        _visitables.get("params").add(builder);
        params.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToParams(int index,Param item) {
    if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
    ParamBuilder builder = new ParamBuilder(item);
    if (index < 0 || index >= params.size()) {
        _visitables.get("params").add(builder);
        params.add(builder);
    } else {
        _visitables.get("params").add(builder);
        params.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToParams(io.fabric8.tekton.v1.Param... items) {
    if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
    for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").add(builder);this.params.add(builder);} return (A)this;
  }
  
  public A addAllToParams(Collection<Param> items) {
    if (this.params == null) {this.params = new ArrayList<ParamBuilder>();}
    for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").add(builder);this.params.add(builder);} return (A)this;
  }
  
  public A removeFromParams(io.fabric8.tekton.v1.Param... items) {
    if (this.params == null) return (A)this;
    for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").remove(builder); this.params.remove(builder);} return (A)this;
  }
  
  public A removeAllFromParams(Collection<Param> items) {
    if (this.params == null) return (A)this;
    for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("params").remove(builder); this.params.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromParams(Predicate<ParamBuilder> predicate) {
    if (params == null) return (A) this;
    final Iterator<ParamBuilder> each = params.iterator();
    final List visitables = _visitables.get("params");
    while (each.hasNext()) {
      ParamBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Param> buildParams() {
    return this.params != null ? build(params) : null;
  }
  
  public Param buildParam(int index) {
    return this.params.get(index).build();
  }
  
  public Param buildFirstParam() {
    return this.params.get(0).build();
  }
  
  public Param buildLastParam() {
    return this.params.get(params.size() - 1).build();
  }
  
  public Param buildMatchingParam(Predicate<ParamBuilder> predicate) {
      for (ParamBuilder item : params) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingParam(Predicate<ParamBuilder> predicate) {
      for (ParamBuilder item : params) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withParams(List<Param> params) {
    if (this.params != null) {
      this._visitables.get("params").clear();
    }
    if (params != null) {
        this.params = new ArrayList();
        for (Param item : params) {
          this.addToParams(item);
        }
    } else {
      this.params = null;
    }
    return (A) this;
  }
  
  public A withParams(io.fabric8.tekton.v1.Param... params) {
    if (this.params != null) {
        this.params.clear();
        _visitables.remove("params");
    }
    if (params != null) {
      for (Param item : params) {
        this.addToParams(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasParams() {
    return this.params != null && !this.params.isEmpty();
  }
  
  public ParamsNested<A> addNewParam() {
    return new ParamsNested(-1, null);
  }
  
  public ParamsNested<A> addNewParamLike(Param item) {
    return new ParamsNested(-1, item);
  }
  
  public ParamsNested<A> setNewParamLike(int index,Param item) {
    return new ParamsNested(index, item);
  }
  
  public ParamsNested<A> editParam(int index) {
    if (params.size() <= index) throw new RuntimeException("Can't edit params. Index exceeds size.");
    return setNewParamLike(index, buildParam(index));
  }
  
  public ParamsNested<A> editFirstParam() {
    if (params.size() == 0) throw new RuntimeException("Can't edit first params. The list is empty.");
    return setNewParamLike(0, buildParam(0));
  }
  
  public ParamsNested<A> editLastParam() {
    int index = params.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last params. The list is empty.");
    return setNewParamLike(index, buildParam(index));
  }
  
  public ParamsNested<A> editMatchingParam(Predicate<ParamBuilder> predicate) {
    int index = -1;
    for (int i=0;i<params.size();i++) { 
    if (predicate.test(params.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching params. No match found.");
    return setNewParamLike(index, buildParam(index));
  }
  
  public Template buildPodTemplate() {
    return this.podTemplate != null ? this.podTemplate.build() : null;
  }
  
  public A withPodTemplate(Template podTemplate) {
    this._visitables.remove("podTemplate");
    if (podTemplate != null) {
        this.podTemplate = new TemplateBuilder(podTemplate);
        this._visitables.get("podTemplate").add(this.podTemplate);
    } else {
        this.podTemplate = null;
        this._visitables.get("podTemplate").remove(this.podTemplate);
    }
    return (A) this;
  }
  
  public boolean hasPodTemplate() {
    return this.podTemplate != null;
  }
  
  public PodTemplateNested<A> withNewPodTemplate() {
    return new PodTemplateNested(null);
  }
  
  public PodTemplateNested<A> withNewPodTemplateLike(Template item) {
    return new PodTemplateNested(item);
  }
  
  public PodTemplateNested<A> editPodTemplate() {
    return withNewPodTemplateLike(java.util.Optional.ofNullable(buildPodTemplate()).orElse(null));
  }
  
  public PodTemplateNested<A> editOrNewPodTemplate() {
    return withNewPodTemplateLike(java.util.Optional.ofNullable(buildPodTemplate()).orElse(new TemplateBuilder().build()));
  }
  
  public PodTemplateNested<A> editOrNewPodTemplateLike(Template item) {
    return withNewPodTemplateLike(java.util.Optional.ofNullable(buildPodTemplate()).orElse(item));
  }
  
  public Integer getRetries() {
    return this.retries;
  }
  
  public A withRetries(Integer retries) {
    this.retries = retries;
    return (A) this;
  }
  
  public boolean hasRetries() {
    return this.retries != null;
  }
  
  public String getServiceAccountName() {
    return this.serviceAccountName;
  }
  
  public A withServiceAccountName(String serviceAccountName) {
    this.serviceAccountName = serviceAccountName;
    return (A) this;
  }
  
  public boolean hasServiceAccountName() {
    return this.serviceAccountName != null;
  }
  
  public A addToSidecarSpecs(int index,TaskRunSidecarSpec item) {
    if (this.sidecarSpecs == null) {this.sidecarSpecs = new ArrayList<TaskRunSidecarSpecBuilder>();}
    TaskRunSidecarSpecBuilder builder = new TaskRunSidecarSpecBuilder(item);
    if (index < 0 || index >= sidecarSpecs.size()) {
        _visitables.get("sidecarSpecs").add(builder);
        sidecarSpecs.add(builder);
    } else {
        _visitables.get("sidecarSpecs").add(builder);
        sidecarSpecs.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToSidecarSpecs(int index,TaskRunSidecarSpec item) {
    if (this.sidecarSpecs == null) {this.sidecarSpecs = new ArrayList<TaskRunSidecarSpecBuilder>();}
    TaskRunSidecarSpecBuilder builder = new TaskRunSidecarSpecBuilder(item);
    if (index < 0 || index >= sidecarSpecs.size()) {
        _visitables.get("sidecarSpecs").add(builder);
        sidecarSpecs.add(builder);
    } else {
        _visitables.get("sidecarSpecs").add(builder);
        sidecarSpecs.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToSidecarSpecs(io.fabric8.tekton.v1.TaskRunSidecarSpec... items) {
    if (this.sidecarSpecs == null) {this.sidecarSpecs = new ArrayList<TaskRunSidecarSpecBuilder>();}
    for (TaskRunSidecarSpec item : items) {TaskRunSidecarSpecBuilder builder = new TaskRunSidecarSpecBuilder(item);_visitables.get("sidecarSpecs").add(builder);this.sidecarSpecs.add(builder);} return (A)this;
  }
  
  public A addAllToSidecarSpecs(Collection<TaskRunSidecarSpec> items) {
    if (this.sidecarSpecs == null) {this.sidecarSpecs = new ArrayList<TaskRunSidecarSpecBuilder>();}
    for (TaskRunSidecarSpec item : items) {TaskRunSidecarSpecBuilder builder = new TaskRunSidecarSpecBuilder(item);_visitables.get("sidecarSpecs").add(builder);this.sidecarSpecs.add(builder);} return (A)this;
  }
  
  public A removeFromSidecarSpecs(io.fabric8.tekton.v1.TaskRunSidecarSpec... items) {
    if (this.sidecarSpecs == null) return (A)this;
    for (TaskRunSidecarSpec item : items) {TaskRunSidecarSpecBuilder builder = new TaskRunSidecarSpecBuilder(item);_visitables.get("sidecarSpecs").remove(builder); this.sidecarSpecs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromSidecarSpecs(Collection<TaskRunSidecarSpec> items) {
    if (this.sidecarSpecs == null) return (A)this;
    for (TaskRunSidecarSpec item : items) {TaskRunSidecarSpecBuilder builder = new TaskRunSidecarSpecBuilder(item);_visitables.get("sidecarSpecs").remove(builder); this.sidecarSpecs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromSidecarSpecs(Predicate<TaskRunSidecarSpecBuilder> predicate) {
    if (sidecarSpecs == null) return (A) this;
    final Iterator<TaskRunSidecarSpecBuilder> each = sidecarSpecs.iterator();
    final List visitables = _visitables.get("sidecarSpecs");
    while (each.hasNext()) {
      TaskRunSidecarSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<TaskRunSidecarSpec> buildSidecarSpecs() {
    return this.sidecarSpecs != null ? build(sidecarSpecs) : null;
  }
  
  public TaskRunSidecarSpec buildSidecarSpec(int index) {
    return this.sidecarSpecs.get(index).build();
  }
  
  public TaskRunSidecarSpec buildFirstSidecarSpec() {
    return this.sidecarSpecs.get(0).build();
  }
  
  public TaskRunSidecarSpec buildLastSidecarSpec() {
    return this.sidecarSpecs.get(sidecarSpecs.size() - 1).build();
  }
  
  public TaskRunSidecarSpec buildMatchingSidecarSpec(Predicate<TaskRunSidecarSpecBuilder> predicate) {
      for (TaskRunSidecarSpecBuilder item : sidecarSpecs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingSidecarSpec(Predicate<TaskRunSidecarSpecBuilder> predicate) {
      for (TaskRunSidecarSpecBuilder item : sidecarSpecs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withSidecarSpecs(List<TaskRunSidecarSpec> sidecarSpecs) {
    if (this.sidecarSpecs != null) {
      this._visitables.get("sidecarSpecs").clear();
    }
    if (sidecarSpecs != null) {
        this.sidecarSpecs = new ArrayList();
        for (TaskRunSidecarSpec item : sidecarSpecs) {
          this.addToSidecarSpecs(item);
        }
    } else {
      this.sidecarSpecs = null;
    }
    return (A) this;
  }
  
  public A withSidecarSpecs(io.fabric8.tekton.v1.TaskRunSidecarSpec... sidecarSpecs) {
    if (this.sidecarSpecs != null) {
        this.sidecarSpecs.clear();
        _visitables.remove("sidecarSpecs");
    }
    if (sidecarSpecs != null) {
      for (TaskRunSidecarSpec item : sidecarSpecs) {
        this.addToSidecarSpecs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasSidecarSpecs() {
    return this.sidecarSpecs != null && !this.sidecarSpecs.isEmpty();
  }
  
  public SidecarSpecsNested<A> addNewSidecarSpec() {
    return new SidecarSpecsNested(-1, null);
  }
  
  public SidecarSpecsNested<A> addNewSidecarSpecLike(TaskRunSidecarSpec item) {
    return new SidecarSpecsNested(-1, item);
  }
  
  public SidecarSpecsNested<A> setNewSidecarSpecLike(int index,TaskRunSidecarSpec item) {
    return new SidecarSpecsNested(index, item);
  }
  
  public SidecarSpecsNested<A> editSidecarSpec(int index) {
    if (sidecarSpecs.size() <= index) throw new RuntimeException("Can't edit sidecarSpecs. Index exceeds size.");
    return setNewSidecarSpecLike(index, buildSidecarSpec(index));
  }
  
  public SidecarSpecsNested<A> editFirstSidecarSpec() {
    if (sidecarSpecs.size() == 0) throw new RuntimeException("Can't edit first sidecarSpecs. The list is empty.");
    return setNewSidecarSpecLike(0, buildSidecarSpec(0));
  }
  
  public SidecarSpecsNested<A> editLastSidecarSpec() {
    int index = sidecarSpecs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last sidecarSpecs. The list is empty.");
    return setNewSidecarSpecLike(index, buildSidecarSpec(index));
  }
  
  public SidecarSpecsNested<A> editMatchingSidecarSpec(Predicate<TaskRunSidecarSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<sidecarSpecs.size();i++) { 
    if (predicate.test(sidecarSpecs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching sidecarSpecs. No match found.");
    return setNewSidecarSpecLike(index, buildSidecarSpec(index));
  }
  
  public String getStatus() {
    return this.status;
  }
  
  public A withStatus(String status) {
    this.status = status;
    return (A) this;
  }
  
  public boolean hasStatus() {
    return this.status != null;
  }
  
  public String getStatusMessage() {
    return this.statusMessage;
  }
  
  public A withStatusMessage(String statusMessage) {
    this.statusMessage = statusMessage;
    return (A) this;
  }
  
  public boolean hasStatusMessage() {
    return this.statusMessage != null;
  }
  
  public A addToStepSpecs(int index,TaskRunStepSpec item) {
    if (this.stepSpecs == null) {this.stepSpecs = new ArrayList<TaskRunStepSpecBuilder>();}
    TaskRunStepSpecBuilder builder = new TaskRunStepSpecBuilder(item);
    if (index < 0 || index >= stepSpecs.size()) {
        _visitables.get("stepSpecs").add(builder);
        stepSpecs.add(builder);
    } else {
        _visitables.get("stepSpecs").add(builder);
        stepSpecs.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToStepSpecs(int index,TaskRunStepSpec item) {
    if (this.stepSpecs == null) {this.stepSpecs = new ArrayList<TaskRunStepSpecBuilder>();}
    TaskRunStepSpecBuilder builder = new TaskRunStepSpecBuilder(item);
    if (index < 0 || index >= stepSpecs.size()) {
        _visitables.get("stepSpecs").add(builder);
        stepSpecs.add(builder);
    } else {
        _visitables.get("stepSpecs").add(builder);
        stepSpecs.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToStepSpecs(io.fabric8.tekton.v1.TaskRunStepSpec... items) {
    if (this.stepSpecs == null) {this.stepSpecs = new ArrayList<TaskRunStepSpecBuilder>();}
    for (TaskRunStepSpec item : items) {TaskRunStepSpecBuilder builder = new TaskRunStepSpecBuilder(item);_visitables.get("stepSpecs").add(builder);this.stepSpecs.add(builder);} return (A)this;
  }
  
  public A addAllToStepSpecs(Collection<TaskRunStepSpec> items) {
    if (this.stepSpecs == null) {this.stepSpecs = new ArrayList<TaskRunStepSpecBuilder>();}
    for (TaskRunStepSpec item : items) {TaskRunStepSpecBuilder builder = new TaskRunStepSpecBuilder(item);_visitables.get("stepSpecs").add(builder);this.stepSpecs.add(builder);} return (A)this;
  }
  
  public A removeFromStepSpecs(io.fabric8.tekton.v1.TaskRunStepSpec... items) {
    if (this.stepSpecs == null) return (A)this;
    for (TaskRunStepSpec item : items) {TaskRunStepSpecBuilder builder = new TaskRunStepSpecBuilder(item);_visitables.get("stepSpecs").remove(builder); this.stepSpecs.remove(builder);} return (A)this;
  }
  
  public A removeAllFromStepSpecs(Collection<TaskRunStepSpec> items) {
    if (this.stepSpecs == null) return (A)this;
    for (TaskRunStepSpec item : items) {TaskRunStepSpecBuilder builder = new TaskRunStepSpecBuilder(item);_visitables.get("stepSpecs").remove(builder); this.stepSpecs.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromStepSpecs(Predicate<TaskRunStepSpecBuilder> predicate) {
    if (stepSpecs == null) return (A) this;
    final Iterator<TaskRunStepSpecBuilder> each = stepSpecs.iterator();
    final List visitables = _visitables.get("stepSpecs");
    while (each.hasNext()) {
      TaskRunStepSpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<TaskRunStepSpec> buildStepSpecs() {
    return this.stepSpecs != null ? build(stepSpecs) : null;
  }
  
  public TaskRunStepSpec buildStepSpec(int index) {
    return this.stepSpecs.get(index).build();
  }
  
  public TaskRunStepSpec buildFirstStepSpec() {
    return this.stepSpecs.get(0).build();
  }
  
  public TaskRunStepSpec buildLastStepSpec() {
    return this.stepSpecs.get(stepSpecs.size() - 1).build();
  }
  
  public TaskRunStepSpec buildMatchingStepSpec(Predicate<TaskRunStepSpecBuilder> predicate) {
      for (TaskRunStepSpecBuilder item : stepSpecs) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingStepSpec(Predicate<TaskRunStepSpecBuilder> predicate) {
      for (TaskRunStepSpecBuilder item : stepSpecs) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withStepSpecs(List<TaskRunStepSpec> stepSpecs) {
    if (this.stepSpecs != null) {
      this._visitables.get("stepSpecs").clear();
    }
    if (stepSpecs != null) {
        this.stepSpecs = new ArrayList();
        for (TaskRunStepSpec item : stepSpecs) {
          this.addToStepSpecs(item);
        }
    } else {
      this.stepSpecs = null;
    }
    return (A) this;
  }
  
  public A withStepSpecs(io.fabric8.tekton.v1.TaskRunStepSpec... stepSpecs) {
    if (this.stepSpecs != null) {
        this.stepSpecs.clear();
        _visitables.remove("stepSpecs");
    }
    if (stepSpecs != null) {
      for (TaskRunStepSpec item : stepSpecs) {
        this.addToStepSpecs(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasStepSpecs() {
    return this.stepSpecs != null && !this.stepSpecs.isEmpty();
  }
  
  public StepSpecsNested<A> addNewStepSpec() {
    return new StepSpecsNested(-1, null);
  }
  
  public StepSpecsNested<A> addNewStepSpecLike(TaskRunStepSpec item) {
    return new StepSpecsNested(-1, item);
  }
  
  public StepSpecsNested<A> setNewStepSpecLike(int index,TaskRunStepSpec item) {
    return new StepSpecsNested(index, item);
  }
  
  public StepSpecsNested<A> editStepSpec(int index) {
    if (stepSpecs.size() <= index) throw new RuntimeException("Can't edit stepSpecs. Index exceeds size.");
    return setNewStepSpecLike(index, buildStepSpec(index));
  }
  
  public StepSpecsNested<A> editFirstStepSpec() {
    if (stepSpecs.size() == 0) throw new RuntimeException("Can't edit first stepSpecs. The list is empty.");
    return setNewStepSpecLike(0, buildStepSpec(0));
  }
  
  public StepSpecsNested<A> editLastStepSpec() {
    int index = stepSpecs.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last stepSpecs. The list is empty.");
    return setNewStepSpecLike(index, buildStepSpec(index));
  }
  
  public StepSpecsNested<A> editMatchingStepSpec(Predicate<TaskRunStepSpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<stepSpecs.size();i++) { 
    if (predicate.test(stepSpecs.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching stepSpecs. No match found.");
    return setNewStepSpecLike(index, buildStepSpec(index));
  }
  
  public TaskRef buildTaskRef() {
    return this.taskRef != null ? this.taskRef.build() : null;
  }
  
  public A withTaskRef(TaskRef taskRef) {
    this._visitables.remove("taskRef");
    if (taskRef != null) {
        this.taskRef = new TaskRefBuilder(taskRef);
        this._visitables.get("taskRef").add(this.taskRef);
    } else {
        this.taskRef = null;
        this._visitables.get("taskRef").remove(this.taskRef);
    }
    return (A) this;
  }
  
  public boolean hasTaskRef() {
    return this.taskRef != null;
  }
  
  public A withNewTaskRef(String apiVersion,String kind,String name) {
    return (A)withTaskRef(new TaskRef(apiVersion, kind, name));
  }
  
  public TaskRefNested<A> withNewTaskRef() {
    return new TaskRefNested(null);
  }
  
  public TaskRefNested<A> withNewTaskRefLike(TaskRef item) {
    return new TaskRefNested(item);
  }
  
  public TaskRefNested<A> editTaskRef() {
    return withNewTaskRefLike(java.util.Optional.ofNullable(buildTaskRef()).orElse(null));
  }
  
  public TaskRefNested<A> editOrNewTaskRef() {
    return withNewTaskRefLike(java.util.Optional.ofNullable(buildTaskRef()).orElse(new TaskRefBuilder().build()));
  }
  
  public TaskRefNested<A> editOrNewTaskRefLike(TaskRef item) {
    return withNewTaskRefLike(java.util.Optional.ofNullable(buildTaskRef()).orElse(item));
  }
  
  public TaskSpec buildTaskSpec() {
    return this.taskSpec != null ? this.taskSpec.build() : null;
  }
  
  public A withTaskSpec(TaskSpec taskSpec) {
    this._visitables.remove("taskSpec");
    if (taskSpec != null) {
        this.taskSpec = new TaskSpecBuilder(taskSpec);
        this._visitables.get("taskSpec").add(this.taskSpec);
    } else {
        this.taskSpec = null;
        this._visitables.get("taskSpec").remove(this.taskSpec);
    }
    return (A) this;
  }
  
  public boolean hasTaskSpec() {
    return this.taskSpec != null;
  }
  
  public TaskSpecNested<A> withNewTaskSpec() {
    return new TaskSpecNested(null);
  }
  
  public TaskSpecNested<A> withNewTaskSpecLike(TaskSpec item) {
    return new TaskSpecNested(item);
  }
  
  public TaskSpecNested<A> editTaskSpec() {
    return withNewTaskSpecLike(java.util.Optional.ofNullable(buildTaskSpec()).orElse(null));
  }
  
  public TaskSpecNested<A> editOrNewTaskSpec() {
    return withNewTaskSpecLike(java.util.Optional.ofNullable(buildTaskSpec()).orElse(new TaskSpecBuilder().build()));
  }
  
  public TaskSpecNested<A> editOrNewTaskSpecLike(TaskSpec item) {
    return withNewTaskSpecLike(java.util.Optional.ofNullable(buildTaskSpec()).orElse(item));
  }
  
  public Duration getTimeout() {
    return this.timeout;
  }
  
  public A withTimeout(Duration timeout) {
    this.timeout = timeout;
    return (A) this;
  }
  
  public boolean hasTimeout() {
    return this.timeout != null;
  }
  
  public A addToWorkspaces(int index,WorkspaceBinding item) {
    if (this.workspaces == null) {this.workspaces = new ArrayList<WorkspaceBindingBuilder>();}
    WorkspaceBindingBuilder builder = new WorkspaceBindingBuilder(item);
    if (index < 0 || index >= workspaces.size()) {
        _visitables.get("workspaces").add(builder);
        workspaces.add(builder);
    } else {
        _visitables.get("workspaces").add(builder);
        workspaces.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToWorkspaces(int index,WorkspaceBinding item) {
    if (this.workspaces == null) {this.workspaces = new ArrayList<WorkspaceBindingBuilder>();}
    WorkspaceBindingBuilder builder = new WorkspaceBindingBuilder(item);
    if (index < 0 || index >= workspaces.size()) {
        _visitables.get("workspaces").add(builder);
        workspaces.add(builder);
    } else {
        _visitables.get("workspaces").add(builder);
        workspaces.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToWorkspaces(io.fabric8.tekton.v1.WorkspaceBinding... items) {
    if (this.workspaces == null) {this.workspaces = new ArrayList<WorkspaceBindingBuilder>();}
    for (WorkspaceBinding item : items) {WorkspaceBindingBuilder builder = new WorkspaceBindingBuilder(item);_visitables.get("workspaces").add(builder);this.workspaces.add(builder);} return (A)this;
  }
  
  public A addAllToWorkspaces(Collection<WorkspaceBinding> items) {
    if (this.workspaces == null) {this.workspaces = new ArrayList<WorkspaceBindingBuilder>();}
    for (WorkspaceBinding item : items) {WorkspaceBindingBuilder builder = new WorkspaceBindingBuilder(item);_visitables.get("workspaces").add(builder);this.workspaces.add(builder);} return (A)this;
  }
  
  public A removeFromWorkspaces(io.fabric8.tekton.v1.WorkspaceBinding... items) {
    if (this.workspaces == null) return (A)this;
    for (WorkspaceBinding item : items) {WorkspaceBindingBuilder builder = new WorkspaceBindingBuilder(item);_visitables.get("workspaces").remove(builder); this.workspaces.remove(builder);} return (A)this;
  }
  
  public A removeAllFromWorkspaces(Collection<WorkspaceBinding> items) {
    if (this.workspaces == null) return (A)this;
    for (WorkspaceBinding item : items) {WorkspaceBindingBuilder builder = new WorkspaceBindingBuilder(item);_visitables.get("workspaces").remove(builder); this.workspaces.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromWorkspaces(Predicate<WorkspaceBindingBuilder> predicate) {
    if (workspaces == null) return (A) this;
    final Iterator<WorkspaceBindingBuilder> each = workspaces.iterator();
    final List visitables = _visitables.get("workspaces");
    while (each.hasNext()) {
      WorkspaceBindingBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<WorkspaceBinding> buildWorkspaces() {
    return this.workspaces != null ? build(workspaces) : null;
  }
  
  public WorkspaceBinding buildWorkspace(int index) {
    return this.workspaces.get(index).build();
  }
  
  public WorkspaceBinding buildFirstWorkspace() {
    return this.workspaces.get(0).build();
  }
  
  public WorkspaceBinding buildLastWorkspace() {
    return this.workspaces.get(workspaces.size() - 1).build();
  }
  
  public WorkspaceBinding buildMatchingWorkspace(Predicate<WorkspaceBindingBuilder> predicate) {
      for (WorkspaceBindingBuilder item : workspaces) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingWorkspace(Predicate<WorkspaceBindingBuilder> predicate) {
      for (WorkspaceBindingBuilder item : workspaces) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withWorkspaces(List<WorkspaceBinding> workspaces) {
    if (this.workspaces != null) {
      this._visitables.get("workspaces").clear();
    }
    if (workspaces != null) {
        this.workspaces = new ArrayList();
        for (WorkspaceBinding item : workspaces) {
          this.addToWorkspaces(item);
        }
    } else {
      this.workspaces = null;
    }
    return (A) this;
  }
  
  public A withWorkspaces(io.fabric8.tekton.v1.WorkspaceBinding... workspaces) {
    if (this.workspaces != null) {
        this.workspaces.clear();
        _visitables.remove("workspaces");
    }
    if (workspaces != null) {
      for (WorkspaceBinding item : workspaces) {
        this.addToWorkspaces(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasWorkspaces() {
    return this.workspaces != null && !this.workspaces.isEmpty();
  }
  
  public WorkspacesNested<A> addNewWorkspace() {
    return new WorkspacesNested(-1, null);
  }
  
  public WorkspacesNested<A> addNewWorkspaceLike(WorkspaceBinding item) {
    return new WorkspacesNested(-1, item);
  }
  
  public WorkspacesNested<A> setNewWorkspaceLike(int index,WorkspaceBinding item) {
    return new WorkspacesNested(index, item);
  }
  
  public WorkspacesNested<A> editWorkspace(int index) {
    if (workspaces.size() <= index) throw new RuntimeException("Can't edit workspaces. Index exceeds size.");
    return setNewWorkspaceLike(index, buildWorkspace(index));
  }
  
  public WorkspacesNested<A> editFirstWorkspace() {
    if (workspaces.size() == 0) throw new RuntimeException("Can't edit first workspaces. The list is empty.");
    return setNewWorkspaceLike(0, buildWorkspace(0));
  }
  
  public WorkspacesNested<A> editLastWorkspace() {
    int index = workspaces.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last workspaces. The list is empty.");
    return setNewWorkspaceLike(index, buildWorkspace(index));
  }
  
  public WorkspacesNested<A> editMatchingWorkspace(Predicate<WorkspaceBindingBuilder> predicate) {
    int index = -1;
    for (int i=0;i<workspaces.size();i++) { 
    if (predicate.test(workspaces.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching workspaces. No match found.");
    return setNewWorkspaceLike(index, buildWorkspace(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TaskRunSpecFluent that = (TaskRunSpecFluent) o;
    if (!java.util.Objects.equals(computeResources, that.computeResources)) return false;
    if (!java.util.Objects.equals(debug, that.debug)) return false;
    if (!java.util.Objects.equals(params, that.params)) return false;
    if (!java.util.Objects.equals(podTemplate, that.podTemplate)) return false;
    if (!java.util.Objects.equals(retries, that.retries)) return false;
    if (!java.util.Objects.equals(serviceAccountName, that.serviceAccountName)) return false;
    if (!java.util.Objects.equals(sidecarSpecs, that.sidecarSpecs)) return false;
    if (!java.util.Objects.equals(status, that.status)) return false;
    if (!java.util.Objects.equals(statusMessage, that.statusMessage)) return false;
    if (!java.util.Objects.equals(stepSpecs, that.stepSpecs)) return false;
    if (!java.util.Objects.equals(taskRef, that.taskRef)) return false;
    if (!java.util.Objects.equals(taskSpec, that.taskSpec)) return false;
    if (!java.util.Objects.equals(timeout, that.timeout)) return false;
    if (!java.util.Objects.equals(workspaces, that.workspaces)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(computeResources,  debug,  params,  podTemplate,  retries,  serviceAccountName,  sidecarSpecs,  status,  statusMessage,  stepSpecs,  taskRef,  taskSpec,  timeout,  workspaces,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (computeResources != null) { sb.append("computeResources:"); sb.append(computeResources + ","); }
    if (debug != null) { sb.append("debug:"); sb.append(debug + ","); }
    if (params != null && !params.isEmpty()) { sb.append("params:"); sb.append(params + ","); }
    if (podTemplate != null) { sb.append("podTemplate:"); sb.append(podTemplate + ","); }
    if (retries != null) { sb.append("retries:"); sb.append(retries + ","); }
    if (serviceAccountName != null) { sb.append("serviceAccountName:"); sb.append(serviceAccountName + ","); }
    if (sidecarSpecs != null && !sidecarSpecs.isEmpty()) { sb.append("sidecarSpecs:"); sb.append(sidecarSpecs + ","); }
    if (status != null) { sb.append("status:"); sb.append(status + ","); }
    if (statusMessage != null) { sb.append("statusMessage:"); sb.append(statusMessage + ","); }
    if (stepSpecs != null && !stepSpecs.isEmpty()) { sb.append("stepSpecs:"); sb.append(stepSpecs + ","); }
    if (taskRef != null) { sb.append("taskRef:"); sb.append(taskRef + ","); }
    if (taskSpec != null) { sb.append("taskSpec:"); sb.append(taskSpec + ","); }
    if (timeout != null) { sb.append("timeout:"); sb.append(timeout + ","); }
    if (workspaces != null && !workspaces.isEmpty()) { sb.append("workspaces:"); sb.append(workspaces + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ComputeResourcesNested<N> extends ResourceRequirementsFluent<ComputeResourcesNested<N>> implements Nested<N>{
    ComputeResourcesNested(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourceRequirementsBuilder builder;
    
    public N and() {
      return (N) TaskRunSpecFluent.this.withComputeResources(builder.build());
    }
    
    public N endComputeResources() {
      return and();
    }
    
  
  }
  public class DebugNested<N> extends TaskRunDebugFluent<DebugNested<N>> implements Nested<N>{
    DebugNested(TaskRunDebug item) {
      this.builder = new TaskRunDebugBuilder(this, item);
    }
    TaskRunDebugBuilder builder;
    
    public N and() {
      return (N) TaskRunSpecFluent.this.withDebug(builder.build());
    }
    
    public N endDebug() {
      return and();
    }
    
  
  }
  public class ParamsNested<N> extends ParamFluent<ParamsNested<N>> implements Nested<N>{
    ParamsNested(int index,Param item) {
      this.index = index;
      this.builder = new ParamBuilder(this, item);
    }
    ParamBuilder builder;
    int index;
    
    public N and() {
      return (N) TaskRunSpecFluent.this.setToParams(index,builder.build());
    }
    
    public N endParam() {
      return and();
    }
    
  
  }
  public class PodTemplateNested<N> extends TemplateFluent<PodTemplateNested<N>> implements Nested<N>{
    PodTemplateNested(Template item) {
      this.builder = new TemplateBuilder(this, item);
    }
    TemplateBuilder builder;
    
    public N and() {
      return (N) TaskRunSpecFluent.this.withPodTemplate(builder.build());
    }
    
    public N endPodTemplate() {
      return and();
    }
    
  
  }
  public class SidecarSpecsNested<N> extends TaskRunSidecarSpecFluent<SidecarSpecsNested<N>> implements Nested<N>{
    SidecarSpecsNested(int index,TaskRunSidecarSpec item) {
      this.index = index;
      this.builder = new TaskRunSidecarSpecBuilder(this, item);
    }
    TaskRunSidecarSpecBuilder builder;
    int index;
    
    public N and() {
      return (N) TaskRunSpecFluent.this.setToSidecarSpecs(index,builder.build());
    }
    
    public N endSidecarSpec() {
      return and();
    }
    
  
  }
  public class StepSpecsNested<N> extends TaskRunStepSpecFluent<StepSpecsNested<N>> implements Nested<N>{
    StepSpecsNested(int index,TaskRunStepSpec item) {
      this.index = index;
      this.builder = new TaskRunStepSpecBuilder(this, item);
    }
    TaskRunStepSpecBuilder builder;
    int index;
    
    public N and() {
      return (N) TaskRunSpecFluent.this.setToStepSpecs(index,builder.build());
    }
    
    public N endStepSpec() {
      return and();
    }
    
  
  }
  public class TaskRefNested<N> extends TaskRefFluent<TaskRefNested<N>> implements Nested<N>{
    TaskRefNested(TaskRef item) {
      this.builder = new TaskRefBuilder(this, item);
    }
    TaskRefBuilder builder;
    
    public N and() {
      return (N) TaskRunSpecFluent.this.withTaskRef(builder.build());
    }
    
    public N endTaskRef() {
      return and();
    }
    
  
  }
  public class TaskSpecNested<N> extends TaskSpecFluent<TaskSpecNested<N>> implements Nested<N>{
    TaskSpecNested(TaskSpec item) {
      this.builder = new TaskSpecBuilder(this, item);
    }
    TaskSpecBuilder builder;
    
    public N and() {
      return (N) TaskRunSpecFluent.this.withTaskSpec(builder.build());
    }
    
    public N endTaskSpec() {
      return and();
    }
    
  
  }
  public class WorkspacesNested<N> extends WorkspaceBindingFluent<WorkspacesNested<N>> implements Nested<N>{
    WorkspacesNested(int index,WorkspaceBinding item) {
      this.index = index;
      this.builder = new WorkspaceBindingBuilder(this, item);
    }
    WorkspaceBindingBuilder builder;
    int index;
    
    public N and() {
      return (N) TaskRunSpecFluent.this.setToWorkspaces(index,builder.build());
    }
    
    public N endWorkspace() {
      return and();
    }
    
  
  }

}