package io.fabric8.tekton.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class StepStateBuilder extends StepStateFluent<StepStateBuilder> implements VisitableBuilder<StepState,StepStateBuilder>{
  public StepStateBuilder() {
    this(new StepState());
  }
  
  public StepStateBuilder(StepStateFluent<?> fluent) {
    this(fluent, new StepState());
  }
  
  public StepStateBuilder(StepStateFluent<?> fluent,StepState instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public StepStateBuilder(StepState instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  StepStateFluent<?> fluent;
  
  public StepState build() {
    StepState buildable = new StepState(fluent.getContainer(),fluent.getImageID(),fluent.buildInputs(),fluent.getName(),fluent.buildOutputs(),fluent.buildProvenance(),fluent.buildResults(),fluent.getRunning(),fluent.getTerminated(),fluent.getTerminationReason(),fluent.getWaiting());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}