package io.fabric8.tekton.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class StepResultBuilder extends StepResultFluent<StepResultBuilder> implements VisitableBuilder<StepResult,StepResultBuilder>{
  public StepResultBuilder() {
    this(new StepResult());
  }
  
  public StepResultBuilder(StepResultFluent<?> fluent) {
    this(fluent, new StepResult());
  }
  
  public StepResultBuilder(StepResultFluent<?> fluent,StepResult instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public StepResultBuilder(StepResult instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  StepResultFluent<?> fluent;
  
  public StepResult build() {
    StepResult buildable = new StepResult(fluent.getDescription(),fluent.getName(),fluent.getProperties(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}