package io.fabric8.tekton.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class StepBuilder extends StepFluent<StepBuilder> implements VisitableBuilder<Step,StepBuilder>{
  public StepBuilder() {
    this(new Step());
  }
  
  public StepBuilder(StepFluent<?> fluent) {
    this(fluent, new Step());
  }
  
  public StepBuilder(StepFluent<?> fluent,Step instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public StepBuilder(Step instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  StepFluent<?> fluent;
  
  public Step build() {
    Step buildable = new Step(fluent.getArgs(),fluent.getCommand(),fluent.buildComputeResources(),fluent.buildEnv(),fluent.getEnvFrom(),fluent.getImage(),fluent.getImagePullPolicy(),fluent.getName(),fluent.getOnError(),fluent.buildParams(),fluent.buildRef(),fluent.buildResults(),fluent.getScript(),fluent.getSecurityContext(),fluent.buildStderrConfig(),fluent.buildStdoutConfig(),fluent.getTimeout(),fluent.getVolumeDevices(),fluent.buildVolumeMounts(),fluent.buildWhen(),fluent.getWorkingDir(),fluent.buildWorkspaces());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}