package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.tekton.v1beta1.ParamBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.tekton.v1beta1.ParamFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.tekton.v1beta1.Param;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class WebhookInterceptorFluent<A extends WebhookInterceptorFluent<A>> extends BaseFluent<A>{
  public WebhookInterceptorFluent() {
  }
  
  public WebhookInterceptorFluent(WebhookInterceptor instance) {
    this.copyInstance(instance);
  }
  private ArrayList<ParamBuilder> header = new ArrayList<ParamBuilder>();
  private ObjectReferenceBuilder objectRef;
  private String url;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(WebhookInterceptor instance) {
    instance = (instance != null ? instance : new WebhookInterceptor());
    if (instance != null) {
          this.withHeader(instance.getHeader());
          this.withObjectRef(instance.getObjectRef());
          this.withUrl(instance.getUrl());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToHeader(int index,Param item) {
    if (this.header == null) {this.header = new ArrayList<ParamBuilder>();}
    ParamBuilder builder = new ParamBuilder(item);
    if (index < 0 || index >= header.size()) {
        _visitables.get("header").add(builder);
        header.add(builder);
    } else {
        _visitables.get("header").add(builder);
        header.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToHeader(int index,Param item) {
    if (this.header == null) {this.header = new ArrayList<ParamBuilder>();}
    ParamBuilder builder = new ParamBuilder(item);
    if (index < 0 || index >= header.size()) {
        _visitables.get("header").add(builder);
        header.add(builder);
    } else {
        _visitables.get("header").add(builder);
        header.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToHeader(io.fabric8.tekton.v1beta1.Param... items) {
    if (this.header == null) {this.header = new ArrayList<ParamBuilder>();}
    for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("header").add(builder);this.header.add(builder);} return (A)this;
  }
  
  public A addAllToHeader(Collection<Param> items) {
    if (this.header == null) {this.header = new ArrayList<ParamBuilder>();}
    for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("header").add(builder);this.header.add(builder);} return (A)this;
  }
  
  public A removeFromHeader(io.fabric8.tekton.v1beta1.Param... items) {
    if (this.header == null) return (A)this;
    for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("header").remove(builder); this.header.remove(builder);} return (A)this;
  }
  
  public A removeAllFromHeader(Collection<Param> items) {
    if (this.header == null) return (A)this;
    for (Param item : items) {ParamBuilder builder = new ParamBuilder(item);_visitables.get("header").remove(builder); this.header.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromHeader(Predicate<ParamBuilder> predicate) {
    if (header == null) return (A) this;
    final Iterator<ParamBuilder> each = header.iterator();
    final List visitables = _visitables.get("header");
    while (each.hasNext()) {
      ParamBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<Param> buildHeader() {
    return this.header != null ? build(header) : null;
  }
  
  public Param buildHeader(int index) {
    return this.header.get(index).build();
  }
  
  public Param buildFirstHeader() {
    return this.header.get(0).build();
  }
  
  public Param buildLastHeader() {
    return this.header.get(header.size() - 1).build();
  }
  
  public Param buildMatchingHeader(Predicate<ParamBuilder> predicate) {
      for (ParamBuilder item : header) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingHeader(Predicate<ParamBuilder> predicate) {
      for (ParamBuilder item : header) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withHeader(List<Param> header) {
    if (this.header != null) {
      this._visitables.get("header").clear();
    }
    if (header != null) {
        this.header = new ArrayList();
        for (Param item : header) {
          this.addToHeader(item);
        }
    } else {
      this.header = null;
    }
    return (A) this;
  }
  
  public A withHeader(io.fabric8.tekton.v1beta1.Param... header) {
    if (this.header != null) {
        this.header.clear();
        _visitables.remove("header");
    }
    if (header != null) {
      for (Param item : header) {
        this.addToHeader(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasHeader() {
    return this.header != null && !this.header.isEmpty();
  }
  
  public HeaderNested<A> addNewHeader() {
    return new HeaderNested(-1, null);
  }
  
  public HeaderNested<A> addNewHeaderLike(Param item) {
    return new HeaderNested(-1, item);
  }
  
  public HeaderNested<A> setNewHeaderLike(int index,Param item) {
    return new HeaderNested(index, item);
  }
  
  public HeaderNested<A> editHeader(int index) {
    if (header.size() <= index) throw new RuntimeException("Can't edit header. Index exceeds size.");
    return setNewHeaderLike(index, buildHeader(index));
  }
  
  public HeaderNested<A> editFirstHeader() {
    if (header.size() == 0) throw new RuntimeException("Can't edit first header. The list is empty.");
    return setNewHeaderLike(0, buildHeader(0));
  }
  
  public HeaderNested<A> editLastHeader() {
    int index = header.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last header. The list is empty.");
    return setNewHeaderLike(index, buildHeader(index));
  }
  
  public HeaderNested<A> editMatchingHeader(Predicate<ParamBuilder> predicate) {
    int index = -1;
    for (int i=0;i<header.size();i++) { 
    if (predicate.test(header.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching header. No match found.");
    return setNewHeaderLike(index, buildHeader(index));
  }
  
  public ObjectReference buildObjectRef() {
    return this.objectRef != null ? this.objectRef.build() : null;
  }
  
  public A withObjectRef(ObjectReference objectRef) {
    this._visitables.remove("objectRef");
    if (objectRef != null) {
        this.objectRef = new ObjectReferenceBuilder(objectRef);
        this._visitables.get("objectRef").add(this.objectRef);
    } else {
        this.objectRef = null;
        this._visitables.get("objectRef").remove(this.objectRef);
    }
    return (A) this;
  }
  
  public boolean hasObjectRef() {
    return this.objectRef != null;
  }
  
  public ObjectRefNested<A> withNewObjectRef() {
    return new ObjectRefNested(null);
  }
  
  public ObjectRefNested<A> withNewObjectRefLike(ObjectReference item) {
    return new ObjectRefNested(item);
  }
  
  public ObjectRefNested<A> editObjectRef() {
    return withNewObjectRefLike(java.util.Optional.ofNullable(buildObjectRef()).orElse(null));
  }
  
  public ObjectRefNested<A> editOrNewObjectRef() {
    return withNewObjectRefLike(java.util.Optional.ofNullable(buildObjectRef()).orElse(new ObjectReferenceBuilder().build()));
  }
  
  public ObjectRefNested<A> editOrNewObjectRefLike(ObjectReference item) {
    return withNewObjectRefLike(java.util.Optional.ofNullable(buildObjectRef()).orElse(item));
  }
  
  public String getUrl() {
    return this.url;
  }
  
  public A withUrl(String url) {
    this.url = url;
    return (A) this;
  }
  
  public boolean hasUrl() {
    return this.url != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    WebhookInterceptorFluent that = (WebhookInterceptorFluent) o;
    if (!java.util.Objects.equals(header, that.header)) return false;
    if (!java.util.Objects.equals(objectRef, that.objectRef)) return false;
    if (!java.util.Objects.equals(url, that.url)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(header,  objectRef,  url,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (header != null && !header.isEmpty()) { sb.append("header:"); sb.append(header + ","); }
    if (objectRef != null) { sb.append("objectRef:"); sb.append(objectRef + ","); }
    if (url != null) { sb.append("url:"); sb.append(url + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class HeaderNested<N> extends ParamFluent<HeaderNested<N>> implements Nested<N>{
    HeaderNested(int index,Param item) {
      this.index = index;
      this.builder = new ParamBuilder(this, item);
    }
    ParamBuilder builder;
    int index;
    
    public N and() {
      return (N) WebhookInterceptorFluent.this.setToHeader(index,builder.build());
    }
    
    public N endHeader() {
      return and();
    }
    
  
  }
  public class ObjectRefNested<N> extends ObjectReferenceFluent<ObjectRefNested<N>> implements Nested<N>{
    ObjectRefNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) WebhookInterceptorFluent.this.withObjectRef(builder.build());
    }
    
    public N endObjectRef() {
      return and();
    }
    
  
  }

}