package io.fabric8.tekton.triggers.v1alpha1;

import java.lang.Integer;
import io.fabric8.knative.duck.v1.WithPodSpec;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class KubernetesResourceFluent<A extends KubernetesResourceFluent<A>> extends BaseFluent<A>{
  public KubernetesResourceFluent() {
  }
  
  public KubernetesResourceFluent(KubernetesResource instance) {
    this.copyInstance(instance);
  }
  private Integer replicas;
  private String serviceType;
  private WithPodSpec spec;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(KubernetesResource instance) {
    instance = (instance != null ? instance : new KubernetesResource());
    if (instance != null) {
          this.withReplicas(instance.getReplicas());
          this.withServiceType(instance.getServiceType());
          this.withSpec(instance.getSpec());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Integer getReplicas() {
    return this.replicas;
  }
  
  public A withReplicas(Integer replicas) {
    this.replicas = replicas;
    return (A) this;
  }
  
  public boolean hasReplicas() {
    return this.replicas != null;
  }
  
  public String getServiceType() {
    return this.serviceType;
  }
  
  public A withServiceType(String serviceType) {
    this.serviceType = serviceType;
    return (A) this;
  }
  
  public boolean hasServiceType() {
    return this.serviceType != null;
  }
  
  public WithPodSpec getSpec() {
    return this.spec;
  }
  
  public A withSpec(WithPodSpec spec) {
    this.spec = spec;
    return (A) this;
  }
  
  public boolean hasSpec() {
    return this.spec != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    KubernetesResourceFluent that = (KubernetesResourceFluent) o;
    if (!java.util.Objects.equals(replicas, that.replicas)) return false;
    if (!java.util.Objects.equals(serviceType, that.serviceType)) return false;
    if (!java.util.Objects.equals(spec, that.spec)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(replicas,  serviceType,  spec,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (serviceType != null) { sb.append("serviceType:"); sb.append(serviceType + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}