package io.fabric8.tekton.triggers.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class CustomResourceBuilder extends CustomResourceFluent<CustomResourceBuilder> implements VisitableBuilder<CustomResource,CustomResourceBuilder>{
  public CustomResourceBuilder() {
    this(new CustomResource());
  }
  
  public CustomResourceBuilder(CustomResourceFluent<?> fluent) {
    this(fluent, new CustomResource());
  }
  
  public CustomResourceBuilder(CustomResourceFluent<?> fluent,CustomResource instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public CustomResourceBuilder(CustomResource instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  CustomResourceFluent<?> fluent;
  
  public CustomResource build() {
    CustomResource buildable = new CustomResource();
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}