/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.tekton.pod.Template;
import io.fabric8.tekton.pod.TemplateBuilder;
import io.fabric8.tekton.pod.TemplateFluent;
import io.fabric8.tekton.v1.PipelineTaskMetadata;
import io.fabric8.tekton.v1.PipelineTaskMetadataBuilder;
import io.fabric8.tekton.v1.PipelineTaskMetadataFluent;
import io.fabric8.tekton.v1.PipelineTaskRunSpec;
import io.fabric8.tekton.v1.TaskRunSidecarSpec;
import io.fabric8.tekton.v1.TaskRunSidecarSpecBuilder;
import io.fabric8.tekton.v1.TaskRunSidecarSpecFluent;
import io.fabric8.tekton.v1.TaskRunStepSpec;
import io.fabric8.tekton.v1.TaskRunStepSpecBuilder;
import io.fabric8.tekton.v1.TaskRunStepSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class PipelineTaskRunSpecFluent<A extends PipelineTaskRunSpecFluent<A>>
extends BaseFluent<A> {
    private ResourceRequirementsBuilder computeResources;
    private PipelineTaskMetadataBuilder metadata;
    private String pipelineTaskName;
    private TemplateBuilder podTemplate;
    private String serviceAccountName;
    private ArrayList<TaskRunSidecarSpecBuilder> sidecarSpecs = new ArrayList();
    private ArrayList<TaskRunStepSpecBuilder> stepSpecs = new ArrayList();
    private Map<String, Object> additionalProperties;

    public PipelineTaskRunSpecFluent() {
    }

    public PipelineTaskRunSpecFluent(PipelineTaskRunSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(PipelineTaskRunSpec instance) {
        PipelineTaskRunSpec pipelineTaskRunSpec = instance = instance != null ? instance : new PipelineTaskRunSpec();
        if (instance != null) {
            this.withComputeResources(instance.getComputeResources());
            this.withMetadata(instance.getMetadata());
            this.withPipelineTaskName(instance.getPipelineTaskName());
            this.withPodTemplate(instance.getPodTemplate());
            this.withServiceAccountName(instance.getServiceAccountName());
            this.withSidecarSpecs(instance.getSidecarSpecs());
            this.withStepSpecs(instance.getStepSpecs());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ResourceRequirements buildComputeResources() {
        return this.computeResources != null ? this.computeResources.build() : null;
    }

    public A withComputeResources(ResourceRequirements computeResources) {
        this._visitables.remove((Object)"computeResources");
        if (computeResources != null) {
            this.computeResources = new ResourceRequirementsBuilder(computeResources);
            this._visitables.get((Object)"computeResources").add(this.computeResources);
        } else {
            this.computeResources = null;
            this._visitables.get((Object)"computeResources").remove(this.computeResources);
        }
        return (A)((Object)this);
    }

    public boolean hasComputeResources() {
        return this.computeResources != null;
    }

    public ComputeResourcesNested<A> withNewComputeResources() {
        return new ComputeResourcesNested(null);
    }

    public ComputeResourcesNested<A> withNewComputeResourcesLike(ResourceRequirements item) {
        return new ComputeResourcesNested(item);
    }

    public ComputeResourcesNested<A> editComputeResources() {
        return this.withNewComputeResourcesLike(Optional.ofNullable(this.buildComputeResources()).orElse(null));
    }

    public ComputeResourcesNested<A> editOrNewComputeResources() {
        return this.withNewComputeResourcesLike(Optional.ofNullable(this.buildComputeResources()).orElse(new ResourceRequirementsBuilder().build()));
    }

    public ComputeResourcesNested<A> editOrNewComputeResourcesLike(ResourceRequirements item) {
        return this.withNewComputeResourcesLike(Optional.ofNullable(this.buildComputeResources()).orElse(item));
    }

    public PipelineTaskMetadata buildMetadata() {
        return this.metadata != null ? this.metadata.build() : null;
    }

    public A withMetadata(PipelineTaskMetadata metadata) {
        this._visitables.remove((Object)"metadata");
        if (metadata != null) {
            this.metadata = new PipelineTaskMetadataBuilder(metadata);
            this._visitables.get((Object)"metadata").add(this.metadata);
        } else {
            this.metadata = null;
            this._visitables.get((Object)"metadata").remove((Object)this.metadata);
        }
        return (A)((Object)this);
    }

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public MetadataNested<A> withNewMetadata() {
        return new MetadataNested(null);
    }

    public MetadataNested<A> withNewMetadataLike(PipelineTaskMetadata item) {
        return new MetadataNested(item);
    }

    public MetadataNested<A> editMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(null));
    }

    public MetadataNested<A> editOrNewMetadata() {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(new PipelineTaskMetadataBuilder().build()));
    }

    public MetadataNested<A> editOrNewMetadataLike(PipelineTaskMetadata item) {
        return this.withNewMetadataLike(Optional.ofNullable(this.buildMetadata()).orElse(item));
    }

    public String getPipelineTaskName() {
        return this.pipelineTaskName;
    }

    public A withPipelineTaskName(String pipelineTaskName) {
        this.pipelineTaskName = pipelineTaskName;
        return (A)((Object)this);
    }

    public boolean hasPipelineTaskName() {
        return this.pipelineTaskName != null;
    }

    public Template buildPodTemplate() {
        return this.podTemplate != null ? this.podTemplate.build() : null;
    }

    public A withPodTemplate(Template podTemplate) {
        this._visitables.remove((Object)"podTemplate");
        if (podTemplate != null) {
            this.podTemplate = new TemplateBuilder(podTemplate);
            this._visitables.get((Object)"podTemplate").add(this.podTemplate);
        } else {
            this.podTemplate = null;
            this._visitables.get((Object)"podTemplate").remove((Object)this.podTemplate);
        }
        return (A)((Object)this);
    }

    public boolean hasPodTemplate() {
        return this.podTemplate != null;
    }

    public PodTemplateNested<A> withNewPodTemplate() {
        return new PodTemplateNested(null);
    }

    public PodTemplateNested<A> withNewPodTemplateLike(Template item) {
        return new PodTemplateNested(item);
    }

    public PodTemplateNested<A> editPodTemplate() {
        return this.withNewPodTemplateLike(Optional.ofNullable(this.buildPodTemplate()).orElse(null));
    }

    public PodTemplateNested<A> editOrNewPodTemplate() {
        return this.withNewPodTemplateLike(Optional.ofNullable(this.buildPodTemplate()).orElse(new TemplateBuilder().build()));
    }

    public PodTemplateNested<A> editOrNewPodTemplateLike(Template item) {
        return this.withNewPodTemplateLike(Optional.ofNullable(this.buildPodTemplate()).orElse(item));
    }

    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
        return (A)((Object)this);
    }

    public boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    public A addToSidecarSpecs(int index, TaskRunSidecarSpec item) {
        if (this.sidecarSpecs == null) {
            this.sidecarSpecs = new ArrayList();
        }
        TaskRunSidecarSpecBuilder builder = new TaskRunSidecarSpecBuilder(item);
        if (index < 0 || index >= this.sidecarSpecs.size()) {
            this._visitables.get((Object)"sidecarSpecs").add(builder);
            this.sidecarSpecs.add(builder);
        } else {
            this._visitables.get((Object)"sidecarSpecs").add(builder);
            this.sidecarSpecs.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToSidecarSpecs(int index, TaskRunSidecarSpec item) {
        if (this.sidecarSpecs == null) {
            this.sidecarSpecs = new ArrayList();
        }
        TaskRunSidecarSpecBuilder builder = new TaskRunSidecarSpecBuilder(item);
        if (index < 0 || index >= this.sidecarSpecs.size()) {
            this._visitables.get((Object)"sidecarSpecs").add(builder);
            this.sidecarSpecs.add(builder);
        } else {
            this._visitables.get((Object)"sidecarSpecs").add(builder);
            this.sidecarSpecs.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToSidecarSpecs(TaskRunSidecarSpec ... items) {
        if (this.sidecarSpecs == null) {
            this.sidecarSpecs = new ArrayList();
        }
        for (TaskRunSidecarSpec item : items) {
            TaskRunSidecarSpecBuilder builder = new TaskRunSidecarSpecBuilder(item);
            this._visitables.get((Object)"sidecarSpecs").add(builder);
            this.sidecarSpecs.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToSidecarSpecs(Collection<TaskRunSidecarSpec> items) {
        if (this.sidecarSpecs == null) {
            this.sidecarSpecs = new ArrayList();
        }
        for (TaskRunSidecarSpec item : items) {
            TaskRunSidecarSpecBuilder builder = new TaskRunSidecarSpecBuilder(item);
            this._visitables.get((Object)"sidecarSpecs").add(builder);
            this.sidecarSpecs.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromSidecarSpecs(TaskRunSidecarSpec ... items) {
        if (this.sidecarSpecs == null) {
            return (A)((Object)this);
        }
        for (TaskRunSidecarSpec item : items) {
            TaskRunSidecarSpecBuilder builder = new TaskRunSidecarSpecBuilder(item);
            this._visitables.get((Object)"sidecarSpecs").remove((Object)builder);
            this.sidecarSpecs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromSidecarSpecs(Collection<TaskRunSidecarSpec> items) {
        if (this.sidecarSpecs == null) {
            return (A)((Object)this);
        }
        for (TaskRunSidecarSpec item : items) {
            TaskRunSidecarSpecBuilder builder = new TaskRunSidecarSpecBuilder(item);
            this._visitables.get((Object)"sidecarSpecs").remove((Object)builder);
            this.sidecarSpecs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromSidecarSpecs(Predicate<TaskRunSidecarSpecBuilder> predicate) {
        if (this.sidecarSpecs == null) {
            return (A)((Object)this);
        }
        Iterator<TaskRunSidecarSpecBuilder> each = this.sidecarSpecs.iterator();
        List visitables = this._visitables.get((Object)"sidecarSpecs");
        while (each.hasNext()) {
            TaskRunSidecarSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<TaskRunSidecarSpec> buildSidecarSpecs() {
        return this.sidecarSpecs != null ? PipelineTaskRunSpecFluent.build(this.sidecarSpecs) : null;
    }

    public TaskRunSidecarSpec buildSidecarSpec(int index) {
        return this.sidecarSpecs.get(index).build();
    }

    public TaskRunSidecarSpec buildFirstSidecarSpec() {
        return this.sidecarSpecs.get(0).build();
    }

    public TaskRunSidecarSpec buildLastSidecarSpec() {
        return this.sidecarSpecs.get(this.sidecarSpecs.size() - 1).build();
    }

    public TaskRunSidecarSpec buildMatchingSidecarSpec(Predicate<TaskRunSidecarSpecBuilder> predicate) {
        for (TaskRunSidecarSpecBuilder item : this.sidecarSpecs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSidecarSpec(Predicate<TaskRunSidecarSpecBuilder> predicate) {
        for (TaskRunSidecarSpecBuilder item : this.sidecarSpecs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSidecarSpecs(List<TaskRunSidecarSpec> sidecarSpecs) {
        if (this.sidecarSpecs != null) {
            this._visitables.get((Object)"sidecarSpecs").clear();
        }
        if (sidecarSpecs != null) {
            this.sidecarSpecs = new ArrayList();
            for (TaskRunSidecarSpec item : sidecarSpecs) {
                this.addToSidecarSpecs(item);
            }
        } else {
            this.sidecarSpecs = null;
        }
        return (A)((Object)this);
    }

    public A withSidecarSpecs(TaskRunSidecarSpec ... sidecarSpecs) {
        if (this.sidecarSpecs != null) {
            this.sidecarSpecs.clear();
            this._visitables.remove((Object)"sidecarSpecs");
        }
        if (sidecarSpecs != null) {
            for (TaskRunSidecarSpec item : sidecarSpecs) {
                this.addToSidecarSpecs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSidecarSpecs() {
        return this.sidecarSpecs != null && !this.sidecarSpecs.isEmpty();
    }

    public SidecarSpecsNested<A> addNewSidecarSpec() {
        return new SidecarSpecsNested(-1, null);
    }

    public SidecarSpecsNested<A> addNewSidecarSpecLike(TaskRunSidecarSpec item) {
        return new SidecarSpecsNested(-1, item);
    }

    public SidecarSpecsNested<A> setNewSidecarSpecLike(int index, TaskRunSidecarSpec item) {
        return new SidecarSpecsNested(index, item);
    }

    public SidecarSpecsNested<A> editSidecarSpec(int index) {
        if (this.sidecarSpecs.size() <= index) {
            throw new RuntimeException("Can't edit sidecarSpecs. Index exceeds size.");
        }
        return this.setNewSidecarSpecLike(index, this.buildSidecarSpec(index));
    }

    public SidecarSpecsNested<A> editFirstSidecarSpec() {
        if (this.sidecarSpecs.size() == 0) {
            throw new RuntimeException("Can't edit first sidecarSpecs. The list is empty.");
        }
        return this.setNewSidecarSpecLike(0, this.buildSidecarSpec(0));
    }

    public SidecarSpecsNested<A> editLastSidecarSpec() {
        int index = this.sidecarSpecs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last sidecarSpecs. The list is empty.");
        }
        return this.setNewSidecarSpecLike(index, this.buildSidecarSpec(index));
    }

    public SidecarSpecsNested<A> editMatchingSidecarSpec(Predicate<TaskRunSidecarSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.sidecarSpecs.size(); ++i) {
            if (!predicate.test(this.sidecarSpecs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching sidecarSpecs. No match found.");
        }
        return this.setNewSidecarSpecLike(index, this.buildSidecarSpec(index));
    }

    public A addToStepSpecs(int index, TaskRunStepSpec item) {
        if (this.stepSpecs == null) {
            this.stepSpecs = new ArrayList();
        }
        TaskRunStepSpecBuilder builder = new TaskRunStepSpecBuilder(item);
        if (index < 0 || index >= this.stepSpecs.size()) {
            this._visitables.get((Object)"stepSpecs").add(builder);
            this.stepSpecs.add(builder);
        } else {
            this._visitables.get((Object)"stepSpecs").add(builder);
            this.stepSpecs.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToStepSpecs(int index, TaskRunStepSpec item) {
        if (this.stepSpecs == null) {
            this.stepSpecs = new ArrayList();
        }
        TaskRunStepSpecBuilder builder = new TaskRunStepSpecBuilder(item);
        if (index < 0 || index >= this.stepSpecs.size()) {
            this._visitables.get((Object)"stepSpecs").add(builder);
            this.stepSpecs.add(builder);
        } else {
            this._visitables.get((Object)"stepSpecs").add(builder);
            this.stepSpecs.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToStepSpecs(TaskRunStepSpec ... items) {
        if (this.stepSpecs == null) {
            this.stepSpecs = new ArrayList();
        }
        for (TaskRunStepSpec item : items) {
            TaskRunStepSpecBuilder builder = new TaskRunStepSpecBuilder(item);
            this._visitables.get((Object)"stepSpecs").add(builder);
            this.stepSpecs.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToStepSpecs(Collection<TaskRunStepSpec> items) {
        if (this.stepSpecs == null) {
            this.stepSpecs = new ArrayList();
        }
        for (TaskRunStepSpec item : items) {
            TaskRunStepSpecBuilder builder = new TaskRunStepSpecBuilder(item);
            this._visitables.get((Object)"stepSpecs").add(builder);
            this.stepSpecs.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromStepSpecs(TaskRunStepSpec ... items) {
        if (this.stepSpecs == null) {
            return (A)((Object)this);
        }
        for (TaskRunStepSpec item : items) {
            TaskRunStepSpecBuilder builder = new TaskRunStepSpecBuilder(item);
            this._visitables.get((Object)"stepSpecs").remove((Object)builder);
            this.stepSpecs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromStepSpecs(Collection<TaskRunStepSpec> items) {
        if (this.stepSpecs == null) {
            return (A)((Object)this);
        }
        for (TaskRunStepSpec item : items) {
            TaskRunStepSpecBuilder builder = new TaskRunStepSpecBuilder(item);
            this._visitables.get((Object)"stepSpecs").remove((Object)builder);
            this.stepSpecs.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromStepSpecs(Predicate<TaskRunStepSpecBuilder> predicate) {
        if (this.stepSpecs == null) {
            return (A)((Object)this);
        }
        Iterator<TaskRunStepSpecBuilder> each = this.stepSpecs.iterator();
        List visitables = this._visitables.get((Object)"stepSpecs");
        while (each.hasNext()) {
            TaskRunStepSpecBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<TaskRunStepSpec> buildStepSpecs() {
        return this.stepSpecs != null ? PipelineTaskRunSpecFluent.build(this.stepSpecs) : null;
    }

    public TaskRunStepSpec buildStepSpec(int index) {
        return this.stepSpecs.get(index).build();
    }

    public TaskRunStepSpec buildFirstStepSpec() {
        return this.stepSpecs.get(0).build();
    }

    public TaskRunStepSpec buildLastStepSpec() {
        return this.stepSpecs.get(this.stepSpecs.size() - 1).build();
    }

    public TaskRunStepSpec buildMatchingStepSpec(Predicate<TaskRunStepSpecBuilder> predicate) {
        for (TaskRunStepSpecBuilder item : this.stepSpecs) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingStepSpec(Predicate<TaskRunStepSpecBuilder> predicate) {
        for (TaskRunStepSpecBuilder item : this.stepSpecs) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withStepSpecs(List<TaskRunStepSpec> stepSpecs) {
        if (this.stepSpecs != null) {
            this._visitables.get((Object)"stepSpecs").clear();
        }
        if (stepSpecs != null) {
            this.stepSpecs = new ArrayList();
            for (TaskRunStepSpec item : stepSpecs) {
                this.addToStepSpecs(item);
            }
        } else {
            this.stepSpecs = null;
        }
        return (A)((Object)this);
    }

    public A withStepSpecs(TaskRunStepSpec ... stepSpecs) {
        if (this.stepSpecs != null) {
            this.stepSpecs.clear();
            this._visitables.remove((Object)"stepSpecs");
        }
        if (stepSpecs != null) {
            for (TaskRunStepSpec item : stepSpecs) {
                this.addToStepSpecs(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasStepSpecs() {
        return this.stepSpecs != null && !this.stepSpecs.isEmpty();
    }

    public StepSpecsNested<A> addNewStepSpec() {
        return new StepSpecsNested(-1, null);
    }

    public StepSpecsNested<A> addNewStepSpecLike(TaskRunStepSpec item) {
        return new StepSpecsNested(-1, item);
    }

    public StepSpecsNested<A> setNewStepSpecLike(int index, TaskRunStepSpec item) {
        return new StepSpecsNested(index, item);
    }

    public StepSpecsNested<A> editStepSpec(int index) {
        if (this.stepSpecs.size() <= index) {
            throw new RuntimeException("Can't edit stepSpecs. Index exceeds size.");
        }
        return this.setNewStepSpecLike(index, this.buildStepSpec(index));
    }

    public StepSpecsNested<A> editFirstStepSpec() {
        if (this.stepSpecs.size() == 0) {
            throw new RuntimeException("Can't edit first stepSpecs. The list is empty.");
        }
        return this.setNewStepSpecLike(0, this.buildStepSpec(0));
    }

    public StepSpecsNested<A> editLastStepSpec() {
        int index = this.stepSpecs.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last stepSpecs. The list is empty.");
        }
        return this.setNewStepSpecLike(index, this.buildStepSpec(index));
    }

    public StepSpecsNested<A> editMatchingStepSpec(Predicate<TaskRunStepSpecBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.stepSpecs.size(); ++i) {
            if (!predicate.test(this.stepSpecs.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching stepSpecs. No match found.");
        }
        return this.setNewStepSpecLike(index, this.buildStepSpec(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PipelineTaskRunSpecFluent that = (PipelineTaskRunSpecFluent)((Object)o);
        if (!Objects.equals(this.computeResources, that.computeResources)) {
            return false;
        }
        if (!Objects.equals((Object)this.metadata, (Object)that.metadata)) {
            return false;
        }
        if (!Objects.equals(this.pipelineTaskName, that.pipelineTaskName)) {
            return false;
        }
        if (!Objects.equals((Object)this.podTemplate, (Object)that.podTemplate)) {
            return false;
        }
        if (!Objects.equals(this.serviceAccountName, that.serviceAccountName)) {
            return false;
        }
        if (!Objects.equals(this.sidecarSpecs, that.sidecarSpecs)) {
            return false;
        }
        if (!Objects.equals(this.stepSpecs, that.stepSpecs)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.computeResources, this.metadata, this.pipelineTaskName, this.podTemplate, this.serviceAccountName, this.sidecarSpecs, this.stepSpecs, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.computeResources != null) {
            sb.append("computeResources:");
            sb.append(String.valueOf(this.computeResources) + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(String.valueOf((Object)this.metadata) + ",");
        }
        if (this.pipelineTaskName != null) {
            sb.append("pipelineTaskName:");
            sb.append(this.pipelineTaskName + ",");
        }
        if (this.podTemplate != null) {
            sb.append("podTemplate:");
            sb.append(String.valueOf((Object)this.podTemplate) + ",");
        }
        if (this.serviceAccountName != null) {
            sb.append("serviceAccountName:");
            sb.append(this.serviceAccountName + ",");
        }
        if (this.sidecarSpecs != null && !this.sidecarSpecs.isEmpty()) {
            sb.append("sidecarSpecs:");
            sb.append(String.valueOf(this.sidecarSpecs) + ",");
        }
        if (this.stepSpecs != null && !this.stepSpecs.isEmpty()) {
            sb.append("stepSpecs:");
            sb.append(String.valueOf(this.stepSpecs) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class StepSpecsNested<N>
    extends TaskRunStepSpecFluent<StepSpecsNested<N>>
    implements Nested<N> {
        TaskRunStepSpecBuilder builder;
        int index;

        StepSpecsNested(int index, TaskRunStepSpec item) {
            this.index = index;
            this.builder = new TaskRunStepSpecBuilder(this, item);
        }

        public N and() {
            return (N)PipelineTaskRunSpecFluent.this.setToStepSpecs(this.index, this.builder.build());
        }

        public N endStepSpec() {
            return this.and();
        }
    }

    public class SidecarSpecsNested<N>
    extends TaskRunSidecarSpecFluent<SidecarSpecsNested<N>>
    implements Nested<N> {
        TaskRunSidecarSpecBuilder builder;
        int index;

        SidecarSpecsNested(int index, TaskRunSidecarSpec item) {
            this.index = index;
            this.builder = new TaskRunSidecarSpecBuilder(this, item);
        }

        public N and() {
            return (N)PipelineTaskRunSpecFluent.this.setToSidecarSpecs(this.index, this.builder.build());
        }

        public N endSidecarSpec() {
            return this.and();
        }
    }

    public class PodTemplateNested<N>
    extends TemplateFluent<PodTemplateNested<N>>
    implements Nested<N> {
        TemplateBuilder builder;

        PodTemplateNested(Template item) {
            this.builder = new TemplateBuilder(this, item);
        }

        public N and() {
            return (N)PipelineTaskRunSpecFluent.this.withPodTemplate(this.builder.build());
        }

        public N endPodTemplate() {
            return this.and();
        }
    }

    public class MetadataNested<N>
    extends PipelineTaskMetadataFluent<MetadataNested<N>>
    implements Nested<N> {
        PipelineTaskMetadataBuilder builder;

        MetadataNested(PipelineTaskMetadata item) {
            this.builder = new PipelineTaskMetadataBuilder(this, item);
        }

        public N and() {
            return (N)PipelineTaskRunSpecFluent.this.withMetadata(this.builder.build());
        }

        public N endMetadata() {
            return this.and();
        }
    }

    public class ComputeResourcesNested<N>
    extends ResourceRequirementsFluent<ComputeResourcesNested<N>>
    implements Nested<N> {
        ResourceRequirementsBuilder builder;

        ComputeResourcesNested(ResourceRequirements item) {
            this.builder = new ResourceRequirementsBuilder((ResourceRequirementsFluent)this, item);
        }

        public N and() {
            return (N)PipelineTaskRunSpecFluent.this.withComputeResources(this.builder.build());
        }

        public N endComputeResources() {
            return this.and();
        }
    }
}

