/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.tekton.pod.Template;
import io.fabric8.tekton.pod.TemplateBuilder;
import io.fabric8.tekton.pod.TemplateFluent;
import io.fabric8.tekton.v1alpha1.EmbeddedRunSpec;
import io.fabric8.tekton.v1alpha1.EmbeddedRunSpecBuilder;
import io.fabric8.tekton.v1alpha1.EmbeddedRunSpecFluent;
import io.fabric8.tekton.v1alpha1.RunSpec;
import io.fabric8.tekton.v1beta1.Param;
import io.fabric8.tekton.v1beta1.ParamBuilder;
import io.fabric8.tekton.v1beta1.ParamFluent;
import io.fabric8.tekton.v1beta1.TaskRef;
import io.fabric8.tekton.v1beta1.TaskRefBuilder;
import io.fabric8.tekton.v1beta1.TaskRefFluent;
import io.fabric8.tekton.v1beta1.WorkspaceBinding;
import io.fabric8.tekton.v1beta1.WorkspaceBindingBuilder;
import io.fabric8.tekton.v1beta1.WorkspaceBindingFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class RunSpecFluent<A extends RunSpecFluent<A>>
extends BaseFluent<A> {
    private ArrayList<ParamBuilder> params = new ArrayList();
    private TemplateBuilder podTemplate;
    private TaskRefBuilder ref;
    private Integer retries;
    private String serviceAccountName;
    private EmbeddedRunSpecBuilder spec;
    private String status;
    private String statusMessage;
    private Duration timeout;
    private ArrayList<WorkspaceBindingBuilder> workspaces = new ArrayList();
    private Map<String, Object> additionalProperties;

    public RunSpecFluent() {
    }

    public RunSpecFluent(RunSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(RunSpec instance) {
        RunSpec runSpec = instance = instance != null ? instance : new RunSpec();
        if (instance != null) {
            this.withParams(instance.getParams());
            this.withPodTemplate(instance.getPodTemplate());
            this.withRef(instance.getRef());
            this.withRetries(instance.getRetries());
            this.withServiceAccountName(instance.getServiceAccountName());
            this.withSpec(instance.getSpec());
            this.withStatus(instance.getStatus());
            this.withStatusMessage(instance.getStatusMessage());
            this.withTimeout(instance.getTimeout());
            this.withWorkspaces(instance.getWorkspaces());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToParams(int index, Param item) {
        if (this.params == null) {
            this.params = new ArrayList();
        }
        ParamBuilder builder = new ParamBuilder(item);
        if (index < 0 || index >= this.params.size()) {
            this._visitables.get((Object)"params").add(builder);
            this.params.add(builder);
        } else {
            this._visitables.get((Object)"params").add(index, builder);
            this.params.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToParams(int index, Param item) {
        if (this.params == null) {
            this.params = new ArrayList();
        }
        ParamBuilder builder = new ParamBuilder(item);
        if (index < 0 || index >= this.params.size()) {
            this._visitables.get((Object)"params").add(builder);
            this.params.add(builder);
        } else {
            this._visitables.get((Object)"params").set(index, builder);
            this.params.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToParams(Param ... items) {
        if (this.params == null) {
            this.params = new ArrayList();
        }
        for (Param item : items) {
            ParamBuilder builder = new ParamBuilder(item);
            this._visitables.get((Object)"params").add(builder);
            this.params.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToParams(Collection<Param> items) {
        if (this.params == null) {
            this.params = new ArrayList();
        }
        for (Param item : items) {
            ParamBuilder builder = new ParamBuilder(item);
            this._visitables.get((Object)"params").add(builder);
            this.params.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromParams(Param ... items) {
        if (this.params == null) {
            return (A)((Object)this);
        }
        for (Param item : items) {
            ParamBuilder builder = new ParamBuilder(item);
            this._visitables.get((Object)"params").remove((Object)builder);
            this.params.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromParams(Collection<Param> items) {
        if (this.params == null) {
            return (A)((Object)this);
        }
        for (Param item : items) {
            ParamBuilder builder = new ParamBuilder(item);
            this._visitables.get((Object)"params").remove((Object)builder);
            this.params.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromParams(Predicate<ParamBuilder> predicate) {
        if (this.params == null) {
            return (A)((Object)this);
        }
        Iterator<ParamBuilder> each = this.params.iterator();
        List visitables = this._visitables.get((Object)"params");
        while (each.hasNext()) {
            ParamBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Param> buildParams() {
        return this.params != null ? RunSpecFluent.build(this.params) : null;
    }

    public Param buildParam(int index) {
        return this.params.get(index).build();
    }

    public Param buildFirstParam() {
        return this.params.get(0).build();
    }

    public Param buildLastParam() {
        return this.params.get(this.params.size() - 1).build();
    }

    public Param buildMatchingParam(Predicate<ParamBuilder> predicate) {
        for (ParamBuilder item : this.params) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingParam(Predicate<ParamBuilder> predicate) {
        for (ParamBuilder item : this.params) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withParams(List<Param> params) {
        if (this.params != null) {
            this._visitables.get((Object)"params").clear();
        }
        if (params != null) {
            this.params = new ArrayList();
            for (Param item : params) {
                this.addToParams(item);
            }
        } else {
            this.params = null;
        }
        return (A)((Object)this);
    }

    public A withParams(Param ... params) {
        if (this.params != null) {
            this.params.clear();
            this._visitables.remove((Object)"params");
        }
        if (params != null) {
            for (Param item : params) {
                this.addToParams(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasParams() {
        return this.params != null && !this.params.isEmpty();
    }

    public ParamsNested<A> addNewParam() {
        return new ParamsNested(-1, null);
    }

    public ParamsNested<A> addNewParamLike(Param item) {
        return new ParamsNested(-1, item);
    }

    public ParamsNested<A> setNewParamLike(int index, Param item) {
        return new ParamsNested(index, item);
    }

    public ParamsNested<A> editParam(int index) {
        if (this.params.size() <= index) {
            throw new RuntimeException("Can't edit params. Index exceeds size.");
        }
        return this.setNewParamLike(index, this.buildParam(index));
    }

    public ParamsNested<A> editFirstParam() {
        if (this.params.size() == 0) {
            throw new RuntimeException("Can't edit first params. The list is empty.");
        }
        return this.setNewParamLike(0, this.buildParam(0));
    }

    public ParamsNested<A> editLastParam() {
        int index = this.params.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last params. The list is empty.");
        }
        return this.setNewParamLike(index, this.buildParam(index));
    }

    public ParamsNested<A> editMatchingParam(Predicate<ParamBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.params.size(); ++i) {
            if (!predicate.test(this.params.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching params. No match found.");
        }
        return this.setNewParamLike(index, this.buildParam(index));
    }

    public Template buildPodTemplate() {
        return this.podTemplate != null ? this.podTemplate.build() : null;
    }

    public A withPodTemplate(Template podTemplate) {
        this._visitables.remove((Object)"podTemplate");
        if (podTemplate != null) {
            this.podTemplate = new TemplateBuilder(podTemplate);
            this._visitables.get((Object)"podTemplate").add(this.podTemplate);
        } else {
            this.podTemplate = null;
            this._visitables.get((Object)"podTemplate").remove((Object)this.podTemplate);
        }
        return (A)((Object)this);
    }

    public boolean hasPodTemplate() {
        return this.podTemplate != null;
    }

    public PodTemplateNested<A> withNewPodTemplate() {
        return new PodTemplateNested(null);
    }

    public PodTemplateNested<A> withNewPodTemplateLike(Template item) {
        return new PodTemplateNested(item);
    }

    public PodTemplateNested<A> editPodTemplate() {
        return this.withNewPodTemplateLike(Optional.ofNullable(this.buildPodTemplate()).orElse(null));
    }

    public PodTemplateNested<A> editOrNewPodTemplate() {
        return this.withNewPodTemplateLike(Optional.ofNullable(this.buildPodTemplate()).orElse(new TemplateBuilder().build()));
    }

    public PodTemplateNested<A> editOrNewPodTemplateLike(Template item) {
        return this.withNewPodTemplateLike(Optional.ofNullable(this.buildPodTemplate()).orElse(item));
    }

    public TaskRef buildRef() {
        return this.ref != null ? this.ref.build() : null;
    }

    public A withRef(TaskRef ref) {
        this._visitables.remove((Object)"ref");
        if (ref != null) {
            this.ref = new TaskRefBuilder(ref);
            this._visitables.get((Object)"ref").add(this.ref);
        } else {
            this.ref = null;
            this._visitables.get((Object)"ref").remove((Object)this.ref);
        }
        return (A)((Object)this);
    }

    public boolean hasRef() {
        return this.ref != null;
    }

    public A withNewRef(String apiVersion, String bundle, String kind, String name) {
        return this.withRef(new TaskRef(apiVersion, bundle, kind, name));
    }

    public RefNested<A> withNewRef() {
        return new RefNested(null);
    }

    public RefNested<A> withNewRefLike(TaskRef item) {
        return new RefNested(item);
    }

    public RefNested<A> editRef() {
        return this.withNewRefLike(Optional.ofNullable(this.buildRef()).orElse(null));
    }

    public RefNested<A> editOrNewRef() {
        return this.withNewRefLike(Optional.ofNullable(this.buildRef()).orElse(new TaskRefBuilder().build()));
    }

    public RefNested<A> editOrNewRefLike(TaskRef item) {
        return this.withNewRefLike(Optional.ofNullable(this.buildRef()).orElse(item));
    }

    public Integer getRetries() {
        return this.retries;
    }

    public A withRetries(Integer retries) {
        this.retries = retries;
        return (A)((Object)this);
    }

    public boolean hasRetries() {
        return this.retries != null;
    }

    public String getServiceAccountName() {
        return this.serviceAccountName;
    }

    public A withServiceAccountName(String serviceAccountName) {
        this.serviceAccountName = serviceAccountName;
        return (A)((Object)this);
    }

    public boolean hasServiceAccountName() {
        return this.serviceAccountName != null;
    }

    public EmbeddedRunSpec buildSpec() {
        return this.spec != null ? this.spec.build() : null;
    }

    public A withSpec(EmbeddedRunSpec spec) {
        this._visitables.remove((Object)"spec");
        if (spec != null) {
            this.spec = new EmbeddedRunSpecBuilder(spec);
            this._visitables.get((Object)"spec").add(this.spec);
        } else {
            this.spec = null;
            this._visitables.get((Object)"spec").remove((Object)this.spec);
        }
        return (A)((Object)this);
    }

    public boolean hasSpec() {
        return this.spec != null;
    }

    public SpecNested<A> withNewSpec() {
        return new SpecNested(null);
    }

    public SpecNested<A> withNewSpecLike(EmbeddedRunSpec item) {
        return new SpecNested(item);
    }

    public SpecNested<A> editSpec() {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(null));
    }

    public SpecNested<A> editOrNewSpec() {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(new EmbeddedRunSpecBuilder().build()));
    }

    public SpecNested<A> editOrNewSpecLike(EmbeddedRunSpec item) {
        return this.withNewSpecLike(Optional.ofNullable(this.buildSpec()).orElse(item));
    }

    public String getStatus() {
        return this.status;
    }

    public A withStatus(String status) {
        this.status = status;
        return (A)((Object)this);
    }

    public boolean hasStatus() {
        return this.status != null;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public A withStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
        return (A)((Object)this);
    }

    public boolean hasStatusMessage() {
        return this.statusMessage != null;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public A withTimeout(Duration timeout) {
        this.timeout = timeout;
        return (A)((Object)this);
    }

    public boolean hasTimeout() {
        return this.timeout != null;
    }

    public A addToWorkspaces(int index, WorkspaceBinding item) {
        if (this.workspaces == null) {
            this.workspaces = new ArrayList();
        }
        WorkspaceBindingBuilder builder = new WorkspaceBindingBuilder(item);
        if (index < 0 || index >= this.workspaces.size()) {
            this._visitables.get((Object)"workspaces").add(builder);
            this.workspaces.add(builder);
        } else {
            this._visitables.get((Object)"workspaces").add(index, builder);
            this.workspaces.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToWorkspaces(int index, WorkspaceBinding item) {
        if (this.workspaces == null) {
            this.workspaces = new ArrayList();
        }
        WorkspaceBindingBuilder builder = new WorkspaceBindingBuilder(item);
        if (index < 0 || index >= this.workspaces.size()) {
            this._visitables.get((Object)"workspaces").add(builder);
            this.workspaces.add(builder);
        } else {
            this._visitables.get((Object)"workspaces").set(index, builder);
            this.workspaces.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToWorkspaces(WorkspaceBinding ... items) {
        if (this.workspaces == null) {
            this.workspaces = new ArrayList();
        }
        for (WorkspaceBinding item : items) {
            WorkspaceBindingBuilder builder = new WorkspaceBindingBuilder(item);
            this._visitables.get((Object)"workspaces").add(builder);
            this.workspaces.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToWorkspaces(Collection<WorkspaceBinding> items) {
        if (this.workspaces == null) {
            this.workspaces = new ArrayList();
        }
        for (WorkspaceBinding item : items) {
            WorkspaceBindingBuilder builder = new WorkspaceBindingBuilder(item);
            this._visitables.get((Object)"workspaces").add(builder);
            this.workspaces.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromWorkspaces(WorkspaceBinding ... items) {
        if (this.workspaces == null) {
            return (A)((Object)this);
        }
        for (WorkspaceBinding item : items) {
            WorkspaceBindingBuilder builder = new WorkspaceBindingBuilder(item);
            this._visitables.get((Object)"workspaces").remove((Object)builder);
            this.workspaces.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromWorkspaces(Collection<WorkspaceBinding> items) {
        if (this.workspaces == null) {
            return (A)((Object)this);
        }
        for (WorkspaceBinding item : items) {
            WorkspaceBindingBuilder builder = new WorkspaceBindingBuilder(item);
            this._visitables.get((Object)"workspaces").remove((Object)builder);
            this.workspaces.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromWorkspaces(Predicate<WorkspaceBindingBuilder> predicate) {
        if (this.workspaces == null) {
            return (A)((Object)this);
        }
        Iterator<WorkspaceBindingBuilder> each = this.workspaces.iterator();
        List visitables = this._visitables.get((Object)"workspaces");
        while (each.hasNext()) {
            WorkspaceBindingBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<WorkspaceBinding> buildWorkspaces() {
        return this.workspaces != null ? RunSpecFluent.build(this.workspaces) : null;
    }

    public WorkspaceBinding buildWorkspace(int index) {
        return this.workspaces.get(index).build();
    }

    public WorkspaceBinding buildFirstWorkspace() {
        return this.workspaces.get(0).build();
    }

    public WorkspaceBinding buildLastWorkspace() {
        return this.workspaces.get(this.workspaces.size() - 1).build();
    }

    public WorkspaceBinding buildMatchingWorkspace(Predicate<WorkspaceBindingBuilder> predicate) {
        for (WorkspaceBindingBuilder item : this.workspaces) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingWorkspace(Predicate<WorkspaceBindingBuilder> predicate) {
        for (WorkspaceBindingBuilder item : this.workspaces) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withWorkspaces(List<WorkspaceBinding> workspaces) {
        if (this.workspaces != null) {
            this._visitables.get((Object)"workspaces").clear();
        }
        if (workspaces != null) {
            this.workspaces = new ArrayList();
            for (WorkspaceBinding item : workspaces) {
                this.addToWorkspaces(item);
            }
        } else {
            this.workspaces = null;
        }
        return (A)((Object)this);
    }

    public A withWorkspaces(WorkspaceBinding ... workspaces) {
        if (this.workspaces != null) {
            this.workspaces.clear();
            this._visitables.remove((Object)"workspaces");
        }
        if (workspaces != null) {
            for (WorkspaceBinding item : workspaces) {
                this.addToWorkspaces(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasWorkspaces() {
        return this.workspaces != null && !this.workspaces.isEmpty();
    }

    public WorkspacesNested<A> addNewWorkspace() {
        return new WorkspacesNested(-1, null);
    }

    public WorkspacesNested<A> addNewWorkspaceLike(WorkspaceBinding item) {
        return new WorkspacesNested(-1, item);
    }

    public WorkspacesNested<A> setNewWorkspaceLike(int index, WorkspaceBinding item) {
        return new WorkspacesNested(index, item);
    }

    public WorkspacesNested<A> editWorkspace(int index) {
        if (this.workspaces.size() <= index) {
            throw new RuntimeException("Can't edit workspaces. Index exceeds size.");
        }
        return this.setNewWorkspaceLike(index, this.buildWorkspace(index));
    }

    public WorkspacesNested<A> editFirstWorkspace() {
        if (this.workspaces.size() == 0) {
            throw new RuntimeException("Can't edit first workspaces. The list is empty.");
        }
        return this.setNewWorkspaceLike(0, this.buildWorkspace(0));
    }

    public WorkspacesNested<A> editLastWorkspace() {
        int index = this.workspaces.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last workspaces. The list is empty.");
        }
        return this.setNewWorkspaceLike(index, this.buildWorkspace(index));
    }

    public WorkspacesNested<A> editMatchingWorkspace(Predicate<WorkspaceBindingBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.workspaces.size(); ++i) {
            if (!predicate.test(this.workspaces.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching workspaces. No match found.");
        }
        return this.setNewWorkspaceLike(index, this.buildWorkspace(index));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RunSpecFluent that = (RunSpecFluent)((Object)o);
        if (!Objects.equals(this.params, that.params)) {
            return false;
        }
        if (!Objects.equals((Object)this.podTemplate, (Object)that.podTemplate)) {
            return false;
        }
        if (!Objects.equals((Object)this.ref, (Object)that.ref)) {
            return false;
        }
        if (!Objects.equals(this.retries, that.retries)) {
            return false;
        }
        if (!Objects.equals(this.serviceAccountName, that.serviceAccountName)) {
            return false;
        }
        if (!Objects.equals((Object)this.spec, (Object)that.spec)) {
            return false;
        }
        if (!Objects.equals(this.status, that.status)) {
            return false;
        }
        if (!Objects.equals(this.statusMessage, that.statusMessage)) {
            return false;
        }
        if (!Objects.equals(this.timeout, that.timeout)) {
            return false;
        }
        if (!Objects.equals(this.workspaces, that.workspaces)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.params, this.podTemplate, this.ref, this.retries, this.serviceAccountName, this.spec, this.status, this.statusMessage, this.timeout, this.workspaces, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.params != null && !this.params.isEmpty()) {
            sb.append("params:");
            sb.append(this.params + ",");
        }
        if (this.podTemplate != null) {
            sb.append("podTemplate:");
            sb.append(this.podTemplate + ",");
        }
        if (this.ref != null) {
            sb.append("ref:");
            sb.append(this.ref + ",");
        }
        if (this.retries != null) {
            sb.append("retries:");
            sb.append(this.retries + ",");
        }
        if (this.serviceAccountName != null) {
            sb.append("serviceAccountName:");
            sb.append(this.serviceAccountName + ",");
        }
        if (this.spec != null) {
            sb.append("spec:");
            sb.append(this.spec + ",");
        }
        if (this.status != null) {
            sb.append("status:");
            sb.append(this.status + ",");
        }
        if (this.statusMessage != null) {
            sb.append("statusMessage:");
            sb.append(this.statusMessage + ",");
        }
        if (this.timeout != null) {
            sb.append("timeout:");
            sb.append(this.timeout + ",");
        }
        if (this.workspaces != null && !this.workspaces.isEmpty()) {
            sb.append("workspaces:");
            sb.append(this.workspaces + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class WorkspacesNested<N>
    extends WorkspaceBindingFluent<WorkspacesNested<N>>
    implements Nested<N> {
        WorkspaceBindingBuilder builder;
        int index;

        WorkspacesNested(int index, WorkspaceBinding item) {
            this.index = index;
            this.builder = new WorkspaceBindingBuilder(this, item);
        }

        public N and() {
            return (N)RunSpecFluent.this.setToWorkspaces(this.index, this.builder.build());
        }

        public N endWorkspace() {
            return this.and();
        }
    }

    public class SpecNested<N>
    extends EmbeddedRunSpecFluent<SpecNested<N>>
    implements Nested<N> {
        EmbeddedRunSpecBuilder builder;

        SpecNested(EmbeddedRunSpec item) {
            this.builder = new EmbeddedRunSpecBuilder(this, item);
        }

        public N and() {
            return (N)RunSpecFluent.this.withSpec(this.builder.build());
        }

        public N endSpec() {
            return this.and();
        }
    }

    public class RefNested<N>
    extends TaskRefFluent<RefNested<N>>
    implements Nested<N> {
        TaskRefBuilder builder;

        RefNested(TaskRef item) {
            this.builder = new TaskRefBuilder(this, item);
        }

        public N and() {
            return (N)RunSpecFluent.this.withRef(this.builder.build());
        }

        public N endRef() {
            return this.and();
        }
    }

    public class PodTemplateNested<N>
    extends TemplateFluent<PodTemplateNested<N>>
    implements Nested<N> {
        TemplateBuilder builder;

        PodTemplateNested(Template item) {
            this.builder = new TemplateBuilder(this, item);
        }

        public N and() {
            return (N)RunSpecFluent.this.withPodTemplate(this.builder.build());
        }

        public N endPodTemplate() {
            return this.and();
        }
    }

    public class ParamsNested<N>
    extends ParamFluent<ParamsNested<N>>
    implements Nested<N> {
        ParamBuilder builder;
        int index;

        ParamsNested(int index, Param item) {
            this.index = index;
            this.builder = new ParamBuilder(this, item);
        }

        public N and() {
            return (N)RunSpecFluent.this.setToParams(this.index, this.builder.build());
        }

        public N endParam() {
            return this.and();
        }
    }
}

