/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.tekton.pipeline.v1alpha1.Outputs;
import io.fabric8.tekton.pipeline.v1alpha1.OutputsFluent;
import io.fabric8.tekton.pipeline.v1alpha1.TaskResource;
import io.fabric8.tekton.pipeline.v1alpha1.TaskResourceBuilder;
import io.fabric8.tekton.pipeline.v1alpha1.TaskResourceFluentImpl;
import io.fabric8.tekton.pipeline.v1alpha1.TestResult;
import io.fabric8.tekton.pipeline.v1alpha1.TestResultBuilder;
import io.fabric8.tekton.pipeline.v1alpha1.TestResultFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OutputsFluentImpl<A extends OutputsFluent<A>>
extends BaseFluent<A>
implements OutputsFluent<A> {
    private List<TaskResourceBuilder> resources;
    private List<TestResultBuilder> results;

    public OutputsFluentImpl() {
    }

    public OutputsFluentImpl(Outputs instance) {
        this.withResources(instance.getResources());
        this.withResults(instance.getResults());
    }

    @Override
    public A addToResources(int index, TaskResource item) {
        if (this.resources == null) {
            this.resources = new ArrayList<TaskResourceBuilder>();
        }
        TaskResourceBuilder builder = new TaskResourceBuilder(item);
        this._visitables.get((Object)"resources").add(index >= 0 ? index : this._visitables.get((Object)"resources").size(), builder);
        this.resources.add(index >= 0 ? index : this.resources.size(), builder);
        return (A)this;
    }

    @Override
    public A setToResources(int index, TaskResource item) {
        if (this.resources == null) {
            this.resources = new ArrayList<TaskResourceBuilder>();
        }
        TaskResourceBuilder builder = new TaskResourceBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"resources").size()) {
            this._visitables.get((Object)"resources").add(builder);
        } else {
            this._visitables.get((Object)"resources").set(index, builder);
        }
        if (index < 0 || index >= this.resources.size()) {
            this.resources.add(builder);
        } else {
            this.resources.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToResources(TaskResource ... items) {
        if (this.resources == null) {
            this.resources = new ArrayList<TaskResourceBuilder>();
        }
        for (TaskResource item : items) {
            TaskResourceBuilder builder = new TaskResourceBuilder(item);
            this._visitables.get((Object)"resources").add(builder);
            this.resources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToResources(Collection<TaskResource> items) {
        if (this.resources == null) {
            this.resources = new ArrayList<TaskResourceBuilder>();
        }
        for (TaskResource item : items) {
            TaskResourceBuilder builder = new TaskResourceBuilder(item);
            this._visitables.get((Object)"resources").add(builder);
            this.resources.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromResources(TaskResource ... items) {
        for (TaskResource item : items) {
            TaskResourceBuilder builder = new TaskResourceBuilder(item);
            this._visitables.get((Object)"resources").remove(builder);
            if (this.resources == null) continue;
            this.resources.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromResources(Collection<TaskResource> items) {
        for (TaskResource item : items) {
            TaskResourceBuilder builder = new TaskResourceBuilder(item);
            this._visitables.get((Object)"resources").remove(builder);
            if (this.resources == null) continue;
            this.resources.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<TaskResource> getResources() {
        return OutputsFluentImpl.build(this.resources);
    }

    @Override
    public List<TaskResource> buildResources() {
        return OutputsFluentImpl.build(this.resources);
    }

    @Override
    public TaskResource buildResource(int index) {
        return this.resources.get(index).build();
    }

    @Override
    public TaskResource buildFirstResource() {
        return this.resources.get(0).build();
    }

    @Override
    public TaskResource buildLastResource() {
        return this.resources.get(this.resources.size() - 1).build();
    }

    @Override
    public TaskResource buildMatchingResource(Predicate<TaskResourceBuilder> predicate) {
        for (TaskResourceBuilder item : this.resources) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingResource(Predicate<TaskResourceBuilder> predicate) {
        for (TaskResourceBuilder item : this.resources) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withResources(List<TaskResource> resources) {
        if (this.resources != null) {
            this._visitables.get((Object)"resources").removeAll(this.resources);
        }
        if (resources != null) {
            this.resources = new ArrayList<TaskResourceBuilder>();
            for (TaskResource item : resources) {
                this.addToResources(item);
            }
        } else {
            this.resources = new ArrayList<TaskResourceBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withResources(TaskResource ... resources) {
        if (this.resources != null) {
            this.resources.clear();
        }
        if (resources != null) {
            for (TaskResource item : resources) {
                this.addToResources(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasResources() {
        return this.resources != null && !this.resources.isEmpty();
    }

    @Override
    public OutputsFluent.ResourcesNested<A> addNewResource() {
        return new ResourcesNestedImpl();
    }

    @Override
    public OutputsFluent.ResourcesNested<A> addNewResourceLike(TaskResource item) {
        return new ResourcesNestedImpl(-1, item);
    }

    @Override
    public OutputsFluent.ResourcesNested<A> setNewResourceLike(int index, TaskResource item) {
        return new ResourcesNestedImpl(index, item);
    }

    @Override
    public OutputsFluent.ResourcesNested<A> editResource(int index) {
        if (this.resources.size() <= index) {
            throw new RuntimeException("Can't edit resources. Index exceeds size.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    @Override
    public OutputsFluent.ResourcesNested<A> editFirstResource() {
        if (this.resources.size() == 0) {
            throw new RuntimeException("Can't edit first resources. The list is empty.");
        }
        return this.setNewResourceLike(0, this.buildResource(0));
    }

    @Override
    public OutputsFluent.ResourcesNested<A> editLastResource() {
        int index = this.resources.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last resources. The list is empty.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    @Override
    public OutputsFluent.ResourcesNested<A> editMatchingResource(Predicate<TaskResourceBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resources.size(); ++i) {
            if (!predicate.apply((Object)this.resources.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching resources. No match found.");
        }
        return this.setNewResourceLike(index, this.buildResource(index));
    }

    @Override
    public A addToResults(int index, TestResult item) {
        if (this.results == null) {
            this.results = new ArrayList<TestResultBuilder>();
        }
        TestResultBuilder builder = new TestResultBuilder(item);
        this._visitables.get((Object)"results").add(index >= 0 ? index : this._visitables.get((Object)"results").size(), builder);
        this.results.add(index >= 0 ? index : this.results.size(), builder);
        return (A)this;
    }

    @Override
    public A setToResults(int index, TestResult item) {
        if (this.results == null) {
            this.results = new ArrayList<TestResultBuilder>();
        }
        TestResultBuilder builder = new TestResultBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"results").size()) {
            this._visitables.get((Object)"results").add(builder);
        } else {
            this._visitables.get((Object)"results").set(index, builder);
        }
        if (index < 0 || index >= this.results.size()) {
            this.results.add(builder);
        } else {
            this.results.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToResults(TestResult ... items) {
        if (this.results == null) {
            this.results = new ArrayList<TestResultBuilder>();
        }
        for (TestResult item : items) {
            TestResultBuilder builder = new TestResultBuilder(item);
            this._visitables.get((Object)"results").add(builder);
            this.results.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToResults(Collection<TestResult> items) {
        if (this.results == null) {
            this.results = new ArrayList<TestResultBuilder>();
        }
        for (TestResult item : items) {
            TestResultBuilder builder = new TestResultBuilder(item);
            this._visitables.get((Object)"results").add(builder);
            this.results.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromResults(TestResult ... items) {
        for (TestResult item : items) {
            TestResultBuilder builder = new TestResultBuilder(item);
            this._visitables.get((Object)"results").remove(builder);
            if (this.results == null) continue;
            this.results.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromResults(Collection<TestResult> items) {
        for (TestResult item : items) {
            TestResultBuilder builder = new TestResultBuilder(item);
            this._visitables.get((Object)"results").remove(builder);
            if (this.results == null) continue;
            this.results.remove(builder);
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<TestResult> getResults() {
        return OutputsFluentImpl.build(this.results);
    }

    @Override
    public List<TestResult> buildResults() {
        return OutputsFluentImpl.build(this.results);
    }

    @Override
    public TestResult buildResult(int index) {
        return this.results.get(index).build();
    }

    @Override
    public TestResult buildFirstResult() {
        return this.results.get(0).build();
    }

    @Override
    public TestResult buildLastResult() {
        return this.results.get(this.results.size() - 1).build();
    }

    @Override
    public TestResult buildMatchingResult(Predicate<TestResultBuilder> predicate) {
        for (TestResultBuilder item : this.results) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingResult(Predicate<TestResultBuilder> predicate) {
        for (TestResultBuilder item : this.results) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withResults(List<TestResult> results) {
        if (this.results != null) {
            this._visitables.get((Object)"results").removeAll(this.results);
        }
        if (results != null) {
            this.results = new ArrayList<TestResultBuilder>();
            for (TestResult item : results) {
                this.addToResults(item);
            }
        } else {
            this.results = new ArrayList<TestResultBuilder>();
        }
        return (A)this;
    }

    @Override
    public A withResults(TestResult ... results) {
        if (this.results != null) {
            this.results.clear();
        }
        if (results != null) {
            for (TestResult item : results) {
                this.addToResults(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasResults() {
        return this.results != null && !this.results.isEmpty();
    }

    @Override
    public A addNewResult(String format, String name, String path) {
        return this.addToResults(new TestResult(format, name, path));
    }

    @Override
    public OutputsFluent.ResultsNested<A> addNewResult() {
        return new ResultsNestedImpl();
    }

    @Override
    public OutputsFluent.ResultsNested<A> addNewResultLike(TestResult item) {
        return new ResultsNestedImpl(-1, item);
    }

    @Override
    public OutputsFluent.ResultsNested<A> setNewResultLike(int index, TestResult item) {
        return new ResultsNestedImpl(index, item);
    }

    @Override
    public OutputsFluent.ResultsNested<A> editResult(int index) {
        if (this.results.size() <= index) {
            throw new RuntimeException("Can't edit results. Index exceeds size.");
        }
        return this.setNewResultLike(index, this.buildResult(index));
    }

    @Override
    public OutputsFluent.ResultsNested<A> editFirstResult() {
        if (this.results.size() == 0) {
            throw new RuntimeException("Can't edit first results. The list is empty.");
        }
        return this.setNewResultLike(0, this.buildResult(0));
    }

    @Override
    public OutputsFluent.ResultsNested<A> editLastResult() {
        int index = this.results.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last results. The list is empty.");
        }
        return this.setNewResultLike(index, this.buildResult(index));
    }

    @Override
    public OutputsFluent.ResultsNested<A> editMatchingResult(Predicate<TestResultBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.results.size(); ++i) {
            if (!predicate.apply((Object)this.results.get(i)).booleanValue()) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching results. No match found.");
        }
        return this.setNewResultLike(index, this.buildResult(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        OutputsFluentImpl that = (OutputsFluentImpl)o;
        if (this.resources != null ? !this.resources.equals(that.resources) : that.resources != null) {
            return false;
        }
        return !(this.results != null ? !this.results.equals(that.results) : that.results != null);
    }

    public class ResultsNestedImpl<N>
    extends TestResultFluentImpl<OutputsFluent.ResultsNested<N>>
    implements OutputsFluent.ResultsNested<N>,
    Nested<N> {
        private final TestResultBuilder builder;
        private final int index;

        ResultsNestedImpl(int index, TestResult item) {
            this.index = index;
            this.builder = new TestResultBuilder(this, item);
        }

        ResultsNestedImpl() {
            this.index = -1;
            this.builder = new TestResultBuilder(this);
        }

        @Override
        public N and() {
            return (N)OutputsFluentImpl.this.setToResults(this.index, this.builder.build());
        }

        @Override
        public N endResult() {
            return this.and();
        }
    }

    public class ResourcesNestedImpl<N>
    extends TaskResourceFluentImpl<OutputsFluent.ResourcesNested<N>>
    implements OutputsFluent.ResourcesNested<N>,
    Nested<N> {
        private final TaskResourceBuilder builder;
        private final int index;

        ResourcesNestedImpl(int index, TaskResource item) {
            this.index = index;
            this.builder = new TaskResourceBuilder(this, item);
        }

        ResourcesNestedImpl() {
            this.index = -1;
            this.builder = new TaskResourceBuilder(this);
        }

        @Override
        public N and() {
            return (N)OutputsFluentImpl.this.setToResources(this.index, this.builder.build());
        }

        @Override
        public N endResource() {
            return this.and();
        }
    }
}

