/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Predicate;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.tekton.pipeline.v1alpha1.Inputs;
import io.fabric8.tekton.pipeline.v1alpha1.InputsBuilder;
import io.fabric8.tekton.pipeline.v1alpha1.InputsFluentImpl;
import io.fabric8.tekton.pipeline.v1alpha1.Outputs;
import io.fabric8.tekton.pipeline.v1alpha1.OutputsBuilder;
import io.fabric8.tekton.pipeline.v1alpha1.OutputsFluentImpl;
import io.fabric8.tekton.pipeline.v1alpha1.TaskSpec;
import io.fabric8.tekton.pipeline.v1alpha1.TaskSpecFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TaskSpecFluentImpl<A extends TaskSpecFluent<A>>
extends BaseFluent<A>
implements TaskSpecFluent<A> {
    private Container containerTemplate;
    private InputsBuilder inputs;
    private OutputsBuilder outputs;
    private Container stepTemplate;
    private List<Container> steps;
    private List<Volume> volumes;

    public TaskSpecFluentImpl() {
    }

    public TaskSpecFluentImpl(TaskSpec instance) {
        this.withContainerTemplate(instance.getContainerTemplate());
        this.withInputs(instance.getInputs());
        this.withOutputs(instance.getOutputs());
        this.withStepTemplate(instance.getStepTemplate());
        this.withSteps(instance.getSteps());
        this.withVolumes(instance.getVolumes());
    }

    @Override
    public Container getContainerTemplate() {
        return this.containerTemplate;
    }

    @Override
    public A withContainerTemplate(Container containerTemplate) {
        this.containerTemplate = containerTemplate;
        return (A)this;
    }

    @Override
    public Boolean hasContainerTemplate() {
        return this.containerTemplate != null;
    }

    @Override
    @Deprecated
    public Inputs getInputs() {
        return this.inputs != null ? this.inputs.build() : null;
    }

    @Override
    public Inputs buildInputs() {
        return this.inputs != null ? this.inputs.build() : null;
    }

    @Override
    public A withInputs(Inputs inputs) {
        this._visitables.get((Object)"inputs").remove(this.inputs);
        if (inputs != null) {
            this.inputs = new InputsBuilder(inputs);
            this._visitables.get((Object)"inputs").add(this.inputs);
        }
        return (A)this;
    }

    @Override
    public Boolean hasInputs() {
        return this.inputs != null;
    }

    @Override
    public TaskSpecFluent.InputsNested<A> withNewInputs() {
        return new InputsNestedImpl();
    }

    @Override
    public TaskSpecFluent.InputsNested<A> withNewInputsLike(Inputs item) {
        return new InputsNestedImpl(item);
    }

    @Override
    public TaskSpecFluent.InputsNested<A> editInputs() {
        return this.withNewInputsLike(this.getInputs());
    }

    @Override
    public TaskSpecFluent.InputsNested<A> editOrNewInputs() {
        return this.withNewInputsLike(this.getInputs() != null ? this.getInputs() : new InputsBuilder().build());
    }

    @Override
    public TaskSpecFluent.InputsNested<A> editOrNewInputsLike(Inputs item) {
        return this.withNewInputsLike(this.getInputs() != null ? this.getInputs() : item);
    }

    @Override
    @Deprecated
    public Outputs getOutputs() {
        return this.outputs != null ? this.outputs.build() : null;
    }

    @Override
    public Outputs buildOutputs() {
        return this.outputs != null ? this.outputs.build() : null;
    }

    @Override
    public A withOutputs(Outputs outputs) {
        this._visitables.get((Object)"outputs").remove(this.outputs);
        if (outputs != null) {
            this.outputs = new OutputsBuilder(outputs);
            this._visitables.get((Object)"outputs").add(this.outputs);
        }
        return (A)this;
    }

    @Override
    public Boolean hasOutputs() {
        return this.outputs != null;
    }

    @Override
    public TaskSpecFluent.OutputsNested<A> withNewOutputs() {
        return new OutputsNestedImpl();
    }

    @Override
    public TaskSpecFluent.OutputsNested<A> withNewOutputsLike(Outputs item) {
        return new OutputsNestedImpl(item);
    }

    @Override
    public TaskSpecFluent.OutputsNested<A> editOutputs() {
        return this.withNewOutputsLike(this.getOutputs());
    }

    @Override
    public TaskSpecFluent.OutputsNested<A> editOrNewOutputs() {
        return this.withNewOutputsLike(this.getOutputs() != null ? this.getOutputs() : new OutputsBuilder().build());
    }

    @Override
    public TaskSpecFluent.OutputsNested<A> editOrNewOutputsLike(Outputs item) {
        return this.withNewOutputsLike(this.getOutputs() != null ? this.getOutputs() : item);
    }

    @Override
    public Container getStepTemplate() {
        return this.stepTemplate;
    }

    @Override
    public A withStepTemplate(Container stepTemplate) {
        this.stepTemplate = stepTemplate;
        return (A)this;
    }

    @Override
    public Boolean hasStepTemplate() {
        return this.stepTemplate != null;
    }

    @Override
    public A addToSteps(int index, Container item) {
        if (this.steps == null) {
            this.steps = new ArrayList<Container>();
        }
        this.steps.add(index, item);
        return (A)this;
    }

    @Override
    public A setToSteps(int index, Container item) {
        if (this.steps == null) {
            this.steps = new ArrayList<Container>();
        }
        this.steps.set(index, item);
        return (A)this;
    }

    @Override
    public A addToSteps(Container ... items) {
        if (this.steps == null) {
            this.steps = new ArrayList<Container>();
        }
        for (Container item : items) {
            this.steps.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToSteps(Collection<Container> items) {
        if (this.steps == null) {
            this.steps = new ArrayList<Container>();
        }
        for (Container item : items) {
            this.steps.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromSteps(Container ... items) {
        for (Container item : items) {
            if (this.steps == null) continue;
            this.steps.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromSteps(Collection<Container> items) {
        for (Container item : items) {
            if (this.steps == null) continue;
            this.steps.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Container> getSteps() {
        return this.steps;
    }

    @Override
    public Container getStep(int index) {
        return this.steps.get(index);
    }

    @Override
    public Container getFirstStep() {
        return this.steps.get(0);
    }

    @Override
    public Container getLastStep() {
        return this.steps.get(this.steps.size() - 1);
    }

    @Override
    public Container getMatchingStep(Predicate<Container> predicate) {
        for (Container item : this.steps) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingStep(Predicate<Container> predicate) {
        for (Container item : this.steps) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withSteps(List<Container> steps) {
        if (this.steps != null) {
            this._visitables.get((Object)"steps").removeAll(this.steps);
        }
        if (steps != null) {
            this.steps = new ArrayList<Container>();
            for (Container item : steps) {
                this.addToSteps(item);
            }
        } else {
            this.steps = new ArrayList<Container>();
        }
        return (A)this;
    }

    @Override
    public A withSteps(Container ... steps) {
        if (this.steps != null) {
            this.steps.clear();
        }
        if (steps != null) {
            for (Container item : steps) {
                this.addToSteps(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasSteps() {
        return this.steps != null && !this.steps.isEmpty();
    }

    @Override
    public A addToVolumes(int index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<Volume>();
        }
        this.volumes.add(index, item);
        return (A)this;
    }

    @Override
    public A setToVolumes(int index, Volume item) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<Volume>();
        }
        this.volumes.set(index, item);
        return (A)this;
    }

    @Override
    public A addToVolumes(Volume ... items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<Volume>();
        }
        for (Volume item : items) {
            this.volumes.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToVolumes(Collection<Volume> items) {
        if (this.volumes == null) {
            this.volumes = new ArrayList<Volume>();
        }
        for (Volume item : items) {
            this.volumes.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromVolumes(Volume ... items) {
        for (Volume item : items) {
            if (this.volumes == null) continue;
            this.volumes.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromVolumes(Collection<Volume> items) {
        for (Volume item : items) {
            if (this.volumes == null) continue;
            this.volumes.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<Volume> getVolumes() {
        return this.volumes;
    }

    @Override
    public Volume getVolume(int index) {
        return this.volumes.get(index);
    }

    @Override
    public Volume getFirstVolume() {
        return this.volumes.get(0);
    }

    @Override
    public Volume getLastVolume() {
        return this.volumes.get(this.volumes.size() - 1);
    }

    @Override
    public Volume getMatchingVolume(Predicate<Volume> predicate) {
        for (Volume item : this.volumes) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingVolume(Predicate<Volume> predicate) {
        for (Volume item : this.volumes) {
            if (!predicate.apply((Object)item).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withVolumes(List<Volume> volumes) {
        if (this.volumes != null) {
            this._visitables.get((Object)"volumes").removeAll(this.volumes);
        }
        if (volumes != null) {
            this.volumes = new ArrayList<Volume>();
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        } else {
            this.volumes = new ArrayList<Volume>();
        }
        return (A)this;
    }

    @Override
    public A withVolumes(Volume ... volumes) {
        if (this.volumes != null) {
            this.volumes.clear();
        }
        if (volumes != null) {
            for (Volume item : volumes) {
                this.addToVolumes(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasVolumes() {
        return this.volumes != null && !this.volumes.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TaskSpecFluentImpl that = (TaskSpecFluentImpl)o;
        if (this.containerTemplate != null ? !this.containerTemplate.equals((Object)that.containerTemplate) : that.containerTemplate != null) {
            return false;
        }
        if (this.inputs != null ? !this.inputs.equals(that.inputs) : that.inputs != null) {
            return false;
        }
        if (this.outputs != null ? !this.outputs.equals(that.outputs) : that.outputs != null) {
            return false;
        }
        if (this.stepTemplate != null ? !this.stepTemplate.equals((Object)that.stepTemplate) : that.stepTemplate != null) {
            return false;
        }
        if (this.steps != null ? !this.steps.equals(that.steps) : that.steps != null) {
            return false;
        }
        return !(this.volumes != null ? !this.volumes.equals(that.volumes) : that.volumes != null);
    }

    public class OutputsNestedImpl<N>
    extends OutputsFluentImpl<TaskSpecFluent.OutputsNested<N>>
    implements TaskSpecFluent.OutputsNested<N>,
    Nested<N> {
        private final OutputsBuilder builder;

        OutputsNestedImpl(Outputs item) {
            this.builder = new OutputsBuilder(this, item);
        }

        OutputsNestedImpl() {
            this.builder = new OutputsBuilder(this);
        }

        @Override
        public N and() {
            return (N)TaskSpecFluentImpl.this.withOutputs(this.builder.build());
        }

        @Override
        public N endOutputs() {
            return this.and();
        }
    }

    public class InputsNestedImpl<N>
    extends InputsFluentImpl<TaskSpecFluent.InputsNested<N>>
    implements TaskSpecFluent.InputsNested<N>,
    Nested<N> {
        private final InputsBuilder builder;

        InputsNestedImpl(Inputs item) {
            this.builder = new InputsBuilder(this, item);
        }

        InputsNestedImpl() {
            this.builder = new InputsBuilder(this);
        }

        @Override
        public N and() {
            return (N)TaskSpecFluentImpl.this.withInputs(this.builder.build());
        }

        @Override
        public N endInputs() {
            return this.and();
        }
    }
}

