/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.pipeline.v1alpha1;

import io.fabric8.kubernetes.api.builder.ValidationUtils;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.tekton.pipeline.v1alpha1.Pipeline;
import io.fabric8.tekton.pipeline.v1alpha1.PipelineFluent;
import io.fabric8.tekton.pipeline.v1alpha1.PipelineFluentImpl;
import javax.validation.Validator;

public class PipelineBuilder
extends PipelineFluentImpl<PipelineBuilder>
implements VisitableBuilder<Pipeline, PipelineBuilder> {
    PipelineFluent<?> fluent;
    Boolean validationEnabled;
    Validator validator;

    public PipelineBuilder() {
        this(true);
    }

    public PipelineBuilder(Boolean validationEnabled) {
        this(new Pipeline(), validationEnabled);
    }

    public PipelineBuilder(PipelineFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public PipelineBuilder(PipelineFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Pipeline(), validationEnabled);
    }

    public PipelineBuilder(PipelineFluent<?> fluent, Pipeline instance) {
        this(fluent, instance, true);
    }

    public PipelineBuilder(PipelineFluent<?> fluent, Pipeline instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public PipelineBuilder(Pipeline instance) {
        this(instance, (Boolean)true);
    }

    public PipelineBuilder(Pipeline instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validationEnabled = validationEnabled;
    }

    public PipelineBuilder(Validator validator) {
        this(new Pipeline(), (Boolean)true);
    }

    public PipelineBuilder(PipelineFluent<?> fluent, Pipeline instance, Validator validator) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        fluent.withSpec(instance.getSpec());
        fluent.withStatus(instance.getStatus());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public PipelineBuilder(Pipeline instance, Validator validator) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
        this.validator = validator;
        this.validationEnabled = validator != null;
    }

    public Pipeline build() {
        Pipeline buildable = new Pipeline(this.fluent.getApiVersion(), this.fluent.getKind(), this.fluent.getMetadata(), this.fluent.getSpec(), this.fluent.getStatus());
        if (this.validationEnabled.booleanValue()) {
            ValidationUtils.validate((Object)buildable, (Validator)this.validator);
        }
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PipelineBuilder that = (PipelineBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

