/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.tekton.client;

import io.fabric8.kubernetes.api.model.RootPaths;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.ExtensionAdapter;
import io.fabric8.tekton.client.DefaultTektonClient;
import io.fabric8.tekton.client.TektonClient;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import okhttp3.OkHttpClient;

public class TektonExtensionAdapter
implements ExtensionAdapter<TektonClient> {
    static final ConcurrentMap<URL, Boolean> IS_TEKTON = new ConcurrentHashMap<URL, Boolean>();
    static final ConcurrentMap<URL, Boolean> USES_TEKTON_APIGROUPS = new ConcurrentHashMap<URL, Boolean>();

    public Class<TektonClient> getExtensionType() {
        return TektonClient.class;
    }

    public Boolean isAdaptable(Client client) {
        return this.isTektonAvailable(client);
    }

    public TektonClient adapt(Client client) {
        return new DefaultTektonClient((OkHttpClient)client.adapt(OkHttpClient.class), client.getConfiguration());
    }

    private boolean isTektonAvailable(Client client) {
        List paths;
        URL masterUrl = client.getMasterUrl();
        if (IS_TEKTON.containsKey(masterUrl)) {
            return (Boolean)IS_TEKTON.get(masterUrl);
        }
        RootPaths rootPaths = client.rootPaths();
        if (rootPaths != null && (paths = rootPaths.getPaths()) != null) {
            for (String path : paths) {
                if (!path.endsWith("tekton.dev") && !path.contains("tekton.dev/")) continue;
                USES_TEKTON_APIGROUPS.putIfAbsent(masterUrl, true);
                IS_TEKTON.putIfAbsent(masterUrl, true);
                return true;
            }
        }
        IS_TEKTON.putIfAbsent(masterUrl, false);
        return false;
    }
}

