/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.swagger.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.swagger.model.Api;
import io.fabric8.swagger.model.Authorizations_;
import io.fabric8.swagger.model.Models;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Valid;
import javax.validation.constraints.Pattern;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"swaggerVersion", "apiVersion", "basePath", "resourcePath", "apis", "models", "produces", "consumes", "authorizations"})
public class ApiDeclaration {
    @JsonProperty(value="swaggerVersion")
    private SwaggerVersion swaggerVersion;
    @JsonProperty(value="apiVersion")
    private String apiVersion;
    @JsonProperty(value="basePath")
    @Pattern(regexp="^https?://")
    private URI basePath;
    @JsonProperty(value="resourcePath")
    @Pattern(regexp="^/")
    private String resourcePath;
    @JsonProperty(value="apis")
    @Valid
    private List<Api> apis = new ArrayList<Api>();
    @JsonProperty(value="models")
    @Valid
    private Models models;
    @JsonProperty(value="produces")
    @JsonDeserialize(as=LinkedHashSet.class)
    @Valid
    private Set<String> produces = new LinkedHashSet<String>();
    @JsonProperty(value="consumes")
    @JsonDeserialize(as=LinkedHashSet.class)
    @Valid
    private Set<String> consumes = new LinkedHashSet<String>();
    @JsonProperty(value="authorizations")
    @Valid
    private Authorizations_ authorizations;

    @JsonProperty(value="swaggerVersion")
    public SwaggerVersion getSwaggerVersion() {
        return this.swaggerVersion;
    }

    @JsonProperty(value="swaggerVersion")
    public void setSwaggerVersion(SwaggerVersion swaggerVersion) {
        this.swaggerVersion = swaggerVersion;
    }

    @JsonProperty(value="apiVersion")
    public String getApiVersion() {
        return this.apiVersion;
    }

    @JsonProperty(value="apiVersion")
    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    @JsonProperty(value="basePath")
    public URI getBasePath() {
        return this.basePath;
    }

    @JsonProperty(value="basePath")
    public void setBasePath(URI basePath) {
        this.basePath = basePath;
    }

    @JsonProperty(value="resourcePath")
    public String getResourcePath() {
        return this.resourcePath;
    }

    @JsonProperty(value="resourcePath")
    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    @JsonProperty(value="apis")
    public List<Api> getApis() {
        return this.apis;
    }

    @JsonProperty(value="apis")
    public void setApis(List<Api> apis) {
        this.apis = apis;
    }

    @JsonProperty(value="models")
    public Models getModels() {
        return this.models;
    }

    @JsonProperty(value="models")
    public void setModels(Models models) {
        this.models = models;
    }

    @JsonProperty(value="produces")
    public Set<String> getProduces() {
        return this.produces;
    }

    @JsonProperty(value="produces")
    public void setProduces(Set<String> produces) {
        this.produces = produces;
    }

    @JsonProperty(value="consumes")
    public Set<String> getConsumes() {
        return this.consumes;
    }

    @JsonProperty(value="consumes")
    public void setConsumes(Set<String> consumes) {
        this.consumes = consumes;
    }

    @JsonProperty(value="authorizations")
    public Authorizations_ getAuthorizations() {
        return this.authorizations;
    }

    @JsonProperty(value="authorizations")
    public void setAuthorizations(Authorizations_ authorizations) {
        this.authorizations = authorizations;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other);
    }

    public static enum SwaggerVersion {
        _1_2("1.2");

        private final String value;
        private static Map<String, SwaggerVersion> constants;

        private SwaggerVersion(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static SwaggerVersion fromValue(String value) {
            SwaggerVersion constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            constants = new HashMap<String, SwaggerVersion>();
            for (SwaggerVersion c : SwaggerVersion.values()) {
                constants.put(c.value, c);
            }
        }
    }
}

