/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.runtime.embedded.registration;

import io.fabric8.api.ContainerRegistration;
import io.fabric8.api.GeoLocationService;
import io.fabric8.api.RuntimeProperties;
import io.fabric8.api.ZkDefs;
import io.fabric8.api.jcip.ThreadSafe;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.utils.HostUtils;
import io.fabric8.zookeeper.ZkPath;
import io.fabric8.zookeeper.utils.ZooKeeperUtils;
import java.util.Arrays;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Component(name="io.fabric8.container.registration.embedded", label="Fabric8 Embedded Registration", immediate=true, metatype=false)
@Service(value={ContainerRegistration.class, ConnectionStateListener.class})
public class EmbeddedContainerRegistration
extends AbstractComponent
implements ContainerRegistration,
ConnectionStateListener {
    private transient Logger LOGGER = LoggerFactory.getLogger(EmbeddedContainerRegistration.class);
    @Reference(referenceInterface=RuntimeProperties.class)
    private final ValidatingReference<RuntimeProperties> runtimeProperties = new ValidatingReference();
    @Reference(referenceInterface=CuratorFramework.class)
    private final ValidatingReference<CuratorFramework> curator = new ValidatingReference();
    @Reference(referenceInterface=GeoLocationService.class)
    private final ValidatingReference<GeoLocationService> geoLocationService = new ValidatingReference();

    @Activate
    void activate() {
        this.activateInternal();
        this.activateComponent();
    }

    @Deactivate
    void deactivate() {
        this.deactivateComponent();
    }

    private void activateInternal() {
        RuntimeProperties sysprops = (RuntimeProperties)this.runtimeProperties.get();
        String karafName = sysprops.getRuntimeIdentity();
        String version = sysprops.getProperty("fabric.version", "1.0");
        String profiles = sysprops.getProperty("fabric.profiles");
        try {
            if (profiles != null) {
                String versionNode = ZkPath.CONFIG_CONTAINER.getPath(new String[]{karafName});
                String profileNode = ZkPath.CONFIG_VERSIONS_CONTAINER.getPath(new String[]{version, karafName});
                ZooKeeperUtils.createDefault((CuratorFramework)((CuratorFramework)this.curator.get()), (String)versionNode, (String)version);
                ZooKeeperUtils.createDefault((CuratorFramework)((CuratorFramework)this.curator.get()), (String)profileNode, (String)profiles);
            }
            this.checkAlive();
            String domainsNode = ZkPath.CONTAINER_DOMAINS.getPath(new String[]{karafName});
            Stat stat = ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)domainsNode);
            if (stat != null) {
                ZooKeeperUtils.deleteSafe((CuratorFramework)((CuratorFramework)this.curator.get()), (String)domainsNode);
            }
            ZooKeeperUtils.createDefault((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_BINDADDRESS.getPath(new String[]{karafName}), (String)sysprops.getProperty("bind.address", "0.0.0.0"));
            ZooKeeperUtils.createDefault((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_RESOLVER.getPath(new String[]{karafName}), (String)this.getContainerResolutionPolicy(sysprops, (CuratorFramework)this.curator.get(), karafName));
            ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_LOCAL_HOSTNAME.getPath(new String[]{karafName}), (String)HostUtils.getLocalHostName());
            ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_LOCAL_IP.getPath(new String[]{karafName}), (String)HostUtils.getLocalIp());
            ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_IP.getPath(new String[]{karafName}), (String)EmbeddedContainerRegistration.getContainerPointer((CuratorFramework)this.curator.get(), karafName));
            ZooKeeperUtils.createDefault((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_GEOLOCATION.getPath(new String[]{karafName}), (String)((GeoLocationService)this.geoLocationService.get()).getGeoLocation());
            for (String resolver : ZkDefs.VALID_RESOLVERS) {
                String address = sysprops.getProperty(resolver);
                if (address == null || address.isEmpty() || ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_ADDRESS.getPath(new String[]{karafName, resolver})) != null) continue;
                ZooKeeperUtils.setData((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_ADDRESS.getPath(new String[]{karafName, resolver}), (String)address);
            }
            String minimumPort = sysprops.getProperty("minimum.port");
            String maximumPort = sysprops.getProperty("maximum.port");
            ZooKeeperUtils.createDefault((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_PORT_MIN.getPath(new String[]{karafName}), (String)minimumPort);
            ZooKeeperUtils.createDefault((CuratorFramework)((CuratorFramework)this.curator.get()), (String)ZkPath.CONTAINER_PORT_MAX.getPath(new String[]{karafName}), (String)maximumPort);
        }
        catch (Exception e) {
            this.LOGGER.warn("Error updating Fabric Container information. This exception will be ignored.", (Throwable)e);
        }
    }

    public void stateChanged(CuratorFramework client, ConnectionState newState) {
        if (this.isValid()) {
            switch (newState) {
                case CONNECTED: 
                case RECONNECTED: {
                    try {
                        this.checkAlive();
                        break;
                    }
                    catch (Exception ex) {
                        this.LOGGER.error("Error while checking/setting container status.");
                    }
                }
            }
        }
    }

    private void checkAlive() throws Exception {
        RuntimeProperties sysprops = (RuntimeProperties)this.runtimeProperties.get();
        String runtimeIdentity = sysprops.getRuntimeIdentity();
        String nodeAlive = ZkPath.CONTAINER_ALIVE.getPath(new String[]{runtimeIdentity});
        Stat stat = ZooKeeperUtils.exists((CuratorFramework)((CuratorFramework)this.curator.get()), (String)nodeAlive);
        if (stat != null) {
            if (stat.getEphemeralOwner() != ((CuratorFramework)this.curator.get()).getZookeeperClient().getZooKeeper().getSessionId()) {
                ZooKeeperUtils.delete((CuratorFramework)((CuratorFramework)this.curator.get()), (String)nodeAlive);
                ZooKeeperUtils.create((CuratorFramework)((CuratorFramework)this.curator.get()), (String)nodeAlive, (CreateMode)CreateMode.EPHEMERAL);
            }
        } else {
            ZooKeeperUtils.create((CuratorFramework)((CuratorFramework)this.curator.get()), (String)nodeAlive, (CreateMode)CreateMode.EPHEMERAL);
        }
    }

    private String getGlobalResolutionPolicy(RuntimeProperties sysprops, CuratorFramework zooKeeper) throws Exception {
        String policy = "localhostname";
        List<String> validResolverList = Arrays.asList(ZkDefs.VALID_RESOLVERS);
        if (ZooKeeperUtils.exists((CuratorFramework)zooKeeper, (String)ZkPath.POLICIES.getPath(new String[]{"resolver"})) != null) {
            policy = ZooKeeperUtils.getStringData((CuratorFramework)zooKeeper, (String)ZkPath.POLICIES.getPath(new String[]{"resolver"}));
        } else if (sysprops.getProperty("global.resolver") != null && validResolverList.contains(sysprops.getProperty("global.resolver"))) {
            policy = sysprops.getProperty("global.resolver");
            ZooKeeperUtils.setData((CuratorFramework)zooKeeper, (String)ZkPath.POLICIES.getPath(new String[]{"resolver"}), (String)policy);
        }
        return policy;
    }

    private String getContainerResolutionPolicy(RuntimeProperties sysprops, CuratorFramework zooKeeper, String container) throws Exception {
        String policy = null;
        List<String> validResolverList = Arrays.asList(ZkDefs.VALID_RESOLVERS);
        if (ZooKeeperUtils.exists((CuratorFramework)zooKeeper, (String)ZkPath.CONTAINER_RESOLVER.getPath(new String[]{container})) != null) {
            policy = ZooKeeperUtils.getStringData((CuratorFramework)zooKeeper, (String)ZkPath.CONTAINER_RESOLVER.getPath(new String[]{container}));
        } else if (sysprops.getProperty("local.resolver") != null && validResolverList.contains(sysprops.getProperty("local.resolver"))) {
            policy = sysprops.getProperty("local.resolver");
        }
        if (policy == null) {
            policy = this.getGlobalResolutionPolicy(sysprops, zooKeeper);
        }
        if (policy != null && ZooKeeperUtils.exists((CuratorFramework)zooKeeper, (String)ZkPath.CONTAINER_RESOLVER.getPath(new String[]{container})) == null) {
            ZooKeeperUtils.setData((CuratorFramework)zooKeeper, (String)ZkPath.CONTAINER_RESOLVER.getPath(new String[]{container}), (String)policy);
        }
        return policy;
    }

    private static String getContainerPointer(CuratorFramework curator, String container) throws Exception {
        String pointer = "${zk:%s/%s}";
        String resolver = "${zk:%s/resolver}";
        return String.format(pointer, container, String.format(resolver, container));
    }

    void bindCurator(CuratorFramework curator) {
        this.curator.bind((Object)curator);
    }

    void unbindCurator(CuratorFramework curator) {
        this.curator.unbind((Object)curator);
    }

    void bindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.bind((Object)service);
    }

    void unbindRuntimeProperties(RuntimeProperties service) {
        this.runtimeProperties.unbind((Object)service);
    }

    void bindGeoLocationService(GeoLocationService service) {
        this.geoLocationService.bind((Object)service);
    }

    void ubindGeoLocationService(GeoLocationService service) {
        this.geoLocationService.unbind((Object)service);
    }

    protected void unbindGeoLocationService(GeoLocationService geoLocationService) {
        if (this.geoLocationService == geoLocationService) {
            this.geoLocationService = null;
        }
    }
}

