/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.runtime.container.wildfly;

import io.fabric8.runtime.container.spi.AbstractManagedContainer;
import io.fabric8.runtime.container.wildfly.WildFlyContainerConfiguration;
import java.io.File;
import java.util.ArrayList;
import org.jboss.gravia.runtime.RuntimeType;

public final class WildFlyManagedContainer
extends AbstractManagedContainer<WildFlyContainerConfiguration> {
    public RuntimeType getRuntimeType() {
        return RuntimeType.WILDFLY;
    }

    protected void doStart(WildFlyContainerConfiguration config) throws Exception {
        String javaArgs;
        File jbossHome = this.getContainerHome();
        if (!jbossHome.isDirectory()) {
            throw new IllegalStateException("Not a valid WildFly home dir: " + jbossHome);
        }
        String string = javaArgs = config.getJavaVmArguments() != null ? config.getJavaVmArguments() : "";
        if (!javaArgs.contains("-Xmx")) {
            javaArgs = "-Xmx1024m" + javaArgs;
        }
        File modulesPath = new File(jbossHome, "modules");
        File modulesJar = new File(jbossHome, "jboss-modules.jar");
        if (!modulesJar.exists()) {
            throw new IllegalStateException("Cannot find: " + modulesJar);
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("java");
        for (String opt : javaArgs.split("\\s+")) {
            cmd.add(opt);
        }
        cmd.add("-Djboss.home.dir=" + jbossHome);
        cmd.add("-jar");
        cmd.add(modulesJar.getAbsolutePath());
        cmd.add("-mp");
        cmd.add(modulesPath.getAbsolutePath());
        cmd.add("org.jboss.as.standalone");
        cmd.add("-server-config");
        cmd.add(config.getServerConfig());
        ProcessBuilder processBuilder = new ProcessBuilder(cmd);
        processBuilder.redirectErrorStream(true);
        this.startProcess(processBuilder, config);
    }
}

