/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.runtime.container.wildfly;

import io.fabric8.runtime.container.ContainerConfiguration;
import java.io.IOException;
import java.util.Properties;
import org.jboss.gravia.resource.MavenCoordinates;
import org.jboss.gravia.runtime.RuntimeType;

public final class WildFlyContainerConfiguration
extends ContainerConfiguration {
    public static final String DEFAULT_JAVAVM_ARGUMENTS = "-Xmx1024m";
    private String serverConfig = "standalone-fabric.xml";

    public RuntimeType getRuntimeType() {
        return RuntimeType.WILDFLY;
    }

    protected void validate() {
        if (this.getMavenCoordinates().isEmpty()) {
            Properties properties = new Properties();
            try {
                properties.load(((Object)((Object)this)).getClass().getResourceAsStream("version.properties"));
            }
            catch (IOException ex) {
                throw new IllegalStateException("Cannot load version.properties", ex);
            }
            String wildflyVersion = properties.getProperty("wildfly.version");
            String projectVersion = properties.getProperty("project.version");
            this.addMavenCoordinates(MavenCoordinates.create((String)"org.wildfly", (String)"wildfly-dist", (String)wildflyVersion, (String)"zip", null));
            this.addMavenCoordinates(MavenCoordinates.create((String)"io.fabric8.runtime", (String)"fabric-runtime-container-wildfly-patch", (String)projectVersion, (String)"zip", null));
        }
        super.validate();
    }

    public String getServerConfig() {
        return this.serverConfig;
    }
}

