/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.runtime.container.tomcat;

import io.fabric8.runtime.container.spi.AbstractManagedContainer;
import io.fabric8.runtime.container.tomcat.TomcatContainerConfiguration;
import java.io.File;
import java.util.ArrayList;
import org.jboss.gravia.runtime.RuntimeType;

public final class TomcatManagedContainer
extends AbstractManagedContainer<TomcatContainerConfiguration> {
    public RuntimeType getRuntimeType() {
        return RuntimeType.TOMCAT;
    }

    protected void doStart(TomcatContainerConfiguration config) throws Exception {
        String javaArgs;
        File catalinaHome = this.getContainerHome();
        if (!catalinaHome.isDirectory()) {
            throw new IllegalStateException("Not a valid Tomcat home dir: " + catalinaHome);
        }
        String string = javaArgs = config.getJavaVmArguments() != null ? config.getJavaVmArguments() : "";
        if (!javaArgs.contains("-Xmx")) {
            javaArgs = "-Xmx512m -XX:MaxPermSize=128m" + javaArgs;
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("java");
        for (String opt : javaArgs.split("\\s+")) {
            cmd.add(opt);
        }
        String absolutePath = catalinaHome.getAbsolutePath();
        String CLASS_PATH = absolutePath + "/bin/bootstrap.jar" + File.pathSeparator;
        CLASS_PATH = CLASS_PATH + absolutePath + "/bin/tomcat-juli.jar";
        cmd.add("-classpath");
        cmd.add(CLASS_PATH);
        cmd.add("-Djava.endorsed.dirs=" + absolutePath + "/endorsed");
        cmd.add("-Dcatalina.base=" + absolutePath);
        cmd.add("-Dcatalina.home=" + absolutePath);
        cmd.add("-Djava.io.tmpdir=" + absolutePath + "/temp");
        cmd.add("org.apache.catalina.startup.Bootstrap");
        cmd.add("start");
        ProcessBuilder processBuilder = new ProcessBuilder(cmd);
        processBuilder.redirectErrorStream(true);
        processBuilder.directory(new File(catalinaHome, "bin"));
        this.startProcess(processBuilder, config);
    }

    protected void doStop(TomcatContainerConfiguration config) throws Exception {
        this.destroyProcess();
    }
}

