/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.runtime.container.karaf;

import io.fabric8.runtime.container.karaf.KarafContainerConfiguration;
import io.fabric8.runtime.container.spi.AbstractManagedContainer;
import java.io.File;
import java.util.Map;
import org.jboss.gravia.runtime.RuntimeType;

public final class KarafManagedContainer
extends AbstractManagedContainer<KarafContainerConfiguration> {
    public RuntimeType getRuntimeType() {
        return RuntimeType.KARAF;
    }

    protected void doConfigure(KarafContainerConfiguration config) {
        File karaf = new File(this.getContainerHome(), "bin/karaf");
        if (!karaf.isFile()) {
            throw new IllegalStateException("Not a valid karaf executable: " + karaf);
        }
        if (!karaf.canExecute()) {
            karaf.setExecutable(true);
        }
    }

    protected void doStart(KarafContainerConfiguration config) throws Exception {
        String javaArgs;
        File containerHome = this.getContainerHome();
        if (!containerHome.isDirectory()) {
            throw new IllegalStateException("Not a valid Karaf home dir: " + containerHome);
        }
        String string = javaArgs = config.getJavaVmArguments() != null ? config.getJavaVmArguments() : "";
        if (!javaArgs.contains("-Xmx")) {
            javaArgs = "-Xmx512m " + javaArgs;
        }
        ProcessBuilder processBuilder = new ProcessBuilder("bin/karaf");
        Map<String, String> env = processBuilder.environment();
        env.put("JAVA_OPTS", javaArgs);
        processBuilder.directory(containerHome);
        processBuilder.redirectErrorStream(true);
        this.startProcess(processBuilder, config);
    }

    protected void doStop(KarafContainerConfiguration config) throws Exception {
        this.destroyProcess();
    }
}

