/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.runtime.container.spi;

import io.fabric8.runtime.container.ContainerConfiguration;
import io.fabric8.runtime.container.LifecycleException;
import io.fabric8.runtime.container.ManagedContainer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.jboss.gravia.resource.MavenCoordinates;
import org.jboss.shrinkwrap.api.GenericArchive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.exporter.ExplodedExporter;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;

public abstract class AbstractManagedContainer<T extends ContainerConfiguration>
implements ManagedContainer<T> {
    private T configuration;
    private File containerHome;
    private ManagedContainer.State state;
    private Process process;

    @Override
    public final synchronized void create(T configuration) throws LifecycleException {
        if (this.state != null) {
            throw new IllegalStateException("Cannot create container in state: " + (Object)((Object)this.state));
        }
        this.configuration = configuration;
        boolean useShrinkwrap = System.getProperty("shrinkwrap.resolver") != null;
        for (MavenCoordinates artefact : ((ContainerConfiguration)configuration).getMavenCoordinates()) {
            File zipfile = useShrinkwrap ? this.shrinkwrapResolve(artefact) : this.localResolve(artefact);
            GenericArchive archive = (GenericArchive)ShrinkWrap.createFromZipFile(GenericArchive.class, (File)zipfile);
            ExplodedExporter exporter = (ExplodedExporter)archive.as(ExplodedExporter.class);
            File targetdir = ((ContainerConfiguration)configuration).getTargetDirectory();
            if (!targetdir.isDirectory() && !targetdir.mkdirs()) {
                throw new IllegalStateException("Cannot create target dir: " + targetdir);
            }
            if (this.containerHome == null) {
                exporter.exportExploded(targetdir, "");
                File[] childDirs = targetdir.listFiles();
                if (childDirs.length != 1) {
                    throw new IllegalStateException("Expected one child directory, but was: " + Arrays.asList(childDirs));
                }
                this.containerHome = childDirs[0];
                continue;
            }
            exporter.exportExploded(this.containerHome, "");
        }
        this.state = ManagedContainer.State.CREATED;
        try {
            this.doConfigure(configuration);
        }
        catch (Exception ex) {
            throw new LifecycleException("Cannot configure container", ex);
        }
    }

    private File localResolve(MavenCoordinates artefact) {
        File userHome = new File(System.getProperty("user.home"));
        File repodir = new File(userHome, ".m2/repository");
        File artefactPath = new File(repodir, artefact.getArtifactPath());
        if (!artefactPath.isFile()) {
            throw new IllegalStateException("Cannot obtain maven artefact: " + artefact);
        }
        return artefactPath;
    }

    private File shrinkwrapResolve(MavenCoordinates artefact) {
        File[] resolved = ((MavenFormatStage)((MavenStrategyStage)Maven.resolver().resolve(artefact.toString())).withoutTransitivity()).asFile();
        if (resolved == null || resolved.length == 0) {
            throw new IllegalStateException("Cannot obtain maven artefact: " + artefact);
        }
        if (resolved.length > 1) {
            throw new IllegalStateException("Multiple maven artefacts for: " + artefact);
        }
        return resolved[0];
    }

    @Override
    public File getContainerHome() {
        return this.containerHome;
    }

    @Override
    public ManagedContainer.State getState() {
        return this.state;
    }

    @Override
    public final synchronized void start() throws LifecycleException {
        this.assertNotDestroyed();
        try {
            if (this.state == ManagedContainer.State.CREATED || this.state == ManagedContainer.State.STOPPED) {
                this.doStart(this.configuration);
                this.state = ManagedContainer.State.STARTED;
            }
        }
        catch (Exception ex) {
            throw new LifecycleException("Cannot start container", ex);
        }
    }

    @Override
    public final synchronized void stop() throws LifecycleException {
        this.assertNotDestroyed();
        try {
            if (this.state == ManagedContainer.State.STARTED) {
                this.doStop(this.configuration);
                this.state = ManagedContainer.State.STOPPED;
            }
        }
        catch (Exception ex) {
            throw new LifecycleException("Cannot stop container", ex);
        }
    }

    @Override
    public final synchronized void destroy() throws LifecycleException {
        this.assertNotDestroyed();
        if (this.state == ManagedContainer.State.STARTED) {
            try {
                this.stop();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        try {
            this.doDestroy(this.configuration);
        }
        catch (Exception ex) {
            throw new LifecycleException("Cannot destroy container", ex);
        }
        finally {
            this.state = ManagedContainer.State.DESTROYED;
        }
    }

    private void assertNotDestroyed() {
        if (this.state == ManagedContainer.State.DESTROYED) {
            throw new IllegalStateException("Cannot start container in state: " + (Object)((Object)this.state));
        }
    }

    protected void doConfigure(T configuration) throws Exception {
    }

    protected void doStart(T configuration) throws Exception {
    }

    protected void doStop(T configuration) throws Exception {
    }

    protected void doDestroy(T configuration) throws Exception {
        this.destroyProcess();
    }

    protected void startProcess(ProcessBuilder processBuilder, ContainerConfiguration config) throws IOException {
        this.process = processBuilder.start();
        new Thread(new ConsoleConsumer(this.process, config)).start();
    }

    protected void destroyProcess() throws Exception {
        if (this.process != null) {
            this.process.destroy();
            this.process.waitFor();
        }
    }

    public static class ConsoleConsumer
    implements Runnable {
        private final Process process;
        private final ContainerConfiguration config;

        public ConsoleConsumer(Process process, ContainerConfiguration config) {
            this.process = process;
            this.config = config;
        }

        @Override
        public void run() {
            InputStream stream = this.process.getInputStream();
            try {
                int num;
                byte[] buf = new byte[32];
                while ((num = stream.read(buf)) != -1) {
                    if (!this.config.isOutputToConsole()) continue;
                    System.out.write(buf, 0, num);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

