/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.download;

import io.fabric8.agent.download.DownloadManager;
import io.fabric8.agent.mvn.DictionaryPropertyResolver;
import io.fabric8.agent.mvn.MavenConfiguration;
import io.fabric8.agent.mvn.MavenConfigurationImpl;
import io.fabric8.agent.mvn.MavenSettingsImpl;
import io.fabric8.agent.mvn.PropertiesPropertyResolver;
import io.fabric8.agent.utils.AgentUtils;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.Profiles;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class DownloadManagers {
    public static MavenConfiguration createMavenConfiguration(FabricService fabricService, Properties properties) {
        AgentUtils.addMavenProxies(properties, fabricService);
        PropertiesPropertyResolver propertiesPropertyResolver = new PropertiesPropertyResolver(System.getProperties());
        DictionaryPropertyResolver dictionaryPropertyResolver = new DictionaryPropertyResolver(properties, propertiesPropertyResolver);
        MavenConfigurationImpl config = new MavenConfigurationImpl(dictionaryPropertyResolver, "org.ops4j.pax.url.mvn");
        config.setSettings(new MavenSettingsImpl(config.getSettingsFileUrl(), config.useFallbackRepositories()));
        return config;
    }

    public static DownloadManager createDownloadManager(FabricService fabricService, ExecutorService executorService) throws MalformedURLException {
        Profile overlayProfile = fabricService.getCurrentContainer().getOverlayProfile();
        Profile effectiveProfile = Profiles.getEffectiveProfile((FabricService)fabricService, (Profile)overlayProfile);
        return DownloadManagers.createDownloadManager(fabricService, effectiveProfile, executorService);
    }

    public static DownloadManager createDownloadManager(FabricService fabricService, Profile profile, ExecutorService downloadExecutor) throws MalformedURLException {
        HashMap configuration = profile.getConfiguration("io.fabric8.agent");
        if (configuration == null) {
            configuration = new HashMap();
        }
        MavenConfiguration mavenConfiguration = DownloadManagers.createMavenConfiguration(fabricService, DownloadManagers.mapToProperties(configuration));
        return new DownloadManager(mavenConfiguration, downloadExecutor);
    }

    private static Properties mapToProperties(Map<String, String> map) {
        Properties p = new Properties();
        Set<Map.Entry<String, String>> set = map.entrySet();
        for (Map.Entry<String, String> entry : set) {
            p.put(entry.getKey(), entry.getValue());
        }
        return p;
    }
}

