/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CountingMap {
    private Map<String, Integer> keyToCount = new HashMap<String, Integer>();

    public String toString() {
        return "CountingMap{" + this.keyToCount + '}';
    }

    public void incrementAll(List<String> keys) {
        for (String key : keys) {
            this.increment(key);
        }
    }

    public int increment(String key) {
        int count = this.count(key) + 1;
        this.setCount(key, count);
        return count;
    }

    public void decrementAll(List<String> keys) {
        for (String key : keys) {
            this.decrement(key);
        }
    }

    public int decrement(String key) {
        int count = this.count(key) - 1;
        if (count <= 0) {
            this.keyToCount.remove(key);
            return 0;
        }
        this.setCount(key, count);
        return count;
    }

    public int count(String key) {
        Integer answer = this.keyToCount.get(key);
        return answer == null ? 0 : answer;
    }

    public Set<String> keySet() {
        return this.keyToCount.keySet();
    }

    public int total() {
        int answer = 0;
        for (Integer value : this.keyToCount.values()) {
            if (value == null) continue;
            answer += value.intValue();
        }
        return answer;
    }

    public void setCount(String key, int value) {
        this.keyToCount.put(key, value);
    }
}

