/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.download;

import io.fabric8.agent.download.AbstractDownloadTask;
import io.fabric8.agent.download.DownloadFuture;
import io.fabric8.agent.download.DownloadManagerHelper;
import io.fabric8.agent.download.FutureListener;
import io.fabric8.agent.download.MavenDownloadTask;
import io.fabric8.agent.download.SimpleDownloadTask;
import io.fabric8.agent.mvn.MavenConfiguration;
import io.fabric8.agent.mvn.MavenRepositoryURL;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.concurrent.ExecutorService;

public class DownloadManager {
    private ExecutorService executor;
    private final MavenConfiguration configuration;
    private final MavenRepositoryURL cache;
    private final MavenRepositoryURL system;
    private boolean downloadFilesFromProfile = true;
    private File tmpPath;

    public DownloadManager(MavenConfiguration configuration) throws MalformedURLException {
        this(configuration, null);
    }

    public DownloadManager(MavenConfiguration configuration, ExecutorService executor) throws MalformedURLException {
        this.configuration = configuration;
        this.executor = executor;
        String karafRoot = System.getProperty("karaf.home", "karaf");
        String karafData = System.getProperty("karaf.data", karafRoot + "/data");
        this.cache = new MavenRepositoryURL("file:" + karafData + File.separator + "maven" + File.separator + "agent" + "@snapshots");
        this.system = new MavenRepositoryURL("file:" + karafRoot + File.separator + "system" + "@snapshots");
        this.tmpPath = new File(karafData, "tmp");
    }

    public boolean isDownloadFilesFromProfile() {
        return this.downloadFilesFromProfile;
    }

    public void setDownloadFilesFromProfile(boolean downloadFilesFromProfile) {
        this.downloadFilesFromProfile = downloadFilesFromProfile;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public void shutdown() {
    }

    public DownloadFuture download(final String url) throws MalformedURLException {
        String mvnUrl = DownloadManagerHelper.stripUrl(url);
        if (mvnUrl.startsWith("mvn:")) {
            MavenRepositoryURL inlined = null;
            MavenDownloadTask task = new MavenDownloadTask(mvnUrl, this.cache, this.system, inlined, this.configuration, this.executor);
            this.executor.submit(task);
            if (!mvnUrl.equals(url)) {
                final DummyDownloadTask download = new DummyDownloadTask(url, this.executor);
                task.addListener(new FutureListener<DownloadFuture>(){

                    @Override
                    public void operationComplete(DownloadFuture future) {
                        try {
                            String mvn = future.getUrl();
                            String file = future.getFile().toURI().toURL().toString();
                            String real = url.replace(mvn, file);
                            SimpleDownloadTask task = new SimpleDownloadTask(real, DownloadManager.this.executor, DownloadManager.this.tmpPath);
                            DownloadManager.this.executor.submit(task);
                            task.addListener(new FutureListener<DownloadFuture>(){

                                @Override
                                public void operationComplete(DownloadFuture future) {
                                    try {
                                        download.setFile(future.getFile());
                                    }
                                    catch (IOException e) {
                                        download.setException(e);
                                    }
                                }
                            });
                        }
                        catch (IOException e) {
                            download.setException(e);
                        }
                    }
                });
                return download;
            }
            return task;
        }
        if (mvnUrl.startsWith("profile:") && !this.isDownloadFilesFromProfile()) {
            NoDownloadTask task = new NoDownloadTask(url, this.executor);
            this.executor.submit(task);
            return task;
        }
        SimpleDownloadTask download = new SimpleDownloadTask(url, this.executor, this.tmpPath);
        this.executor.submit(download);
        return download;
    }

    static class NoDownloadTask
    extends AbstractDownloadTask {
        NoDownloadTask(String url, ExecutorService executor) {
            super(url, executor);
        }

        @Override
        public File getFile() throws IOException {
            return null;
        }

        @Override
        public void setFile(File file) {
            this.setValue(null);
        }

        @Override
        protected File download() throws Exception {
            return this.getFile();
        }
    }

    static class DummyDownloadTask
    extends AbstractDownloadTask {
        DummyDownloadTask(String url, ExecutorService executor) {
            super(url, executor);
        }

        @Override
        protected File download() throws Exception {
            return this.getFile();
        }
    }
}

