/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.utils.features;

import java.util.Collection;
import org.apache.felix.utils.version.VersionCleaner;
import org.apache.felix.utils.version.VersionRange;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.Repository;
import org.osgi.framework.Version;

public class FeatureUtils {
    private static final String DEFAULT_VERSION = "0.0.0";

    private FeatureUtils() {
    }

    public static Feature search(String key, Collection<Repository> repositories) {
        String[] split = key.split("/");
        String name = split[0].trim();
        String version = null;
        if (split.length == 2) {
            version = split[1].trim();
        }
        if (version == null || version.length() == 0) {
            version = DEFAULT_VERSION;
        }
        return FeatureUtils.search(name, version, repositories);
    }

    public static Feature search(String name, String version, Collection<Repository> repositories) {
        VersionRange range = new VersionRange(version, false, true);
        Feature bestFeature = null;
        Version bestVersion = null;
        for (Repository repo : repositories) {
            Feature[] features;
            try {
                features = repo.getFeatures();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            for (Feature feature : features) {
                Version v;
                if (!name.equals(feature.getName()) || !range.contains(v = new Version(VersionCleaner.clean(feature.getVersion()))) || bestVersion != null && bestVersion.compareTo(v) >= 0) continue;
                bestFeature = feature;
                bestVersion = v;
            }
        }
        return bestFeature;
    }
}

