/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.runtime.agent;

import io.fabric8.agent.download.DownloadManager;
import io.fabric8.agent.download.DownloadManagers;
import io.fabric8.agent.utils.AgentUtils;
import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.api.scr.AbstractComponent;
import io.fabric8.api.scr.ValidatingReference;
import io.fabric8.runtime.agent.FabricAgentMXBean;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.ConfigurationPolicy;
import org.apache.felix.scr.annotations.Deactivate;
import org.apache.felix.scr.annotations.Reference;
import org.apache.karaf.features.Feature;
import org.jboss.gravia.provision.Provisioner;
import org.jboss.gravia.provision.ResourceHandle;
import org.jboss.gravia.provision.ResourceInstaller;
import org.jboss.gravia.repository.MavenCoordinates;
import org.jboss.gravia.repository.MavenResourceBuilder;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceIdentity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(name="io.fabric8.runtime.agent.FabricAgent", label="Fabric8 Runtime Agent", immediate=true, policy=ConfigurationPolicy.IGNORE, metatype=false)
public class FabricAgent
extends AbstractComponent
implements FabricAgentMXBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(FabricAgent.class);
    @Reference(referenceInterface=MBeanServer.class)
    private final ValidatingReference<MBeanServer> mbeanServer = new ValidatingReference();
    @Reference(referenceInterface=Provisioner.class)
    private final ValidatingReference<Provisioner> provisioner = new ValidatingReference();
    @Reference(referenceInterface=FabricService.class)
    private final ValidatingReference<FabricService> fabricService = new ValidatingReference();
    private final Runnable onConfigurationChange = new Runnable(){

        @Override
        public void run() {
            FabricAgent.this.submitUpdateJob();
        }
    };
    private final ExecutorService executor = Executors.newSingleThreadExecutor(new NamedThreadFactory("fabric8-agent"));
    private final ExecutorService downloadExecutor = Executors.newSingleThreadExecutor(new NamedThreadFactory("fabric8-agent-downloader"));
    private ObjectName objectName;
    private Map<ResourceIdentity, ResourceHandle> resourcehandleMap = new ConcurrentHashMap<ResourceIdentity, ResourceHandle>();

    @Activate
    void activate() {
        LOGGER.info("Activating");
        ((FabricService)this.fabricService.get()).trackConfiguration(this.onConfigurationChange);
        this.activateComponent();
        this.submitUpdateJob();
        try {
            MBeanServer anMBeanServer = (MBeanServer)this.mbeanServer.get();
            if (anMBeanServer != null) {
                if (this.objectName == null) {
                    this.objectName = new ObjectName("io.fabric8:type=RuntimeAgent");
                }
                anMBeanServer.registerMBean(this, this.objectName);
            } else {
                LOGGER.warn("No MBeanServer");
            }
        }
        catch (Exception e) {
            LOGGER.warn("Failed to register MBean " + this.objectName + ": " + e, (Throwable)e);
        }
    }

    @Deactivate
    void deactivate() {
        if (this.objectName != null) {
            try {
                MBeanServer anMBeanServer = (MBeanServer)this.mbeanServer.get();
                if (anMBeanServer != null) {
                    anMBeanServer.unregisterMBean(this.objectName);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Failed to unregister MBean " + this.objectName + ": " + e, (Throwable)e);
            }
        }
        this.deactivateComponent();
        ((FabricService)this.fabricService.get()).untrackConfiguration(this.onConfigurationChange);
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.executor.shutdownNow();
    }

    private void submitUpdateJob() {
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                if (FabricAgent.this.isValid()) {
                    try {
                        FabricAgent.this.updateInternal();
                    }
                    catch (Exception e) {
                        LOGGER.warn("Caught:" + e, (Throwable)e);
                    }
                }
            }
        });
    }

    protected synchronized void updateInternal() {
        Profile profile = null;
        FabricService fabric = null;
        Provisioner provisionService = null;
        try {
            fabric = (FabricService)this.fabricService.get();
            Container container = fabric.getCurrentContainer();
            profile = container.getOverlayProfile();
            provisionService = (Provisioner)this.provisioner.get();
        }
        catch (Exception ex) {
            LOGGER.debug("Failed to read container profile. This exception will be ignored..", (Throwable)ex);
            return;
        }
        if (profile != null && fabric != null && provisionService != null) {
            List<String> resources = null;
            try {
                resources = this.updateProvisioning(fabric, profile, provisionService);
                this.updateStatus("success", null, resources);
            }
            catch (Throwable e) {
                if (this.isValid()) {
                    LOGGER.warn("Exception updating provisioning: " + e, e);
                    this.updateStatus("error", e, resources);
                }
                LOGGER.debug("Exception updating provisioning: " + e, e);
            }
        }
    }

    protected void updateStatus(String status, Throwable result, List<String> resources) {
        try {
            FabricService fs = (FabricService)this.fabricService.get();
            if (fs != null) {
                String e;
                Container container = fs.getCurrentContainer();
                if (result == null) {
                    e = null;
                } else {
                    StringWriter sw = new StringWriter();
                    result.printStackTrace(new PrintWriter(sw));
                    e = sw.toString();
                }
                if (resources != null) {
                    container.setProvisionList(resources);
                }
                container.setProvisionResult(status);
                container.setProvisionException(e);
            } else {
                LOGGER.info("FabricService not available");
            }
        }
        catch (Throwable e) {
            LOGGER.warn("Unable to set provisioning result");
        }
    }

    protected List<String> updateProvisioning(FabricService fabric, Profile profile, Provisioner provisionService) throws Exception {
        this.updateStatus("installing", null, null);
        LinkedHashSet<String> bundles = new LinkedHashSet<String>();
        LinkedHashSet<Feature> features = new LinkedHashSet<Feature>();
        bundles.addAll(profile.getBundles());
        DownloadManager downloadManager = DownloadManagers.createDownloadManager(fabric, profile, this.downloadExecutor);
        AgentUtils.addFeatures(features, downloadManager, profile);
        ResourceInstaller resourceInstaller = provisionService.getResourceInstaller();
        Map<ResourceIdentity, Resource> installedResources = this.getInstalledResources(provisionService);
        HashMap requirements = new HashMap();
        Map<String, File> files = AgentUtils.downloadBundles(downloadManager, features, bundles, Collections.<String>emptySet());
        Set<Map.Entry<String, File>> entries = files.entrySet();
        ArrayList<Resource> resourcesToInstall = new ArrayList<Resource>();
        ArrayList<String> resourceUrisInstalled = new ArrayList<String>();
        for (Map.Entry<String, File> entry : entries) {
            String name = entry.getKey();
            File file = entry.getValue();
            String coords = name;
            int idx = coords.lastIndexOf(58);
            if (idx > 0) {
                coords = name.substring(idx + 1);
            }
            coords = coords.replace('/', ':');
            MavenCoordinates mvnCoords = MavenCoordinates.parse((String)coords);
            URL url = file.toURI().toURL();
            if (url == null) {
                LOGGER.warn("Could not find URL for file " + file);
                continue;
            }
            boolean isWar = name.startsWith("war:") || name.contains("/war/") || file.getName().toLowerCase().endsWith(".war");
            boolean isShared = !isWar;
            Resource resource = this.findMavenResource(mvnCoords, url, isShared);
            if (resource == null) {
                LOGGER.warn("Could not find resource for " + mvnCoords + " and " + url);
                continue;
            }
            ResourceIdentity identity = resource.getIdentity();
            Resource oldResource = installedResources.remove(identity);
            if (oldResource != null || this.resourcehandleMap.containsKey(identity)) continue;
            if (isShared) {
                LOGGER.warn("TODO not installing " + (isShared ? "shared" : "non-shared") + " resource: " + identity);
                continue;
            }
            LOGGER.info("Installing " + (isShared ? "shared" : "non-shared") + " resource: " + identity);
            resourcesToInstall.add(resource);
            resourceUrisInstalled.add(name);
        }
        for (Resource installedResource : installedResources.values()) {
            ResourceIdentity identity = installedResource.getIdentity();
            ResourceHandle resourceHandle = this.resourcehandleMap.get(identity);
            if (resourceHandle == null) {
                LOGGER.warn("TODO: Cannot uninstall " + installedResource + " as we have no handle!");
                continue;
            }
            LOGGER.info("Uninstalling " + installedResource);
            resourceHandle.uninstall();
            this.resourcehandleMap.remove(identity);
            LOGGER.info("Uninstalled " + installedResource);
        }
        if (resourcesToInstall.size() > 0) {
            LOGGER.info("Installing " + resourcesToInstall.size() + " resource(s)");
            Set resourceHandles = resourceInstaller.installResources(resourcesToInstall, requirements);
            LOGGER.info("Got " + resourceHandles.size() + " resource handle(s)");
            for (ResourceHandle resourceHandle : resourceHandles) {
                this.resourcehandleMap.put(resourceHandle.getResource().getIdentity(), resourceHandle);
            }
        }
        return resourceUrisInstalled;
    }

    protected Map<ResourceIdentity, Resource> getInstalledResources(Provisioner provisionService) {
        HashMap<ResourceIdentity, Resource> installedResources = new HashMap<ResourceIdentity, Resource>();
        for (Map.Entry<ResourceIdentity, ResourceHandle> entry : this.resourcehandleMap.entrySet()) {
            installedResources.put(entry.getKey(), entry.getValue().getResource());
        }
        try {
            Iterator resources = provisionService.getEnvironment().getResources();
            while (resources.hasNext()) {
                Resource resource = (Resource)resources.next();
                installedResources.put(resource.getIdentity(), resource);
            }
        }
        catch (Throwable e) {
            LOGGER.warn("Ignoring error finding current resources: " + e, e);
        }
        return installedResources;
    }

    public Resource findMavenResource(MavenCoordinates mavenid, URL contentURL, boolean isShared) {
        LOGGER.debug("Find maven providers for: {}", (Object)mavenid);
        Resource result = null;
        if (contentURL != null) {
            MavenResourceBuilder builder = new MavenResourceBuilder();
            Capability identCap = builder.addIdentityCapability(mavenid);
            Capability ccap = builder.addCapability("gravia.content", null, null);
            ccap.getAttributes().put("url", contentURL);
            if (isShared) {
                identCap.getAttributes().put("shared", "true");
            } else {
                identCap.getAttributes().put("contextPath", mavenid.getArtifactId());
            }
            result = builder.getResource();
            LOGGER.debug("Found maven resource: {}", (Object)result);
        }
        return result;
    }

    void bindMbeanServer(MBeanServer service) {
        this.mbeanServer.bind((Object)service);
    }

    void unbindMbeanServer(MBeanServer service) {
        this.mbeanServer.unbind((Object)service);
    }

    void bindProvisioner(Provisioner service) {
        this.provisioner.bind((Object)service);
    }

    void unbindProvisioner(Provisioner service) {
        this.provisioner.unbind((Object)service);
    }

    void bindFabricService(FabricService fabricService) {
        this.fabricService.bind((Object)fabricService);
    }

    void unbindFabricService(FabricService fabricService) {
        this.fabricService.unbind((Object)fabricService);
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        NamedThreadFactory(String prefix) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = prefix + "-" + poolNumber.getAndIncrement() + "-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

