/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.spring.boot.starter.camel;

import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.TypeConverter;
import org.apache.camel.spring.SpringCamelContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CamelAutoConfiguration {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired(required=false)
    private RoutesBuilder[] routesBuilders;

    @Bean
    CamelContext camelContext() throws Exception {
        SpringCamelContext camelContext = new SpringCamelContext(this.applicationContext);
        if (this.routesBuilders != null) {
            for (RoutesBuilder routesBuilder : this.routesBuilders) {
                camelContext.addRoutes(routesBuilder);
            }
        }
        return camelContext;
    }

    @Bean
    ProducerTemplate producerTemplate() throws Exception {
        return this.camelContext().createProducerTemplate();
    }

    @Bean
    ConsumerTemplate consumerTemplate() throws Exception {
        return this.camelContext().createConsumerTemplate();
    }

    @Bean
    TypeConverter typeConverter() throws Exception {
        return this.camelContext().getTypeConverter();
    }
}

