/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.spring.boot.registry;

import com.google.common.collect.Lists;
import io.fabric8.process.spring.boot.registry.ClassPathProcessRegistry;
import io.fabric8.process.spring.boot.registry.CompositeProcessRegistry;
import io.fabric8.process.spring.boot.registry.InMemoryProcessRegistry;
import io.fabric8.process.spring.boot.registry.ProcessRegistry;
import io.fabric8.process.spring.boot.registry.ProcessRegistryHolder;
import io.fabric8.process.spring.boot.registry.ProcessRegistryPropertySource;
import io.fabric8.process.spring.boot.registry.ZooKeeperProcessRegistry;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ClassUtils;

public class ProcessRegistryPropertySourceApplicationContextInitializer
implements ApplicationContextInitializer,
Ordered {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessRegistryPropertySourceApplicationContextInitializer.class);

    public void initialize(ConfigurableApplicationContext applicationContext) {
        ArrayList registries = Lists.newArrayList((Object[])new ProcessRegistry[]{new InMemoryProcessRegistry(), new ClassPathProcessRegistry()});
        LOG.debug("Looking for ZooKeeperProcessRegistry...");
        if (ClassUtils.isPresent((String)"org.apache.curator.framework.CuratorFramework", (ClassLoader)this.getClass().getClassLoader())) {
            LOG.info("Apache Curator jar found. Creating ZooKeeperProcessRegistry.");
            registries.add(ZooKeeperProcessRegistry.autodetectZooKeeperProcessRegistry());
        }
        CompositeProcessRegistry registry = new CompositeProcessRegistry(registries);
        ProcessRegistryHolder.processRegistry(registry);
        ProcessRegistryPropertySource propertySource = new ProcessRegistryPropertySource(registry);
        applicationContext.getEnvironment().getPropertySources().addFirst((PropertySource)propertySource);
    }

    public int getOrder() {
        return -2147482648;
    }
}

