/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.spring.boot.registry;

import com.google.common.collect.Lists;
import io.fabric8.process.spring.boot.registry.ClassPathProcessRegistry;
import io.fabric8.process.spring.boot.registry.CompositeProcessRegistry;
import io.fabric8.process.spring.boot.registry.InMemoryProcessRegistry;
import io.fabric8.process.spring.boot.registry.ProcessRegistry;
import io.fabric8.process.spring.boot.registry.ProcessRegistryPropertySource;
import io.fabric8.process.spring.boot.registry.ZooKeeperProcessRegistry;
import java.util.ArrayList;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.PropertySource;
import org.springframework.util.ClassUtils;

public class ProcessRegistryPropertySourceApplicationContextInitializer
implements ApplicationContextInitializer {
    private static ProcessRegistry processRegistry;

    public void initialize(ConfigurableApplicationContext applicationContext) {
        ArrayList registries = Lists.newArrayList((Object[])new ProcessRegistry[]{new ClassPathProcessRegistry(), new InMemoryProcessRegistry()});
        if (ClassUtils.isPresent((String)"org.apache.curator.framework.CuratorFramework", (ClassLoader)this.getClass().getClassLoader())) {
            registries.add(ZooKeeperProcessRegistry.autodetectZooKeeperProcessRegistry());
        }
        processRegistry = new CompositeProcessRegistry(registries);
        ProcessRegistryPropertySource propertySource = new ProcessRegistryPropertySource(processRegistry);
        applicationContext.getEnvironment().getPropertySources().addFirst((PropertySource)propertySource);
    }

    public static ProcessRegistry processRegistry() {
        return processRegistry;
    }
}

