/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.spring.boot.registry;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryOneTime;
import org.apache.zookeeper.server.NIOServerCnxnFactory;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZooKeeperServer;
import org.apache.zookeeper.server.persistence.FileTxnSnapLog;

public class ZooKeeperProcessRegistries {
    private static final int DEFAULT_ZK_BASE_SLEEP = 1000;
    private static final int DEFAULT_ZK_MAX_RETRIES = 3;

    public static RetryPolicy defaultRetryPolicy() {
        return new RetryOneTime(1);
    }

    public static CuratorFramework newCurator(String hosts) {
        CuratorFramework curator = CuratorFrameworkFactory.builder().connectString(hosts).connectionTimeoutMs(50).retryPolicy(ZooKeeperProcessRegistries.defaultRetryPolicy()).build();
        curator.start();
        return curator;
    }

    public static NIOServerCnxnFactory zooKeeperServer(int port) {
        try {
            ServerConfig cfg = new ServerConfig();
            String zkData = "target/zk/data/" + UUID.randomUUID();
            cfg.parse(new String[]{Integer.toString(port), zkData});
            ZooKeeperServer zkServer = new ZooKeeperServer();
            FileTxnSnapLog ftxn = new FileTxnSnapLog(new File(cfg.getDataLogDir()), new File(cfg.getDataDir()));
            zkServer.setTxnLogFactory(ftxn);
            zkServer.setTickTime(cfg.getTickTime());
            zkServer.setMinSessionTimeout(cfg.getMinSessionTimeout());
            zkServer.setMaxSessionTimeout(cfg.getMaxSessionTimeout());
            NIOServerCnxnFactory cnxnFactory = new NIOServerCnxnFactory();
            cnxnFactory.configure(cfg.getClientPortAddress(), cfg.getMaxClientCnxns());
            cnxnFactory.startup(zkServer);
            return cnxnFactory;
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

