/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.manager.commands;

import io.fabric8.process.manager.Installation;
import io.fabric8.process.manager.ProcessManager;
import io.fabric8.process.manager.commands.support.ProcessControlCommandSupport;
import java.io.PrintStream;
import org.apache.felix.gogo.commands.Command;

@Command(name="environment", scope="process", description="Environment variables of a managed process")
public class EnvironmentAction
extends ProcessControlCommandSupport {
    static final String[] HEADERS = new String[]{"[Variable]", "[Value]"};
    static final String FORMAT = "%-45s %s";

    protected EnvironmentAction(ProcessManager processManager) {
        super(processManager);
    }

    @Override
    protected void doControlCommand(Installation installation) throws Exception {
        this.printEnvironment(installation, System.out);
    }

    protected void printEnvironment(Installation installation, PrintStream out) {
        out.println(String.format(FORMAT, HEADERS));
        for (String variable : installation.getEnvironment().keySet()) {
            String value = installation.getEnvironment().get(variable);
            out.println(String.format(FORMAT, variable, value));
        }
    }
}

