/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.manager.support;

import io.fabric8.common.util.Files;
import io.fabric8.common.util.Strings;
import io.fabric8.process.manager.InstallTask;
import io.fabric8.process.manager.config.ProcessConfig;
import io.fabric8.process.manager.support.ProcessUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadResourcesTask
implements InstallTask {
    private static final transient Logger LOG = LoggerFactory.getLogger(DownloadResourcesTask.class);
    private final Map<String, String> localPathToURLMap;

    public DownloadResourcesTask(Map<String, String> localPathToURLMap) {
        this.localPathToURLMap = localPathToURLMap;
    }

    @Override
    public void install(ProcessConfig config, String id, File installDir) throws Exception {
        File baseDir = ProcessUtils.findInstallDir(installDir);
        Set<Map.Entry<String, String>> entries = this.localPathToURLMap.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String localPath = entry.getKey();
            String urlText = entry.getValue();
            if (!Strings.isNotBlank((String)urlText)) continue;
            URL url = null;
            try {
                url = new URL(urlText);
            }
            catch (MalformedURLException e) {
                LOG.warn("Ignoring invalid URL '" + urlText + "' for overlay resource " + localPath + ". " + e, (Throwable)e);
            }
            if (url == null) continue;
            File newFile = new File(baseDir, localPath);
            newFile.getParentFile().mkdirs();
            InputStream stream = url.openStream();
            if (stream == null) continue;
            Files.copy((InputStream)stream, (OutputStream)new BufferedOutputStream(new FileOutputStream(newFile)));
        }
    }
}

