/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.manager.support;

import io.fabric8.common.util.Closeables;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessUtils {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(ProcessUtils.class);

    public static File findInstallDir(File rootDir) {
        if (ProcessUtils.installExists(rootDir)) {
            return rootDir;
        }
        File[] files = rootDir.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!ProcessUtils.installExists(file)) continue;
                return file;
            }
        }
        return rootDir;
    }

    public static boolean installExists(File file) {
        if (file.isDirectory()) {
            File binDir = new File(file, "bin");
            return binDir.exists() && binDir.isDirectory();
        }
        return false;
    }

    public static boolean isProcessAlive(long pid) {
        List<Long> processIds = ProcessUtils.getProcessIds();
        if (processIds.isEmpty()) {
            return true;
        }
        return processIds.contains(pid);
    }

    public static List<Long> getProcessIds() {
        String commands = "ps -e";
        Process process = null;
        Runtime runtime = Runtime.getRuntime();
        String message = commands;
        LOGGER.debug("Executing commands: " + message);
        ArrayList<Long> answer = new ArrayList<Long>();
        try {
            process = runtime.exec(commands);
            ProcessUtils.parseProcesses(process.getInputStream(), answer, message);
            ProcessUtils.processErrors(process.getErrorStream(), message);
        }
        catch (Exception e) {
            LOGGER.error("Failed to execute process stdin for " + message + ": " + e, (Throwable)e);
        }
        return answer;
    }

    protected static void parseProcesses(InputStream inputStream, List<Long> answer, String message) throws Exception {
        block10: {
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            block7: while (true) {
                try {
                    while (true) {
                        String line;
                        if ((line = reader.readLine()) == null) {
                            break block10;
                        }
                        StringTokenizer tokenizer = new StringTokenizer(line);
                        if (!tokenizer.hasMoreTokens()) continue;
                        String pidText = tokenizer.nextToken();
                        try {
                            long pid = Long.parseLong(pidText);
                            answer.add(pid);
                            continue block7;
                        }
                        catch (NumberFormatException e) {
                            LOGGER.debug("Could not parse pid " + pidText + " from command: " + message);
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    LOGGER.debug("Failed to process stdin for " + message + ": " + e, (Throwable)e);
                    throw e;
                }
            }
            finally {
                Closeables.closeQuitely((Closeable)reader);
            }
        }
    }

    protected static void processErrors(InputStream inputStream, String message) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                LOGGER.debug("Error from " + message + ": " + line);
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to process stderr for " + message + ": " + e, (Throwable)e);
            throw e;
        }
        finally {
            Closeables.closeQuitely((Closeable)reader);
        }
    }
}

