/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.process.manager;

import com.google.common.base.Objects;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class InstallOptions
implements Serializable {
    private static final long serialVersionUID = 4943127368399800099L;
    public static final String DEFAULT_EXTRACT_CMD = "tar zxf";
    private final String name;
    private final URL url;
    private final URL controllerUrl;
    private final String extractCmd;
    private final boolean offline;
    private final String[] optionalDependencyPatterns;
    private final String[] excludeDependencyFilterPatterns;
    private final String mainClass;
    private final Map<String, Object> properties;

    public static InstallOptionsBuilder builder() {
        return new InstallOptionsBuilder();
    }

    public InstallOptions(String name, URL url, URL controllerUrl, String extractCmd, boolean offline, String[] optionalDependencyPatterns, String[] excludeDependencyFilterPatterns, String mainClass, Map<String, Object> properties) {
        this.name = name;
        this.url = url;
        this.controllerUrl = controllerUrl;
        this.extractCmd = extractCmd;
        this.offline = offline;
        this.optionalDependencyPatterns = optionalDependencyPatterns;
        this.excludeDependencyFilterPatterns = excludeDependencyFilterPatterns;
        this.mainClass = mainClass;
        this.properties = properties;
    }

    public String getName() {
        return this.name;
    }

    public URL getUrl() {
        return this.url;
    }

    public URL getControllerUrl() {
        return this.controllerUrl;
    }

    public String getExtractCmd() {
        return this.extractCmd;
    }

    public boolean isOffline() {
        return this.offline;
    }

    public String[] getExcludeDependencyFilterPatterns() {
        return this.excludeDependencyFilterPatterns;
    }

    public String[] getOptionalDependencyPatterns() {
        return this.optionalDependencyPatterns;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public static class InstallOptionsBuilder<T extends InstallOptionsBuilder> {
        private String name;
        private URL url;
        private URL controllerUrl;
        private String extractCmd = "tar zxf";
        private String groupId;
        private String artifactId;
        private String version = "LATEST";
        private String extension = "jar";
        private String classifier;
        private boolean offline;
        private String[] optionalDependencyPatterns = new String[0];
        private String[] excludeDependencyFilterPatterns = new String[0];
        private String mainClass;
        private Map<String, Object> properties = new HashMap<String, Object>();

        public T name(String name) {
            this.name = name;
            return (T)this;
        }

        public T url(URL url) {
            this.url = url;
            return (T)this;
        }

        public T url(String url) throws MalformedURLException {
            this.url = new URL(url);
            return (T)this;
        }

        public T controllerUrl(URL controllerUrl) {
            this.controllerUrl = controllerUrl;
            return (T)this;
        }

        public T controllerUrl(String controllerUrl) throws MalformedURLException {
            this.controllerUrl = new URL(controllerUrl);
            return (T)this;
        }

        public T extractCmd(String extract) {
            this.extractCmd = extract;
            return (T)this;
        }

        public T groupId(String groupId) {
            this.groupId = groupId;
            return (T)this;
        }

        public T artifactId(String artifactId) {
            this.artifactId = artifactId;
            return (T)this;
        }

        public T version(String version) {
            if (!Strings.isNullOrEmpty((String)version)) {
                this.version = version;
            }
            return (T)this;
        }

        public T extension(String extension) {
            if (!Strings.isNullOrEmpty((String)extension)) {
                this.extension = extension;
            }
            return (T)this;
        }

        public T classifier(String classifier) {
            this.classifier = classifier;
            return (T)this;
        }

        public T offline(boolean offline) {
            this.offline = offline;
            return (T)this;
        }

        public T optionalDependencyPatterns(String ... optionalDependencyPatterns) {
            this.optionalDependencyPatterns = (String[])Objects.firstNonNull((Object)optionalDependencyPatterns, (Object)new String[0]);
            return (T)this;
        }

        public T excludeDependencyFilterPatterns(String ... excludeDependencyFilterPatterns) {
            this.excludeDependencyFilterPatterns = (String[])Objects.firstNonNull((Object)excludeDependencyFilterPatterns, (Object)new String[0]);
            return (T)this;
        }

        public T mainClass(String mainClass) {
            this.mainClass = mainClass;
            return (T)this;
        }

        public URL getControllerUrl() {
            return this.controllerUrl;
        }

        public String getExtractCmd() {
            return this.extractCmd;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public String getExtension() {
            return this.extension;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public boolean isOffline() {
            return this.offline;
        }

        public String[] getOptionalDependencyPatterns() {
            return this.optionalDependencyPatterns;
        }

        public String[] getExcludeDependencyFilterPatterns() {
            return this.excludeDependencyFilterPatterns;
        }

        public String getMainClass() {
            return this.mainClass;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }

        public InstallOptionsBuilder properties(Map<String, Object> properties) {
            this.properties = properties;
            return this;
        }

        public URL getUrl() throws MalformedURLException {
            if (this.url != null) {
                return this.url;
            }
            StringBuilder sb = new StringBuilder();
            sb.append("mvn:");
            boolean invalid = false;
            if (this.groupId != null) {
                sb.append(this.groupId).append("/");
            } else {
                invalid = true;
            }
            if (this.artifactId != null) {
                sb.append(this.artifactId).append("/");
            } else {
                invalid = true;
            }
            if (this.version != null) {
                sb.append(this.version);
            } else {
                invalid = true;
            }
            if (this.extension != null) {
                sb.append("/").append(this.extension);
            }
            if (this.classifier != null) {
                sb.append("/").append(this.classifier);
            }
            if (invalid) {
                return null;
            }
            return new URL(sb.toString());
        }

        public String getName() {
            if (!Strings.isNullOrEmpty((String)this.name)) {
                return this.name;
            }
            if (!(Strings.isNullOrEmpty((String)this.groupId) || Strings.isNullOrEmpty((String)this.artifactId) || Strings.isNullOrEmpty((String)this.version))) {
                return this.groupId + ":" + this.artifactId + ":" + this.version;
            }
            return null;
        }

        public InstallOptions build() throws MalformedURLException {
            return new InstallOptions(this.getName(), this.getUrl(), this.controllerUrl, this.extractCmd, this.offline, this.optionalDependencyPatterns, this.excludeDependencyFilterPatterns, this.mainClass, this.properties);
        }
    }
}

