/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.command;

import java.net.URI;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.karaf.util.MvnUtils;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;

public class FeatureFinder
implements ManagedService {
    Map<String, String> nameToArtifactMap = new HashMap<String, String>();

    public String[] getNames() {
        return this.nameToArtifactMap.keySet().toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URI getUriFor(String name, String version) throws Exception {
        String url;
        Map<String, String> map = this.nameToArtifactMap;
        synchronized (map) {
            url = this.nameToArtifactMap.get(name);
        }
        if (url == null) {
            return null;
        }
        if (version != null) {
            url = MvnUtils.replaceVersion(url, version);
        }
        return URI.create(url);
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        if (properties != null) {
            this.nameToArtifactMap.clear();
            Enumeration keys = properties.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if ("felix.fileinstall.filename".equals(key) || "service.pid".equals(key)) continue;
                this.nameToArtifactMap.put(key, (String)properties.get(key));
            }
        }
    }
}

