/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.command;

import java.net.URI;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.apache.karaf.features.command.FeaturesCommandSupport;

@Command(scope="features", name="removeRepository", description="Removes the specified repository features service.")
public class RemoveRepositoryCommand
extends FeaturesCommandSupport {
    @Argument(index=0, name="repository", description="Name of the repository to remove.", required=true, multiValued=false)
    private String repository;

    protected void doExecute(FeaturesService admin) throws Exception {
        URI uri = null;
        for (Repository r : admin.listRepositories()) {
            if (!r.getName().equals(this.repository)) continue;
            uri = r.getURI();
            break;
        }
        if (uri == null) {
            System.out.println("Repository '" + this.repository + "' not found.");
        } else {
            admin.removeRepository(uri);
        }
    }
}

