/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.fabric.commands;

import com.google.common.collect.ImmutableMap;
import io.fabric8.process.fabric.ContainerInstallOptions;
import io.fabric8.process.fabric.commands.ContainerProcessCommandSupport;
import io.fabric8.process.manager.Installation;
import org.apache.felix.gogo.commands.Argument;

public abstract class ContainerProcessControllerSupport
extends ContainerProcessCommandSupport {
    @Argument(index=1, required=true, multiValued=true, name="id", description="The id of the managed processes to control")
    protected String[] ids;

    protected abstract void doControlCommand(Installation var1) throws Exception;

    @Override
    void doWithAuthentication(String jmxUser, String jmxPassword) throws Exception {
        ContainerInstallOptions options = ContainerInstallOptions.builder().container(this.container).user(jmxUser).password(jmxPassword).build();
        ImmutableMap<String, Installation> map = this.getContainerProcessManager().listInstallationMap(options);
        for (String id : this.ids) {
            Installation installation = (Installation)map.get((Object)id);
            if (installation == null) {
                System.out.println("No such process number: " + id);
                continue;
            }
            this.doControlCommand(installation);
        }
    }
}

