/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.download;

import io.fabric8.agent.download.Future;
import io.fabric8.agent.download.FutureListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class DefaultFuture<T extends Future>
implements Future<T> {
    private static final Object CANCELED = new Object();
    private static final long DEAD_LOCK_CHECK_INTERVAL = 5000L;
    private final Object lock;
    private FutureListener<T> firstListener;
    private List<FutureListener<T>> otherListeners;
    private Object result;
    private boolean ready;
    private int waiters;

    public DefaultFuture() {
        this(null);
    }

    public DefaultFuture(Object lock) {
        this.lock = lock != null ? lock : this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T await() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (!this.ready) {
                ++this.waiters;
                try {
                    this.lock.wait(5000L);
                }
                finally {
                    --this.waiters;
                    if (this.ready) continue;
                    this.checkDeadLock();
                }
            }
            return (T)this;
        }
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.await(unit.toMillis(timeout));
    }

    @Override
    public boolean await(long timeoutMillis) throws InterruptedException {
        return this.await0(timeoutMillis, true);
    }

    @Override
    public T awaitUninterruptibly() {
        try {
            this.await0(Long.MAX_VALUE, false);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return (T)this;
    }

    @Override
    public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        return this.awaitUninterruptibly(unit.toMillis(timeout));
    }

    @Override
    public boolean awaitUninterruptibly(long timeoutMillis) {
        try {
            return this.await0(timeoutMillis, false);
        }
        catch (InterruptedException e) {
            throw new InternalError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean await0(long timeoutMillis, boolean interruptable) throws InterruptedException {
        long endTime = System.currentTimeMillis() + timeoutMillis;
        Object object = this.lock;
        synchronized (object) {
            if (this.ready) {
                return this.ready;
            }
            if (timeoutMillis <= 0L) {
                return this.ready;
            }
            ++this.waiters;
            try {
                do {
                    block12: {
                        try {
                            long timeOut = Math.min(timeoutMillis, 5000L);
                            this.lock.wait(timeOut);
                        }
                        catch (InterruptedException e) {
                            if (!interruptable) break block12;
                            throw e;
                        }
                    }
                    if (!this.ready) continue;
                    boolean bl = true;
                    return bl;
                } while (endTime >= System.currentTimeMillis());
                boolean bl = this.ready;
                return bl;
            }
            finally {
                --this.waiters;
                if (!this.ready) {
                    this.checkDeadLock();
                }
            }
        }
    }

    private void checkDeadLock() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        Object object = this.lock;
        synchronized (object) {
            return this.ready;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Object newValue) {
        Object object = this.lock;
        synchronized (object) {
            if (this.ready) {
                return;
            }
            this.result = newValue;
            this.ready = true;
            if (this.waiters > 0) {
                this.lock.notifyAll();
            }
        }
        this.notifyListeners();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getValue() {
        Object object = this.lock;
        synchronized (object) {
            return this.result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T addListener(FutureListener<T> listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        boolean notifyNow = false;
        Object object = this.lock;
        synchronized (object) {
            if (this.ready) {
                notifyNow = true;
            } else if (this.firstListener == null) {
                this.firstListener = listener;
            } else {
                if (this.otherListeners == null) {
                    this.otherListeners = new ArrayList<FutureListener<T>>(1);
                }
                this.otherListeners.add(listener);
            }
        }
        if (notifyNow) {
            this.notifyListener(listener);
        }
        return (T)this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T removeListener(FutureListener<T> listener) {
        if (listener == null) {
            throw new NullPointerException("listener");
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.ready) {
                if (listener == this.firstListener) {
                    this.firstListener = this.otherListeners != null && !this.otherListeners.isEmpty() ? this.otherListeners.remove(0) : null;
                } else if (this.otherListeners != null) {
                    this.otherListeners.remove(listener);
                }
            }
        }
        return (T)this;
    }

    private void notifyListeners() {
        if (this.firstListener != null) {
            this.notifyListener(this.firstListener);
            this.firstListener = null;
            if (this.otherListeners != null) {
                for (FutureListener<T> l : this.otherListeners) {
                    this.notifyListener(l);
                }
                this.otherListeners = null;
            }
        }
    }

    private void notifyListener(FutureListener<T> l) {
        try {
            l.operationComplete(this);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public boolean isCanceled() {
        return this.getValue() == CANCELED;
    }

    public void cancel() {
        this.setValue(CANCELED);
    }
}

