/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.fabric.child;

import io.fabric8.api.Container;
import io.fabric8.api.FabricService;
import io.fabric8.api.Profile;
import io.fabric8.internal.ProfileImpl;
import io.fabric8.process.fabric.child.ProcessRequirements;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ProcessProfile
extends ProfileImpl {
    private final Container container;
    private final ProcessRequirements requirements;
    private final boolean includeContainerProfile;

    public ProcessProfile(Container container, ProcessRequirements requirements, FabricService fabricService, boolean includeContainerProfile) {
        super(requirements.getId(), container.getVersion().getId(), fabricService);
        this.container = container;
        this.requirements = requirements;
        this.includeContainerProfile = includeContainerProfile;
    }

    public String getVersion() {
        return this.container.getVersion().getId();
    }

    public Map<String, String> getAttributes() {
        return Collections.emptyMap();
    }

    public void setAttribute(String key, String value) {
        throw new UnsupportedOperationException();
    }

    public Profile[] getParents() {
        List<String> parents = this.requirements.getProfiles();
        LinkedList<Profile> profiles = new LinkedList<Profile>();
        if (this.includeContainerProfile) {
            profiles.add(this.container.getOverlayProfile());
        }
        for (String parent : parents) {
            Profile p = this.container.getVersion().getProfile(parent);
            profiles.add(p);
        }
        return profiles.toArray(new Profile[profiles.size()]);
    }

    public void setParents(Profile[] parents) {
        throw new UnsupportedOperationException();
    }

    public void setConfigurations(Map<String, Map<String, String>> configurations) {
        throw new UnsupportedOperationException();
    }

    public boolean isOverlay() {
        return false;
    }

    public void delete() {
        throw new UnsupportedOperationException();
    }

    public void setBundles(List<String> values) {
        throw new UnsupportedOperationException();
    }

    public void setFabs(List<String> values) {
        throw new UnsupportedOperationException();
    }

    public void setFeatures(List<String> values) {
        throw new UnsupportedOperationException();
    }

    public void setRepositories(List<String> values) {
        throw new UnsupportedOperationException();
    }

    public void setOverrides(List<String> values) {
        throw new UnsupportedOperationException();
    }

    public boolean configurationEquals(Profile other) {
        throw new UnsupportedOperationException();
    }

    public boolean agentConfigurationEquals(Profile other) {
        throw new UnsupportedOperationException();
    }

    public boolean isAbstract() {
        return true;
    }

    public boolean isLocked() {
        return true;
    }

    public boolean isHidden() {
        return true;
    }

    public String getId() {
        return "process-profile-" + this.requirements.getId();
    }
}

