/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.process.fabric.commands;

import io.fabric8.process.fabric.ContainerInstallOptions;
import io.fabric8.process.fabric.commands.ContainerInstallSupport;
import io.fabric8.process.manager.InstallTask;
import io.fabric8.process.manager.Installation;
import io.fabric8.utils.shell.ShellUtils;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;

@Command(name="process-install", scope="fabric", description="Installs a managed process into this container.")
public class Install
extends ContainerInstallSupport {
    @Argument(index=1, required=true, name="name", description="The name of the process to add")
    protected String name;
    @Argument(index=2, required=true, name="url", description="The URL of the installation distribution to install. Typically this is a tarball or zip file")
    protected String url;
    @Argument(index=4, required=false, name="extractCmd", description="The extract command and args to use on the downloaded artifact, defaults to 'tar zxf'")
    protected String[] extractCmd = new String[]{"tar", "zxf"};

    @Override
    void doWithAuthentication(String jmxUser, String jmxPassword) throws Exception {
        ContainerInstallOptions options = ((ContainerInstallOptions.ContainerInstallOptionsBuilder)((ContainerInstallOptions.ContainerInstallOptionsBuilder)((ContainerInstallOptions.ContainerInstallOptionsBuilder)((ContainerInstallOptions.ContainerInstallOptionsBuilder)ContainerInstallOptions.builder().container(this.container).user(jmxUser).password(jmxPassword).name(this.name)).url(this.url)).extractCmd(this.getExtract(this.extractCmd))).controllerUrl(this.getControllerURL())).build();
        InstallTask postInstall = null;
        Installation install = this.getContainerProcessManager().install(options, postInstall);
        ShellUtils.storeFabricCredentials(this.session, jmxUser, jmxPassword);
        System.out.println("Installed process " + install.getId() + " to " + install.getInstallDir());
    }

    private String getExtract(String[] extract) {
        if (extract == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (String str : extract) {
            if (str == null || str.trim().isEmpty()) continue;
            builder.append(str).append(' ');
        }
        String trimmedValue = builder.toString().trim();
        return trimmedValue.isEmpty() ? null : trimmedValue;
    }
}

