/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.patch.impl;

import io.fabric8.common.util.IOHelpers;
import io.fabric8.patch.BundleUpdate;
import io.fabric8.patch.Patch;
import io.fabric8.patch.PatchException;
import io.fabric8.patch.Result;
import io.fabric8.patch.Service;
import io.fabric8.patch.impl.BundleUpdateImpl;
import io.fabric8.patch.impl.Offline;
import io.fabric8.patch.impl.PatchData;
import io.fabric8.patch.impl.PatchImpl;
import io.fabric8.patch.impl.ResultImpl;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Parser;
import org.apache.felix.utils.version.VersionRange;
import org.apache.felix.utils.version.VersionTable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.FrameworkWiring;

public class ServiceImpl
implements Service {
    private final BundleContext bundleContext;
    private final File patchDir;
    private static final String ID = "id";
    private static final String DESCRIPTION = "description";
    private static final String DATE = "date";
    private static final String BUNDLES = "bundle";
    private static final String UPDATES = "update";
    private static final String COUNT = "count";
    private static final String RANGE = "range";
    private static final String SYMBOLIC_NAME = "symbolic-name";
    private static final String NEW_VERSION = "new-version";
    private static final String NEW_LOCATION = "new-location";
    private static final String OLD_VERSION = "old-version";
    private static final String OLD_LOCATION = "old-location";
    private static final String STARTUP = "startup";
    private static final String OVERRIDES = "overrides";
    private static final Pattern SYMBOLIC_NAME_PATTERN = Pattern.compile("([^;: ]+)(.*)");

    public ServiceImpl(BundleContext bundleContext) {
        this.bundleContext = bundleContext.getBundle(0L).getBundleContext();
        String dir = this.bundleContext.getProperty("fabric8.patch.location");
        File file = this.patchDir = dir != null ? new File(dir) : this.bundleContext.getDataFile("patches");
        if (!this.patchDir.isDirectory()) {
            this.patchDir.mkdirs();
            if (!this.patchDir.isDirectory()) {
                throw new PatchException("Unable to create patch folder");
            }
        }
        this.load();
    }

    @Override
    public Iterable<Patch> getPatches() {
        return Collections.unmodifiableCollection(this.load().values());
    }

    @Override
    public Patch getPatch(String id) {
        return this.load().get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<Patch> download(URL url) {
        try {
            File file = new File(this.patchDir, Long.toString(System.currentTimeMillis()) + ".patch.tmp");
            InputStream is = null;
            FileOutputStream os = null;
            try {
                is = url.openStream();
                os = new FileOutputStream(file);
                IOHelpers.copy((InputStream)is, (OutputStream)os);
            }
            catch (Throwable throwable) {
                IOHelpers.close((Closeable[])new Closeable[]{is, os});
                throw throwable;
            }
            IOHelpers.close((Closeable[])new Closeable[]{is, os});
            ArrayList<Patch> patches = new ArrayList<Patch>();
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(file);
            }
            catch (IOException e) {
                // empty catch block
            }
            if (zipFile != null) {
                File localRepoPath = new File(System.getProperty("karaf.base"), "system");
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory()) continue;
                    String entryName = entry.getName();
                    if (entryName.startsWith("repository/")) {
                        String fileName = entryName.substring("repository/".length());
                        File f = new File(localRepoPath, fileName);
                        if (f.isFile()) continue;
                        f.getParentFile().mkdirs();
                        InputStream fis = zipFile.getInputStream(entry);
                        FileOutputStream fos = new FileOutputStream(f);
                        try {
                            IOHelpers.copy((InputStream)fis, (OutputStream)fos);
                        }
                        catch (Throwable throwable) {
                            IOHelpers.close((Closeable[])new Closeable[]{fis, fos});
                            throw throwable;
                        }
                        IOHelpers.close((Closeable[])new Closeable[]{fis, fos});
                        continue;
                    }
                    if (!entryName.endsWith(".patch") || entryName.contains("/")) continue;
                    File f = new File(this.patchDir, entryName);
                    if (!f.isFile()) {
                        InputStream fis = zipFile.getInputStream(entry);
                        FileOutputStream fos = new FileOutputStream(f);
                        try {
                            IOHelpers.copy((InputStream)fis, (OutputStream)fos);
                        }
                        catch (Throwable throwable) {
                            IOHelpers.close((Closeable[])new Closeable[]{fis, fos});
                            throw throwable;
                        }
                        IOHelpers.close((Closeable[])new Closeable[]{fis, fos});
                    }
                    Patch patch = this.load(f);
                    f.renameTo(new File(this.patchDir, patch.getId() + ".patch"));
                    patches.add(patch);
                }
                IOHelpers.close((ZipFile[])new ZipFile[]{zipFile});
                file.delete();
            } else {
                Patch patch = this.load(file);
                file.renameTo(new File(this.patchDir, patch.getId() + ".patch"));
                patches.add(patch);
            }
            return patches;
        }
        catch (Exception e) {
            throw new PatchException("Unable to download patch from url " + url, e);
        }
    }

    public void cliInstall(String[] ids) {
        ArrayList<Patch> patches = new ArrayList<Patch>();
        for (String id : ids) {
            Patch patch = this.getPatch(id);
            if (patch == null) {
                throw new IllegalArgumentException("Unknown patch: " + id);
            }
            patches.add(patch);
        }
        this.install(patches, false, false);
    }

    Map<String, Patch> load() {
        HashMap<String, Patch> patches = new HashMap<String, Patch>();
        for (File file : this.patchDir.listFiles()) {
            if (!file.exists() || !file.getName().endsWith(".patch")) continue;
            try {
                Patch patch = this.load(file);
                patches.put(patch.getId(), patch);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return patches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Patch load(File file) throws IOException {
        PatchImpl patchImpl;
        FileInputStream is = new FileInputStream(file);
        try {
            PatchImpl patch = ServiceImpl.doLoad(this, is);
            File fr = new File(file.getParent(), file.getName() + ".result");
            if (fr.isFile()) {
                patch.setResult(this.loadResult(patch, fr));
            }
            patchImpl = patch;
        }
        catch (Throwable throwable) {
            IOHelpers.close((Closeable[])new Closeable[]{is});
            throw throwable;
        }
        IOHelpers.close((Closeable[])new Closeable[]{is});
        return patchImpl;
    }

    public static PatchImpl doLoad(ServiceImpl service, InputStream is) throws IOException {
        return new PatchImpl(service, PatchData.load(is));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Result loadResult(Patch patch, File file) throws IOException {
        ResultImpl resultImpl;
        Properties props = new Properties();
        FileInputStream is = new FileInputStream(file);
        try {
            props.load(is);
            long date = Long.parseLong(props.getProperty(DATE));
            ArrayList<BundleUpdate> updates = new ArrayList<BundleUpdate>();
            int count = Integer.parseInt(props.getProperty("update.count", "0"));
            for (int i = 0; i < count; ++i) {
                String sn = props.getProperty("update." + Integer.toString(i) + "." + SYMBOLIC_NAME);
                String nv = props.getProperty("update." + Integer.toString(i) + "." + NEW_VERSION);
                String nl = props.getProperty("update." + Integer.toString(i) + "." + NEW_LOCATION);
                String ov = props.getProperty("update." + Integer.toString(i) + "." + OLD_VERSION);
                String ol = props.getProperty("update." + Integer.toString(i) + "." + OLD_LOCATION);
                updates.add(new BundleUpdateImpl(sn, nv, nl, ov, ol));
            }
            String startup = props.getProperty(STARTUP);
            String overrides = props.getProperty(OVERRIDES);
            resultImpl = new ResultImpl(patch, false, date, updates, startup, overrides);
        }
        catch (Throwable throwable) {
            IOHelpers.close((Closeable[])new Closeable[]{is});
            throw throwable;
        }
        IOHelpers.close((Closeable[])new Closeable[]{is});
        return resultImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveResult(Result result) throws IOException {
        File file = new File(this.patchDir, result.getPatch().getId() + ".patch.result");
        Properties props = new Properties();
        FileOutputStream fos = new FileOutputStream(file);
        try {
            props.put(DATE, Long.toString(result.getDate()));
            props.put("update.count", Integer.toString(result.getUpdates().size()));
            int i = 0;
            for (BundleUpdate update : result.getUpdates()) {
                props.put("update." + Integer.toString(i) + "." + SYMBOLIC_NAME, update.getSymbolicName());
                props.put("update." + Integer.toString(i) + "." + NEW_VERSION, update.getNewVersion());
                props.put("update." + Integer.toString(i) + "." + NEW_LOCATION, update.getNewLocation());
                props.put("update." + Integer.toString(i) + "." + OLD_VERSION, update.getPreviousVersion());
                props.put("update." + Integer.toString(i) + "." + OLD_LOCATION, update.getPreviousLocation());
                ++i;
            }
            props.put(STARTUP, ((ResultImpl)result).getStartup());
            String overrides = ((ResultImpl)result).getOverrides();
            if (overrides != null) {
                props.put(OVERRIDES, overrides);
            }
            props.store(fos, "Installation results for patch " + result.getPatch().getId());
        }
        catch (Throwable throwable) {
            IOHelpers.close((Closeable[])new Closeable[]{fos});
            throw throwable;
        }
        IOHelpers.close((Closeable[])new Closeable[]{fos});
    }

    void rollback(Patch patch, boolean force) throws PatchException {
        Version v;
        Result result = patch.getResult();
        if (result == null) {
            throw new PatchException("Patch " + patch.getId() + " is not installed");
        }
        Bundle[] allBundles = this.bundleContext.getBundles();
        ArrayList<BundleUpdate> badUpdates = new ArrayList<BundleUpdate>();
        for (BundleUpdate update : result.getUpdates()) {
            boolean found = false;
            v = Version.parseVersion((String)update.getNewVersion());
            for (Bundle bundle : allBundles) {
                if (!ServiceImpl.stripSymbolicName(bundle.getSymbolicName()).equals(ServiceImpl.stripSymbolicName(update.getSymbolicName())) || !bundle.getVersion().equals((Object)v)) continue;
                found = true;
                break;
            }
            if (found) continue;
            badUpdates.add(update);
        }
        if (!badUpdates.isEmpty() && !force) {
            StringBuilder sb = new StringBuilder();
            sb.append("Unable to rollback patch ").append(patch.getId()).append(" because of the following missing bundles:\n");
            for (BundleUpdate up : badUpdates) {
                sb.append("\t").append(up.getSymbolicName()).append("/").append(up.getNewVersion()).append("\n");
            }
            throw new PatchException(sb.toString());
        }
        HashMap<Bundle, String> toUpdate = new HashMap<Bundle, String>();
        for (BundleUpdate update : result.getUpdates()) {
            v = Version.parseVersion((String)update.getNewVersion());
            for (Bundle bundle : allBundles) {
                if (!ServiceImpl.stripSymbolicName(bundle.getSymbolicName()).equals(ServiceImpl.stripSymbolicName(update.getSymbolicName())) || !bundle.getVersion().equals((Object)v)) continue;
                toUpdate.put(bundle, update.getPreviousLocation());
            }
        }
        try {
            this.applyChanges(toUpdate);
            IOHelpers.writeFully((File)new File(System.getProperty("karaf.base"), "etc/startup.properties"), (String)((ResultImpl)result).getStartup());
            IOHelpers.writeFully((File)new File(System.getProperty("karaf.base"), "etc/overrides.properties"), (String)((ResultImpl)result).getOverrides());
        }
        catch (Exception e) {
            throw new PatchException("Unable to rollback patch " + patch.getId() + ": " + e.getMessage(), e);
        }
        ((PatchImpl)patch).setResult(null);
        File file = new File(this.patchDir, result.getPatch().getId() + ".patch.result");
        file.delete();
    }

    Result install(Patch patch, boolean simulate) {
        return this.install(patch, simulate, true);
    }

    Result install(Patch patch, boolean simulate, boolean synchronous) {
        Map<String, Result> results = this.install(Collections.singleton(patch), simulate, synchronous);
        return results.get(patch.getId());
    }

    Map<String, Result> install(final Collection<Patch> patches, boolean simulate, boolean synchronous) {
        try {
            final LinkedHashMap<String, Result> results = new LinkedHashMap<String, Result>();
            final HashMap<Bundle, String> toUpdate = new HashMap<Bundle, String>();
            HashMap<String, BundleUpdateImpl> allUpdates = new HashMap<String, BundleUpdateImpl>();
            for (Patch patch : patches) {
                String startup = IOHelpers.readFully((File)new File(System.getProperty("karaf.base"), "etc/startup.properties"));
                String overrides = IOHelpers.readFully((File)new File(System.getProperty("karaf.base"), "etc/overrides.properties"));
                ArrayList<BundleUpdate> updates = new ArrayList<BundleUpdate>();
                Bundle[] allBundles = this.bundleContext.getBundles();
                for (String url : patch.getBundles()) {
                    String vr;
                    JarInputStream jis = new JarInputStream(new URL(url).openStream());
                    jis.close();
                    Manifest manifest = jis.getManifest();
                    Attributes att = manifest != null ? manifest.getMainAttributes() : null;
                    String sn = att != null ? att.getValue("Bundle-SymbolicName") : null;
                    String string = vr = att != null ? att.getValue("Bundle-Version") : null;
                    if (sn == null || vr == null) continue;
                    Version v = VersionTable.getVersion(vr);
                    VersionRange range = null;
                    if (patch.getVersionRange(url) == null) {
                        Version lower = new Version(v.getMajor(), v.getMinor(), 0);
                        if (v.compareTo(lower) > 0) {
                            range = new VersionRange(false, lower, v, true);
                        }
                    } else {
                        range = new VersionRange(patch.getVersionRange(url));
                    }
                    if (range != null) {
                        for (Bundle bundle : allBundles) {
                            Version oldV = bundle.getVersion();
                            if (bundle.getBundleId() == 0L || !ServiceImpl.stripSymbolicName(sn).equals(ServiceImpl.stripSymbolicName(bundle.getSymbolicName())) || !range.contains(oldV)) continue;
                            String location = bundle.getLocation();
                            BundleUpdateImpl update = new BundleUpdateImpl(sn, v.toString(), url, oldV.toString(), location);
                            updates.add(update);
                            BundleUpdate oldUpdate = (BundleUpdate)allUpdates.get(sn);
                            if (oldUpdate != null) {
                                Version upv = VersionTable.getVersion(oldUpdate.getNewVersion());
                                if (upv.compareTo(v) >= 0) continue;
                                allUpdates.put(sn, update);
                                toUpdate.put(bundle, url);
                                continue;
                            }
                            toUpdate.put(bundle, url);
                        }
                        continue;
                    }
                    System.err.printf("Skipping bundle %s - unable to process bundle without a version range configuration%n", url);
                }
                if (!simulate) {
                    new Offline(new File(System.getProperty("karaf.base"))).applyConfigChanges(((PatchImpl)patch).getPatch());
                }
                ResultImpl result = new ResultImpl(patch, simulate, System.currentTimeMillis(), updates, startup, overrides);
                results.put(patch.getId(), result);
            }
            System.out.println("Bundles to update:");
            for (Map.Entry entry : toUpdate.entrySet()) {
                System.out.println("    " + ((Bundle)entry.getKey()).getSymbolicName() + "/" + ((Bundle)entry.getKey()).getVersion().toString() + " with " + (String)entry.getValue());
            }
            if (simulate) {
                System.out.println("Running simulation only - no bundles are being updated at this time");
            } else {
                System.out.println("Installation will begin.  The connection may be lost or the console restarted.");
            }
            System.out.flush();
            if (!simulate) {
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        try {
                            ServiceImpl.this.applyChanges(toUpdate);
                            for (Patch patch : patches) {
                                Result result = (Result)results.get(patch.getId());
                                ((PatchImpl)patch).setResult(result);
                                ServiceImpl.this.saveResult(result);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace(System.err);
                            System.err.flush();
                        }
                    }
                };
                if (synchronous) {
                    thread.run();
                } else {
                    thread.start();
                }
            }
            return results;
        }
        catch (Exception e) {
            throw new PatchException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyChanges(Map<Bundle, String> toUpdate) throws BundleException, IOException {
        ArrayList<Bundle> toStop = new ArrayList<Bundle>();
        toStop.addAll(toUpdate.keySet());
        while (!toStop.isEmpty()) {
            List<Bundle> bs = this.getBundlesToDestroy(toStop);
            for (Bundle bundle : bs) {
                String hostHeader = (String)bundle.getHeaders().get("Fragment-Host");
                if (hostHeader == null && (bundle.getState() == 32 || bundle.getState() == 8)) {
                    bundle.stop();
                }
                toStop.remove(bundle);
            }
        }
        HashSet<Bundle> toRefresh = new HashSet<Bundle>();
        HashSet<Bundle> toStart = new HashSet<Bundle>();
        for (Map.Entry<Bundle, String> e : toUpdate.entrySet()) {
            InputStream is = new URL(e.getValue()).openStream();
            try {
                Bundle bundle = e.getKey();
                bundle.update(is);
                toRefresh.add(bundle);
                toStart.add(bundle);
            }
            finally {
                is.close();
            }
        }
        this.findBundlesWithOptionalPackagesToRefresh(toRefresh);
        this.findBundlesWithFramentsToRefresh(toRefresh);
        if (!toRefresh.isEmpty()) {
            final CountDownLatch l = new CountDownLatch(1);
            FrameworkListener listener = new FrameworkListener(){

                public void frameworkEvent(FrameworkEvent event) {
                    l.countDown();
                }
            };
            FrameworkWiring wiring = (FrameworkWiring)this.bundleContext.getBundle(0L).adapt(FrameworkWiring.class);
            wiring.refreshBundles(toRefresh, new FrameworkListener[]{listener});
            try {
                l.await();
            }
            catch (InterruptedException e) {
                throw new PatchException("Bundle refresh interrupted", e);
            }
        }
        for (Bundle bundle : toStart) {
            String hostHeader = (String)bundle.getHeaders().get("Fragment-Host");
            if (hostHeader != null) continue;
            bundle.start();
        }
    }

    private List<Bundle> getBundlesToDestroy(List<Bundle> bundles) {
        ArrayList<Bundle> bundlesToDestroy = new ArrayList<Bundle>();
        for (Bundle bundle : bundles) {
            ServiceReference[] references = bundle.getRegisteredServices();
            int usage = 0;
            if (references != null) {
                for (ServiceReference reference : references) {
                    usage += ServiceImpl.getServiceUsage(reference, bundles);
                }
            }
            if (usage != 0) continue;
            bundlesToDestroy.add(bundle);
        }
        if (!bundlesToDestroy.isEmpty()) {
            Collections.sort(bundlesToDestroy, new Comparator<Bundle>(){

                @Override
                public int compare(Bundle b1, Bundle b2) {
                    return (int)(b2.getLastModified() - b1.getLastModified());
                }
            });
        } else {
            ServiceReference ref = null;
            for (Bundle bundle : bundles) {
                ServiceReference[] references;
                for (ServiceReference reference : references = bundle.getRegisteredServices()) {
                    if (ServiceImpl.getServiceUsage(reference, bundles) == 0 || ref != null && reference.compareTo((Object)ref) >= 0) continue;
                    ref = reference;
                }
            }
            if (ref != null) {
                bundlesToDestroy.add(ref.getBundle());
            }
        }
        return bundlesToDestroy;
    }

    private static int getServiceUsage(ServiceReference ref, List<Bundle> bundles) {
        Bundle[] usingBundles = ref.getUsingBundles();
        int nb = 0;
        if (usingBundles != null) {
            for (Bundle bundle : usingBundles) {
                if (!bundles.contains(bundle)) continue;
                ++nb;
            }
        }
        return nb;
    }

    protected void findBundlesWithFramentsToRefresh(Set<Bundle> toRefresh) {
        for (Bundle b : toRefresh) {
            Clause[] clauses;
            String hostHeader;
            if (b.getState() == 1 || (hostHeader = (String)b.getHeaders().get("Fragment-Host")) == null || (clauses = Parser.parseHeader(hostHeader)) == null || clauses.length <= 0) continue;
            Clause path = clauses[0];
            for (Bundle hostBundle : this.bundleContext.getBundles()) {
                if (!hostBundle.getSymbolicName().equals(path.getName())) continue;
                String ver = path.getAttribute("bundle-version");
                if (ver != null) {
                    VersionRange v = VersionRange.parseVersionRange(ver);
                    if (!v.contains(hostBundle.getVersion())) continue;
                    toRefresh.add(hostBundle);
                    continue;
                }
                toRefresh.add(hostBundle);
            }
        }
    }

    protected void findBundlesWithOptionalPackagesToRefresh(Set<Bundle> toRefresh) {
        List importsList;
        HashSet<Bundle> bundles = new HashSet<Bundle>(Arrays.asList(this.bundleContext.getBundles()));
        bundles.removeAll(toRefresh);
        if (bundles.isEmpty()) {
            return;
        }
        HashMap<Bundle, List> imports = new HashMap<Bundle, List>();
        Iterator it = bundles.iterator();
        while (it.hasNext()) {
            Bundle b = (Bundle)it.next();
            String importsStr = (String)b.getHeaders().get("Import-Package");
            importsList = this.getOptionalImports(importsStr);
            if (importsList.isEmpty()) {
                it.remove();
                continue;
            }
            imports.put(b, importsList);
        }
        if (bundles.isEmpty()) {
            return;
        }
        ArrayList<Clause> exports = new ArrayList<Clause>();
        for (Bundle b : toRefresh) {
            String exportsStr;
            if (b.getState() == 1 || (exportsStr = (String)b.getHeaders().get("Export-Package")) == null) continue;
            Clause[] exportsList = Parser.parseHeader(exportsStr);
            exports.addAll(Arrays.asList(exportsList));
        }
        Iterator it2 = bundles.iterator();
        while (it2.hasNext()) {
            Bundle b;
            b = (Bundle)it2.next();
            importsList = (List)imports.get(b);
            Iterator itpi = importsList.iterator();
            while (itpi.hasNext()) {
                Clause pi = (Clause)itpi.next();
                boolean matching = false;
                for (Clause pe : exports) {
                    Version exported;
                    if (!pi.getName().equals(pe.getName())) continue;
                    String evStr = pe.getAttribute("version");
                    String ivStr = pi.getAttribute("version");
                    VersionRange imported = ivStr != null ? VersionRange.parseVersionRange(ivStr) : VersionRange.ANY_VERSION;
                    if (!imported.contains(exported = evStr != null ? Version.parseVersion((String)evStr) : Version.emptyVersion)) continue;
                    matching = true;
                    break;
                }
                if (matching) continue;
                itpi.remove();
            }
            if (!importsList.isEmpty()) continue;
            it2.remove();
        }
        toRefresh.addAll(bundles);
    }

    protected List<Clause> getOptionalImports(String importsStr) {
        Clause[] imports = Parser.parseHeader(importsStr);
        LinkedList<Clause> result = new LinkedList<Clause>();
        for (int i = 0; i < imports.length; ++i) {
            String resolution = imports[i].getDirective("resolution");
            if (!"optional".equals(resolution)) continue;
            result.add(imports[i]);
        }
        return result;
    }

    static String stripSymbolicName(String symbolicName) {
        Matcher m = SYMBOLIC_NAME_PATTERN.matcher(symbolicName);
        if (m.matches() && m.groupCount() >= 1) {
            return m.group(1);
        }
        return symbolicName;
    }
}

