/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.FulcioCAWithRekor;
import io.fabric8.openshift.api.model.config.v1.FulcioCAWithRekorBuilder;
import io.fabric8.openshift.api.model.config.v1.FulcioCAWithRekorFluent;
import io.fabric8.openshift.api.model.config.v1.PKI;
import io.fabric8.openshift.api.model.config.v1.PKIBuilder;
import io.fabric8.openshift.api.model.config.v1.PKIFluent;
import io.fabric8.openshift.api.model.config.v1.PolicyRootOfTrust;
import io.fabric8.openshift.api.model.config.v1.PublicKey;
import io.fabric8.openshift.api.model.config.v1.PublicKeyBuilder;
import io.fabric8.openshift.api.model.config.v1.PublicKeyFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PolicyRootOfTrustFluent<A extends PolicyRootOfTrustFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private FulcioCAWithRekorBuilder fulcioCAWithRekor;
    private PKIBuilder pki;
    private String policyType;
    private PublicKeyBuilder publicKey;

    public PolicyRootOfTrustFluent() {
    }

    public PolicyRootOfTrustFluent(PolicyRootOfTrust instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public FulcioCAWithRekor buildFulcioCAWithRekor() {
        return this.fulcioCAWithRekor != null ? this.fulcioCAWithRekor.build() : null;
    }

    public PKI buildPki() {
        return this.pki != null ? this.pki.build() : null;
    }

    public PublicKey buildPublicKey() {
        return this.publicKey != null ? this.publicKey.build() : null;
    }

    protected void copyInstance(PolicyRootOfTrust instance) {
        PolicyRootOfTrust policyRootOfTrust = instance = instance != null ? instance : new PolicyRootOfTrust();
        if (instance != null) {
            this.withFulcioCAWithRekor(instance.getFulcioCAWithRekor());
            this.withPki(instance.getPki());
            this.withPolicyType(instance.getPolicyType());
            this.withPublicKey(instance.getPublicKey());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public FulcioCAWithRekorNested<A> editFulcioCAWithRekor() {
        return this.withNewFulcioCAWithRekorLike(Optional.ofNullable(this.buildFulcioCAWithRekor()).orElse(null));
    }

    public FulcioCAWithRekorNested<A> editOrNewFulcioCAWithRekor() {
        return this.withNewFulcioCAWithRekorLike(Optional.ofNullable(this.buildFulcioCAWithRekor()).orElse(new FulcioCAWithRekorBuilder().build()));
    }

    public FulcioCAWithRekorNested<A> editOrNewFulcioCAWithRekorLike(FulcioCAWithRekor item) {
        return this.withNewFulcioCAWithRekorLike(Optional.ofNullable(this.buildFulcioCAWithRekor()).orElse(item));
    }

    public PkiNested<A> editOrNewPki() {
        return this.withNewPkiLike(Optional.ofNullable(this.buildPki()).orElse(new PKIBuilder().build()));
    }

    public PkiNested<A> editOrNewPkiLike(PKI item) {
        return this.withNewPkiLike(Optional.ofNullable(this.buildPki()).orElse(item));
    }

    public PublicKeyNested<A> editOrNewPublicKey() {
        return this.withNewPublicKeyLike(Optional.ofNullable(this.buildPublicKey()).orElse(new PublicKeyBuilder().build()));
    }

    public PublicKeyNested<A> editOrNewPublicKeyLike(PublicKey item) {
        return this.withNewPublicKeyLike(Optional.ofNullable(this.buildPublicKey()).orElse(item));
    }

    public PkiNested<A> editPki() {
        return this.withNewPkiLike(Optional.ofNullable(this.buildPki()).orElse(null));
    }

    public PublicKeyNested<A> editPublicKey() {
        return this.withNewPublicKeyLike(Optional.ofNullable(this.buildPublicKey()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PolicyRootOfTrustFluent that = (PolicyRootOfTrustFluent)((Object)o);
        if (!Objects.equals((Object)this.fulcioCAWithRekor, (Object)that.fulcioCAWithRekor)) {
            return false;
        }
        if (!Objects.equals((Object)this.pki, (Object)that.pki)) {
            return false;
        }
        if (!Objects.equals(this.policyType, that.policyType)) {
            return false;
        }
        if (!Objects.equals((Object)this.publicKey, (Object)that.publicKey)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getPolicyType() {
        return this.policyType;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasFulcioCAWithRekor() {
        return this.fulcioCAWithRekor != null;
    }

    public boolean hasPki() {
        return this.pki != null;
    }

    public boolean hasPolicyType() {
        return this.policyType != null;
    }

    public boolean hasPublicKey() {
        return this.publicKey != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fulcioCAWithRekor, this.pki, this.policyType, this.publicKey, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.fulcioCAWithRekor != null) {
            sb.append("fulcioCAWithRekor:");
            sb.append((Object)this.fulcioCAWithRekor);
            sb.append(",");
        }
        if (this.pki != null) {
            sb.append("pki:");
            sb.append((Object)this.pki);
            sb.append(",");
        }
        if (this.policyType != null) {
            sb.append("policyType:");
            sb.append(this.policyType);
            sb.append(",");
        }
        if (this.publicKey != null) {
            sb.append("publicKey:");
            sb.append((Object)this.publicKey);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withFulcioCAWithRekor(FulcioCAWithRekor fulcioCAWithRekor) {
        this._visitables.remove((Object)"fulcioCAWithRekor");
        if (fulcioCAWithRekor != null) {
            this.fulcioCAWithRekor = new FulcioCAWithRekorBuilder(fulcioCAWithRekor);
            this._visitables.get((Object)"fulcioCAWithRekor").add(this.fulcioCAWithRekor);
        } else {
            this.fulcioCAWithRekor = null;
            this._visitables.get((Object)"fulcioCAWithRekor").remove((Object)this.fulcioCAWithRekor);
        }
        return (A)((Object)this);
    }

    public FulcioCAWithRekorNested<A> withNewFulcioCAWithRekor() {
        return new FulcioCAWithRekorNested(null);
    }

    public FulcioCAWithRekorNested<A> withNewFulcioCAWithRekorLike(FulcioCAWithRekor item) {
        return new FulcioCAWithRekorNested(item);
    }

    public PkiNested<A> withNewPki() {
        return new PkiNested(null);
    }

    public PkiNested<A> withNewPkiLike(PKI item) {
        return new PkiNested(item);
    }

    public PublicKeyNested<A> withNewPublicKey() {
        return new PublicKeyNested(null);
    }

    public A withNewPublicKey(String keyData, String rekorKeyData) {
        return this.withPublicKey(new PublicKey(keyData, rekorKeyData));
    }

    public PublicKeyNested<A> withNewPublicKeyLike(PublicKey item) {
        return new PublicKeyNested(item);
    }

    public A withPki(PKI pki) {
        this._visitables.remove((Object)"pki");
        if (pki != null) {
            this.pki = new PKIBuilder(pki);
            this._visitables.get((Object)"pki").add(this.pki);
        } else {
            this.pki = null;
            this._visitables.get((Object)"pki").remove((Object)this.pki);
        }
        return (A)((Object)this);
    }

    public A withPolicyType(String policyType) {
        this.policyType = policyType;
        return (A)((Object)this);
    }

    public A withPublicKey(PublicKey publicKey) {
        this._visitables.remove((Object)"publicKey");
        if (publicKey != null) {
            this.publicKey = new PublicKeyBuilder(publicKey);
            this._visitables.get((Object)"publicKey").add(this.publicKey);
        } else {
            this.publicKey = null;
            this._visitables.get((Object)"publicKey").remove((Object)this.publicKey);
        }
        return (A)((Object)this);
    }

    public class PublicKeyNested<N>
    extends PublicKeyFluent<PublicKeyNested<N>>
    implements Nested<N> {
        PublicKeyBuilder builder;

        PublicKeyNested(PublicKey item) {
            this.builder = new PublicKeyBuilder(this, item);
        }

        public N and() {
            return (N)PolicyRootOfTrustFluent.this.withPublicKey(this.builder.build());
        }

        public N endPublicKey() {
            return this.and();
        }
    }

    public class PkiNested<N>
    extends PKIFluent<PkiNested<N>>
    implements Nested<N> {
        PKIBuilder builder;

        PkiNested(PKI item) {
            this.builder = new PKIBuilder(this, item);
        }

        public N and() {
            return (N)PolicyRootOfTrustFluent.this.withPki(this.builder.build());
        }

        public N endPki() {
            return this.and();
        }
    }

    public class FulcioCAWithRekorNested<N>
    extends FulcioCAWithRekorFluent<FulcioCAWithRekorNested<N>>
    implements Nested<N> {
        FulcioCAWithRekorBuilder builder;

        FulcioCAWithRekorNested(FulcioCAWithRekor item) {
            this.builder = new FulcioCAWithRekorBuilder(this, item);
        }

        public N and() {
            return (N)PolicyRootOfTrustFluent.this.withFulcioCAWithRekor(this.builder.build());
        }

        public N endFulcioCAWithRekor() {
            return this.and();
        }
    }
}

