/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.PolicyIdentity;
import io.fabric8.openshift.api.model.config.v1.PolicyMatchExactRepository;
import io.fabric8.openshift.api.model.config.v1.PolicyMatchExactRepositoryBuilder;
import io.fabric8.openshift.api.model.config.v1.PolicyMatchExactRepositoryFluent;
import io.fabric8.openshift.api.model.config.v1.PolicyMatchRemapIdentity;
import io.fabric8.openshift.api.model.config.v1.PolicyMatchRemapIdentityBuilder;
import io.fabric8.openshift.api.model.config.v1.PolicyMatchRemapIdentityFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class PolicyIdentityFluent<A extends PolicyIdentityFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private PolicyMatchExactRepositoryBuilder exactRepository;
    private String matchPolicy;
    private PolicyMatchRemapIdentityBuilder remapIdentity;

    public PolicyIdentityFluent() {
    }

    public PolicyIdentityFluent(PolicyIdentity instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public PolicyMatchExactRepository buildExactRepository() {
        return this.exactRepository != null ? this.exactRepository.build() : null;
    }

    public PolicyMatchRemapIdentity buildRemapIdentity() {
        return this.remapIdentity != null ? this.remapIdentity.build() : null;
    }

    protected void copyInstance(PolicyIdentity instance) {
        PolicyIdentity policyIdentity = instance = instance != null ? instance : new PolicyIdentity();
        if (instance != null) {
            this.withExactRepository(instance.getExactRepository());
            this.withMatchPolicy(instance.getMatchPolicy());
            this.withRemapIdentity(instance.getRemapIdentity());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ExactRepositoryNested<A> editExactRepository() {
        return this.withNewExactRepositoryLike(Optional.ofNullable(this.buildExactRepository()).orElse(null));
    }

    public ExactRepositoryNested<A> editOrNewExactRepository() {
        return this.withNewExactRepositoryLike(Optional.ofNullable(this.buildExactRepository()).orElse(new PolicyMatchExactRepositoryBuilder().build()));
    }

    public ExactRepositoryNested<A> editOrNewExactRepositoryLike(PolicyMatchExactRepository item) {
        return this.withNewExactRepositoryLike(Optional.ofNullable(this.buildExactRepository()).orElse(item));
    }

    public RemapIdentityNested<A> editOrNewRemapIdentity() {
        return this.withNewRemapIdentityLike(Optional.ofNullable(this.buildRemapIdentity()).orElse(new PolicyMatchRemapIdentityBuilder().build()));
    }

    public RemapIdentityNested<A> editOrNewRemapIdentityLike(PolicyMatchRemapIdentity item) {
        return this.withNewRemapIdentityLike(Optional.ofNullable(this.buildRemapIdentity()).orElse(item));
    }

    public RemapIdentityNested<A> editRemapIdentity() {
        return this.withNewRemapIdentityLike(Optional.ofNullable(this.buildRemapIdentity()).orElse(null));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PolicyIdentityFluent that = (PolicyIdentityFluent)((Object)o);
        if (!Objects.equals((Object)this.exactRepository, (Object)that.exactRepository)) {
            return false;
        }
        if (!Objects.equals(this.matchPolicy, that.matchPolicy)) {
            return false;
        }
        if (!Objects.equals((Object)this.remapIdentity, (Object)that.remapIdentity)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getMatchPolicy() {
        return this.matchPolicy;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasExactRepository() {
        return this.exactRepository != null;
    }

    public boolean hasMatchPolicy() {
        return this.matchPolicy != null;
    }

    public boolean hasRemapIdentity() {
        return this.remapIdentity != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.exactRepository, this.matchPolicy, this.remapIdentity, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.exactRepository != null) {
            sb.append("exactRepository:");
            sb.append((Object)this.exactRepository);
            sb.append(",");
        }
        if (this.matchPolicy != null) {
            sb.append("matchPolicy:");
            sb.append(this.matchPolicy);
            sb.append(",");
        }
        if (this.remapIdentity != null) {
            sb.append("remapIdentity:");
            sb.append((Object)this.remapIdentity);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withExactRepository(PolicyMatchExactRepository exactRepository) {
        this._visitables.remove((Object)"exactRepository");
        if (exactRepository != null) {
            this.exactRepository = new PolicyMatchExactRepositoryBuilder(exactRepository);
            this._visitables.get((Object)"exactRepository").add(this.exactRepository);
        } else {
            this.exactRepository = null;
            this._visitables.get((Object)"exactRepository").remove((Object)this.exactRepository);
        }
        return (A)((Object)this);
    }

    public A withMatchPolicy(String matchPolicy) {
        this.matchPolicy = matchPolicy;
        return (A)((Object)this);
    }

    public ExactRepositoryNested<A> withNewExactRepository() {
        return new ExactRepositoryNested(null);
    }

    public A withNewExactRepository(String repository) {
        return this.withExactRepository(new PolicyMatchExactRepository(repository));
    }

    public ExactRepositoryNested<A> withNewExactRepositoryLike(PolicyMatchExactRepository item) {
        return new ExactRepositoryNested(item);
    }

    public RemapIdentityNested<A> withNewRemapIdentity() {
        return new RemapIdentityNested(null);
    }

    public A withNewRemapIdentity(String prefix, String signedPrefix) {
        return this.withRemapIdentity(new PolicyMatchRemapIdentity(prefix, signedPrefix));
    }

    public RemapIdentityNested<A> withNewRemapIdentityLike(PolicyMatchRemapIdentity item) {
        return new RemapIdentityNested(item);
    }

    public A withRemapIdentity(PolicyMatchRemapIdentity remapIdentity) {
        this._visitables.remove((Object)"remapIdentity");
        if (remapIdentity != null) {
            this.remapIdentity = new PolicyMatchRemapIdentityBuilder(remapIdentity);
            this._visitables.get((Object)"remapIdentity").add(this.remapIdentity);
        } else {
            this.remapIdentity = null;
            this._visitables.get((Object)"remapIdentity").remove((Object)this.remapIdentity);
        }
        return (A)((Object)this);
    }

    public class RemapIdentityNested<N>
    extends PolicyMatchRemapIdentityFluent<RemapIdentityNested<N>>
    implements Nested<N> {
        PolicyMatchRemapIdentityBuilder builder;

        RemapIdentityNested(PolicyMatchRemapIdentity item) {
            this.builder = new PolicyMatchRemapIdentityBuilder(this, item);
        }

        public N and() {
            return (N)PolicyIdentityFluent.this.withRemapIdentity(this.builder.build());
        }

        public N endRemapIdentity() {
            return this.and();
        }
    }

    public class ExactRepositoryNested<N>
    extends PolicyMatchExactRepositoryFluent<ExactRepositoryNested<N>>
    implements Nested<N> {
        PolicyMatchExactRepositoryBuilder builder;

        ExactRepositoryNested(PolicyMatchExactRepository item) {
            this.builder = new PolicyMatchExactRepositoryBuilder(this, item);
        }

        public N and() {
            return (N)PolicyIdentityFluent.this.withExactRepository(this.builder.build());
        }

        public N endExactRepository() {
            return this.and();
        }
    }
}

