/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.AWSKMSConfig;
import io.fabric8.openshift.api.model.config.v1.AWSKMSConfigBuilder;
import io.fabric8.openshift.api.model.config.v1.AWSKMSConfigFluent;
import io.fabric8.openshift.api.model.config.v1.KMSConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class KMSConfigFluent<A extends KMSConfigFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private AWSKMSConfigBuilder aws;
    private String type;

    public KMSConfigFluent() {
    }

    public KMSConfigFluent(KMSConfig instance) {
        this.copyInstance(instance);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public AWSKMSConfig buildAws() {
        return this.aws != null ? this.aws.build() : null;
    }

    protected void copyInstance(KMSConfig instance) {
        KMSConfig kMSConfig = instance = instance != null ? instance : new KMSConfig();
        if (instance != null) {
            this.withAws(instance.getAws());
            this.withType(instance.getType());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public AwsNested<A> editAws() {
        return this.withNewAwsLike(Optional.ofNullable(this.buildAws()).orElse(null));
    }

    public AwsNested<A> editOrNewAws() {
        return this.withNewAwsLike(Optional.ofNullable(this.buildAws()).orElse(new AWSKMSConfigBuilder().build()));
    }

    public AwsNested<A> editOrNewAwsLike(AWSKMSConfig item) {
        return this.withNewAwsLike(Optional.ofNullable(this.buildAws()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KMSConfigFluent that = (KMSConfigFluent)((Object)o);
        if (!Objects.equals((Object)this.aws, (Object)that.aws)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getType() {
        return this.type;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasAws() {
        return this.aws != null;
    }

    public boolean hasType() {
        return this.type != null;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.aws, this.type, this.additionalProperties});
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.aws != null) {
            sb.append("aws:");
            sb.append((Object)this.aws);
            sb.append(",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withAws(AWSKMSConfig aws) {
        this._visitables.remove((Object)"aws");
        if (aws != null) {
            this.aws = new AWSKMSConfigBuilder(aws);
            this._visitables.get((Object)"aws").add(this.aws);
        } else {
            this.aws = null;
            this._visitables.get((Object)"aws").remove((Object)this.aws);
        }
        return (A)((Object)this);
    }

    public AwsNested<A> withNewAws() {
        return new AwsNested(null);
    }

    public A withNewAws(String keyARN, String region) {
        return this.withAws(new AWSKMSConfig(keyARN, region));
    }

    public AwsNested<A> withNewAwsLike(AWSKMSConfig item) {
        return new AwsNested(item);
    }

    public A withType(String type) {
        this.type = type;
        return (A)((Object)this);
    }

    public class AwsNested<N>
    extends AWSKMSConfigFluent<AwsNested<N>>
    implements Nested<N> {
        AWSKMSConfigBuilder builder;

        AwsNested(AWSKMSConfig item) {
            this.builder = new AWSKMSConfigBuilder(this, item);
        }

        public N and() {
            return (N)KMSConfigFluent.this.withAws(this.builder.build());
        }

        public N endAws() {
            return this.and();
        }
    }
}

