/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.IBMCloudPlatformSpec;
import io.fabric8.openshift.api.model.config.v1.IBMCloudServiceEndpoint;
import io.fabric8.openshift.api.model.config.v1.IBMCloudServiceEndpointBuilder;
import io.fabric8.openshift.api.model.config.v1.IBMCloudServiceEndpointFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class IBMCloudPlatformSpecFluent<A extends IBMCloudPlatformSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private ArrayList<IBMCloudServiceEndpointBuilder> serviceEndpoints = new ArrayList();

    public IBMCloudPlatformSpecFluent() {
    }

    public IBMCloudPlatformSpecFluent(IBMCloudPlatformSpec instance) {
        this.copyInstance(instance);
    }

    public A addAllToServiceEndpoints(Collection<IBMCloudServiceEndpoint> items) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList();
        }
        for (IBMCloudServiceEndpoint item : items) {
            IBMCloudServiceEndpointBuilder builder = new IBMCloudServiceEndpointBuilder(item);
            this._visitables.get((Object)"serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        }
        return (A)((Object)this);
    }

    public ServiceEndpointsNested<A> addNewServiceEndpoint() {
        return new ServiceEndpointsNested(-1, null);
    }

    public A addNewServiceEndpoint(String name, String url) {
        return this.addToServiceEndpoints(new IBMCloudServiceEndpoint(name, url));
    }

    public ServiceEndpointsNested<A> addNewServiceEndpointLike(IBMCloudServiceEndpoint item) {
        return new ServiceEndpointsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToServiceEndpoints(IBMCloudServiceEndpoint ... items) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList();
        }
        for (IBMCloudServiceEndpoint item : items) {
            IBMCloudServiceEndpointBuilder builder = new IBMCloudServiceEndpointBuilder(item);
            this._visitables.get((Object)"serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToServiceEndpoints(int index, IBMCloudServiceEndpoint item) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList();
        }
        IBMCloudServiceEndpointBuilder builder = new IBMCloudServiceEndpointBuilder(item);
        if (index < 0 || index >= this.serviceEndpoints.size()) {
            this._visitables.get((Object)"serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        } else {
            this._visitables.get((Object)"serviceEndpoints").add(builder);
            this.serviceEndpoints.add(index, builder);
        }
        return (A)((Object)this);
    }

    public IBMCloudServiceEndpoint buildFirstServiceEndpoint() {
        return this.serviceEndpoints.get(0).build();
    }

    public IBMCloudServiceEndpoint buildLastServiceEndpoint() {
        return this.serviceEndpoints.get(this.serviceEndpoints.size() - 1).build();
    }

    public IBMCloudServiceEndpoint buildMatchingServiceEndpoint(Predicate<IBMCloudServiceEndpointBuilder> predicate) {
        for (IBMCloudServiceEndpointBuilder item : this.serviceEndpoints) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public IBMCloudServiceEndpoint buildServiceEndpoint(int index) {
        return this.serviceEndpoints.get(index).build();
    }

    public List<IBMCloudServiceEndpoint> buildServiceEndpoints() {
        return this.serviceEndpoints != null ? IBMCloudPlatformSpecFluent.build(this.serviceEndpoints) : null;
    }

    protected void copyInstance(IBMCloudPlatformSpec instance) {
        IBMCloudPlatformSpec iBMCloudPlatformSpec = instance = instance != null ? instance : new IBMCloudPlatformSpec();
        if (instance != null) {
            this.withServiceEndpoints(instance.getServiceEndpoints());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ServiceEndpointsNested<A> editFirstServiceEndpoint() {
        if (this.serviceEndpoints.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "serviceEndpoints"));
        }
        return this.setNewServiceEndpointLike(0, this.buildServiceEndpoint(0));
    }

    public ServiceEndpointsNested<A> editLastServiceEndpoint() {
        int index = this.serviceEndpoints.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "serviceEndpoints"));
        }
        return this.setNewServiceEndpointLike(index, this.buildServiceEndpoint(index));
    }

    public ServiceEndpointsNested<A> editMatchingServiceEndpoint(Predicate<IBMCloudServiceEndpointBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.serviceEndpoints.size(); ++i) {
            if (!predicate.test(this.serviceEndpoints.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "serviceEndpoints"));
        }
        return this.setNewServiceEndpointLike(index, this.buildServiceEndpoint(index));
    }

    public ServiceEndpointsNested<A> editServiceEndpoint(int index) {
        if (this.serviceEndpoints.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "serviceEndpoints"));
        }
        return this.setNewServiceEndpointLike(index, this.buildServiceEndpoint(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IBMCloudPlatformSpecFluent that = (IBMCloudPlatformSpecFluent)((Object)o);
        if (!Objects.equals(this.serviceEndpoints, that.serviceEndpoints)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasMatchingServiceEndpoint(Predicate<IBMCloudServiceEndpointBuilder> predicate) {
        for (IBMCloudServiceEndpointBuilder item : this.serviceEndpoints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasServiceEndpoints() {
        return this.serviceEndpoints != null && !this.serviceEndpoints.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(this.serviceEndpoints, this.additionalProperties);
    }

    public A removeAllFromServiceEndpoints(Collection<IBMCloudServiceEndpoint> items) {
        if (this.serviceEndpoints == null) {
            return (A)((Object)this);
        }
        for (IBMCloudServiceEndpoint item : items) {
            IBMCloudServiceEndpointBuilder builder = new IBMCloudServiceEndpointBuilder(item);
            this._visitables.get((Object)"serviceEndpoints").remove((Object)builder);
            this.serviceEndpoints.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromServiceEndpoints(IBMCloudServiceEndpoint ... items) {
        if (this.serviceEndpoints == null) {
            return (A)((Object)this);
        }
        for (IBMCloudServiceEndpoint item : items) {
            IBMCloudServiceEndpointBuilder builder = new IBMCloudServiceEndpointBuilder(item);
            this._visitables.get((Object)"serviceEndpoints").remove((Object)builder);
            this.serviceEndpoints.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromServiceEndpoints(Predicate<IBMCloudServiceEndpointBuilder> predicate) {
        if (this.serviceEndpoints == null) {
            return (A)((Object)this);
        }
        Iterator<IBMCloudServiceEndpointBuilder> each = this.serviceEndpoints.iterator();
        List visitables = this._visitables.get((Object)"serviceEndpoints");
        while (each.hasNext()) {
            IBMCloudServiceEndpointBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public ServiceEndpointsNested<A> setNewServiceEndpointLike(int index, IBMCloudServiceEndpoint item) {
        return new ServiceEndpointsNested(index, item);
    }

    public A setToServiceEndpoints(int index, IBMCloudServiceEndpoint item) {
        if (this.serviceEndpoints == null) {
            this.serviceEndpoints = new ArrayList();
        }
        IBMCloudServiceEndpointBuilder builder = new IBMCloudServiceEndpointBuilder(item);
        if (index < 0 || index >= this.serviceEndpoints.size()) {
            this._visitables.get((Object)"serviceEndpoints").add(builder);
            this.serviceEndpoints.add(builder);
        } else {
            this._visitables.get((Object)"serviceEndpoints").add(builder);
            this.serviceEndpoints.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.serviceEndpoints != null && !this.serviceEndpoints.isEmpty()) {
            sb.append("serviceEndpoints:");
            sb.append(this.serviceEndpoints);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withServiceEndpoints(List<IBMCloudServiceEndpoint> serviceEndpoints) {
        if (this.serviceEndpoints != null) {
            this._visitables.get((Object)"serviceEndpoints").clear();
        }
        if (serviceEndpoints != null) {
            this.serviceEndpoints = new ArrayList();
            for (IBMCloudServiceEndpoint item : serviceEndpoints) {
                this.addToServiceEndpoints(item);
            }
        } else {
            this.serviceEndpoints = null;
        }
        return (A)((Object)this);
    }

    public A withServiceEndpoints(IBMCloudServiceEndpoint ... serviceEndpoints) {
        if (this.serviceEndpoints != null) {
            this.serviceEndpoints.clear();
            this._visitables.remove((Object)"serviceEndpoints");
        }
        if (serviceEndpoints != null) {
            for (IBMCloudServiceEndpoint item : serviceEndpoints) {
                this.addToServiceEndpoints(item);
            }
        }
        return (A)((Object)this);
    }

    public class ServiceEndpointsNested<N>
    extends IBMCloudServiceEndpointFluent<ServiceEndpointsNested<N>>
    implements Nested<N> {
        IBMCloudServiceEndpointBuilder builder;
        int index;

        ServiceEndpointsNested(int index, IBMCloudServiceEndpoint item) {
            this.index = index;
            this.builder = new IBMCloudServiceEndpointBuilder(this, item);
        }

        public N and() {
            return (N)IBMCloudPlatformSpecFluent.this.setToServiceEndpoints(this.index, this.builder.build());
        }

        public N endServiceEndpoint() {
            return this.and();
        }
    }
}

