/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.config.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.config.v1.AzurePlatformStatus;
import io.fabric8.openshift.api.model.config.v1.AzureResourceTag;
import io.fabric8.openshift.api.model.config.v1.AzureResourceTagBuilder;
import io.fabric8.openshift.api.model.config.v1.AzureResourceTagFluent;
import io.fabric8.openshift.api.model.config.v1.CloudLoadBalancerConfig;
import io.fabric8.openshift.api.model.config.v1.CloudLoadBalancerConfigBuilder;
import io.fabric8.openshift.api.model.config.v1.CloudLoadBalancerConfigFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class AzurePlatformStatusFluent<A extends AzurePlatformStatusFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String armEndpoint;
    private CloudLoadBalancerConfigBuilder cloudLoadBalancerConfig;
    private String cloudName;
    private String networkResourceGroupName;
    private String resourceGroupName;
    private ArrayList<AzureResourceTagBuilder> resourceTags = new ArrayList();

    public AzurePlatformStatusFluent() {
    }

    public AzurePlatformStatusFluent(AzurePlatformStatus instance) {
        this.copyInstance(instance);
    }

    public A addAllToResourceTags(Collection<AzureResourceTag> items) {
        if (this.resourceTags == null) {
            this.resourceTags = new ArrayList();
        }
        for (AzureResourceTag item : items) {
            AzureResourceTagBuilder builder = new AzureResourceTagBuilder(item);
            this._visitables.get((Object)"resourceTags").add(builder);
            this.resourceTags.add(builder);
        }
        return (A)((Object)this);
    }

    public ResourceTagsNested<A> addNewResourceTag() {
        return new ResourceTagsNested(-1, null);
    }

    public A addNewResourceTag(String key, String value) {
        return this.addToResourceTags(new AzureResourceTag(key, value));
    }

    public ResourceTagsNested<A> addNewResourceTagLike(AzureResourceTag item) {
        return new ResourceTagsNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToResourceTags(AzureResourceTag ... items) {
        if (this.resourceTags == null) {
            this.resourceTags = new ArrayList();
        }
        for (AzureResourceTag item : items) {
            AzureResourceTagBuilder builder = new AzureResourceTagBuilder(item);
            this._visitables.get((Object)"resourceTags").add(builder);
            this.resourceTags.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToResourceTags(int index, AzureResourceTag item) {
        if (this.resourceTags == null) {
            this.resourceTags = new ArrayList();
        }
        AzureResourceTagBuilder builder = new AzureResourceTagBuilder(item);
        if (index < 0 || index >= this.resourceTags.size()) {
            this._visitables.get((Object)"resourceTags").add(builder);
            this.resourceTags.add(builder);
        } else {
            this._visitables.get((Object)"resourceTags").add(builder);
            this.resourceTags.add(index, builder);
        }
        return (A)((Object)this);
    }

    public CloudLoadBalancerConfig buildCloudLoadBalancerConfig() {
        return this.cloudLoadBalancerConfig != null ? this.cloudLoadBalancerConfig.build() : null;
    }

    public AzureResourceTag buildFirstResourceTag() {
        return this.resourceTags.get(0).build();
    }

    public AzureResourceTag buildLastResourceTag() {
        return this.resourceTags.get(this.resourceTags.size() - 1).build();
    }

    public AzureResourceTag buildMatchingResourceTag(Predicate<AzureResourceTagBuilder> predicate) {
        for (AzureResourceTagBuilder item : this.resourceTags) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public AzureResourceTag buildResourceTag(int index) {
        return this.resourceTags.get(index).build();
    }

    public List<AzureResourceTag> buildResourceTags() {
        return this.resourceTags != null ? AzurePlatformStatusFluent.build(this.resourceTags) : null;
    }

    protected void copyInstance(AzurePlatformStatus instance) {
        AzurePlatformStatus azurePlatformStatus = instance = instance != null ? instance : new AzurePlatformStatus();
        if (instance != null) {
            this.withArmEndpoint(instance.getArmEndpoint());
            this.withCloudLoadBalancerConfig(instance.getCloudLoadBalancerConfig());
            this.withCloudName(instance.getCloudName());
            this.withNetworkResourceGroupName(instance.getNetworkResourceGroupName());
            this.withResourceGroupName(instance.getResourceGroupName());
            this.withResourceTags(instance.getResourceTags());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public CloudLoadBalancerConfigNested<A> editCloudLoadBalancerConfig() {
        return this.withNewCloudLoadBalancerConfigLike(Optional.ofNullable(this.buildCloudLoadBalancerConfig()).orElse(null));
    }

    public ResourceTagsNested<A> editFirstResourceTag() {
        if (this.resourceTags.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "resourceTags"));
        }
        return this.setNewResourceTagLike(0, this.buildResourceTag(0));
    }

    public ResourceTagsNested<A> editLastResourceTag() {
        int index = this.resourceTags.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "resourceTags"));
        }
        return this.setNewResourceTagLike(index, this.buildResourceTag(index));
    }

    public ResourceTagsNested<A> editMatchingResourceTag(Predicate<AzureResourceTagBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.resourceTags.size(); ++i) {
            if (!predicate.test(this.resourceTags.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "resourceTags"));
        }
        return this.setNewResourceTagLike(index, this.buildResourceTag(index));
    }

    public CloudLoadBalancerConfigNested<A> editOrNewCloudLoadBalancerConfig() {
        return this.withNewCloudLoadBalancerConfigLike(Optional.ofNullable(this.buildCloudLoadBalancerConfig()).orElse(new CloudLoadBalancerConfigBuilder().build()));
    }

    public CloudLoadBalancerConfigNested<A> editOrNewCloudLoadBalancerConfigLike(CloudLoadBalancerConfig item) {
        return this.withNewCloudLoadBalancerConfigLike(Optional.ofNullable(this.buildCloudLoadBalancerConfig()).orElse(item));
    }

    public ResourceTagsNested<A> editResourceTag(int index) {
        if (this.resourceTags.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "resourceTags"));
        }
        return this.setNewResourceTagLike(index, this.buildResourceTag(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AzurePlatformStatusFluent that = (AzurePlatformStatusFluent)((Object)o);
        if (!Objects.equals(this.armEndpoint, that.armEndpoint)) {
            return false;
        }
        if (!Objects.equals((Object)this.cloudLoadBalancerConfig, (Object)that.cloudLoadBalancerConfig)) {
            return false;
        }
        if (!Objects.equals(this.cloudName, that.cloudName)) {
            return false;
        }
        if (!Objects.equals(this.networkResourceGroupName, that.networkResourceGroupName)) {
            return false;
        }
        if (!Objects.equals(this.resourceGroupName, that.resourceGroupName)) {
            return false;
        }
        if (!Objects.equals(this.resourceTags, that.resourceTags)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getArmEndpoint() {
        return this.armEndpoint;
    }

    public String getCloudName() {
        return this.cloudName;
    }

    public String getNetworkResourceGroupName() {
        return this.networkResourceGroupName;
    }

    public String getResourceGroupName() {
        return this.resourceGroupName;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasArmEndpoint() {
        return this.armEndpoint != null;
    }

    public boolean hasCloudLoadBalancerConfig() {
        return this.cloudLoadBalancerConfig != null;
    }

    public boolean hasCloudName() {
        return this.cloudName != null;
    }

    public boolean hasMatchingResourceTag(Predicate<AzureResourceTagBuilder> predicate) {
        for (AzureResourceTagBuilder item : this.resourceTags) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNetworkResourceGroupName() {
        return this.networkResourceGroupName != null;
    }

    public boolean hasResourceGroupName() {
        return this.resourceGroupName != null;
    }

    public boolean hasResourceTags() {
        return this.resourceTags != null && !this.resourceTags.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.armEndpoint, this.cloudLoadBalancerConfig, this.cloudName, this.networkResourceGroupName, this.resourceGroupName, this.resourceTags, this.additionalProperties});
    }

    public A removeAllFromResourceTags(Collection<AzureResourceTag> items) {
        if (this.resourceTags == null) {
            return (A)((Object)this);
        }
        for (AzureResourceTag item : items) {
            AzureResourceTagBuilder builder = new AzureResourceTagBuilder(item);
            this._visitables.get((Object)"resourceTags").remove((Object)builder);
            this.resourceTags.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromResourceTags(AzureResourceTag ... items) {
        if (this.resourceTags == null) {
            return (A)((Object)this);
        }
        for (AzureResourceTag item : items) {
            AzureResourceTagBuilder builder = new AzureResourceTagBuilder(item);
            this._visitables.get((Object)"resourceTags").remove((Object)builder);
            this.resourceTags.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromResourceTags(Predicate<AzureResourceTagBuilder> predicate) {
        if (this.resourceTags == null) {
            return (A)((Object)this);
        }
        Iterator<AzureResourceTagBuilder> each = this.resourceTags.iterator();
        List visitables = this._visitables.get((Object)"resourceTags");
        while (each.hasNext()) {
            AzureResourceTagBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public ResourceTagsNested<A> setNewResourceTagLike(int index, AzureResourceTag item) {
        return new ResourceTagsNested(index, item);
    }

    public A setToResourceTags(int index, AzureResourceTag item) {
        if (this.resourceTags == null) {
            this.resourceTags = new ArrayList();
        }
        AzureResourceTagBuilder builder = new AzureResourceTagBuilder(item);
        if (index < 0 || index >= this.resourceTags.size()) {
            this._visitables.get((Object)"resourceTags").add(builder);
            this.resourceTags.add(builder);
        } else {
            this._visitables.get((Object)"resourceTags").add(builder);
            this.resourceTags.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.armEndpoint != null) {
            sb.append("armEndpoint:");
            sb.append(this.armEndpoint);
            sb.append(",");
        }
        if (this.cloudLoadBalancerConfig != null) {
            sb.append("cloudLoadBalancerConfig:");
            sb.append((Object)this.cloudLoadBalancerConfig);
            sb.append(",");
        }
        if (this.cloudName != null) {
            sb.append("cloudName:");
            sb.append(this.cloudName);
            sb.append(",");
        }
        if (this.networkResourceGroupName != null) {
            sb.append("networkResourceGroupName:");
            sb.append(this.networkResourceGroupName);
            sb.append(",");
        }
        if (this.resourceGroupName != null) {
            sb.append("resourceGroupName:");
            sb.append(this.resourceGroupName);
            sb.append(",");
        }
        if (this.resourceTags != null && !this.resourceTags.isEmpty()) {
            sb.append("resourceTags:");
            sb.append(this.resourceTags);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withArmEndpoint(String armEndpoint) {
        this.armEndpoint = armEndpoint;
        return (A)((Object)this);
    }

    public A withCloudLoadBalancerConfig(CloudLoadBalancerConfig cloudLoadBalancerConfig) {
        this._visitables.remove((Object)"cloudLoadBalancerConfig");
        if (cloudLoadBalancerConfig != null) {
            this.cloudLoadBalancerConfig = new CloudLoadBalancerConfigBuilder(cloudLoadBalancerConfig);
            this._visitables.get((Object)"cloudLoadBalancerConfig").add(this.cloudLoadBalancerConfig);
        } else {
            this.cloudLoadBalancerConfig = null;
            this._visitables.get((Object)"cloudLoadBalancerConfig").remove((Object)this.cloudLoadBalancerConfig);
        }
        return (A)((Object)this);
    }

    public A withCloudName(String cloudName) {
        this.cloudName = cloudName;
        return (A)((Object)this);
    }

    public A withNetworkResourceGroupName(String networkResourceGroupName) {
        this.networkResourceGroupName = networkResourceGroupName;
        return (A)((Object)this);
    }

    public CloudLoadBalancerConfigNested<A> withNewCloudLoadBalancerConfig() {
        return new CloudLoadBalancerConfigNested(null);
    }

    public CloudLoadBalancerConfigNested<A> withNewCloudLoadBalancerConfigLike(CloudLoadBalancerConfig item) {
        return new CloudLoadBalancerConfigNested(item);
    }

    public A withResourceGroupName(String resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return (A)((Object)this);
    }

    public A withResourceTags(List<AzureResourceTag> resourceTags) {
        if (this.resourceTags != null) {
            this._visitables.get((Object)"resourceTags").clear();
        }
        if (resourceTags != null) {
            this.resourceTags = new ArrayList();
            for (AzureResourceTag item : resourceTags) {
                this.addToResourceTags(item);
            }
        } else {
            this.resourceTags = null;
        }
        return (A)((Object)this);
    }

    public A withResourceTags(AzureResourceTag ... resourceTags) {
        if (this.resourceTags != null) {
            this.resourceTags.clear();
            this._visitables.remove((Object)"resourceTags");
        }
        if (resourceTags != null) {
            for (AzureResourceTag item : resourceTags) {
                this.addToResourceTags(item);
            }
        }
        return (A)((Object)this);
    }

    public class ResourceTagsNested<N>
    extends AzureResourceTagFluent<ResourceTagsNested<N>>
    implements Nested<N> {
        AzureResourceTagBuilder builder;
        int index;

        ResourceTagsNested(int index, AzureResourceTag item) {
            this.index = index;
            this.builder = new AzureResourceTagBuilder(this, item);
        }

        public N and() {
            return (N)AzurePlatformStatusFluent.this.setToResourceTags(this.index, this.builder.build());
        }

        public N endResourceTag() {
            return this.and();
        }
    }

    public class CloudLoadBalancerConfigNested<N>
    extends CloudLoadBalancerConfigFluent<CloudLoadBalancerConfigNested<N>>
    implements Nested<N> {
        CloudLoadBalancerConfigBuilder builder;

        CloudLoadBalancerConfigNested(CloudLoadBalancerConfig item) {
            this.builder = new CloudLoadBalancerConfigBuilder(this, item);
        }

        public N and() {
            return (N)AzurePlatformStatusFluent.this.withCloudLoadBalancerConfig(this.builder.build());
        }

        public N endCloudLoadBalancerConfig() {
            return this.and();
        }
    }
}

